/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.util.Spacing;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.HorizontalLineWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.MoveMode;
import me.roundaround.armorstands.util.MoveUnits;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_5676;

public class ArmorStandMoveScreen
extends AbstractArmorStandScreen {
    private static final int MINI_BUTTON_WIDTH = 28;
    private static final int BUTTON_WIDTH = 46;
    private static final int BUTTON_HEIGHT = 16;
    private static final int LARGE_BUTTON_WIDTH = 118;
    private static final List<class_2350> DIRECTIONS = List.of(class_2350.field_11036, class_2350.field_11033, class_2350.field_11035, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039);
    private final HashMap<class_2350, LabelWidget> directionLabels = new HashMap();
    private final ArrayList<MoveButtonRef> moveButtons = new ArrayList();
    private LabelWidget playerPosLabel;
    private LabelWidget playerBlockLabel;
    private LabelWidget standPosLabel;
    private LabelWidget standBlockLabel;
    private class_2350 prevFacing;
    private LabelWidget facingLabel;
    private class_5676<MoveUnits> unitsButton;
    private MoveMode mode = MoveMode.RELATIVE;
    private MoveUnits units = MoveUnits.PIXELS;

    public ArmorStandMoveScreen(ArmorStandScreenHandler armorStandScreenHandler) {
        super(armorStandScreenHandler, ScreenType.MOVE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.MOVE;
    }

    @Override
    protected void populateLayout() {
        super.populateLayout();
        this.initTopLeft();
        this.initBottomLeft();
        this.initBottomRight();
    }

    private void initTopLeft() {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(12).defaultOffAxisContentAlignStart();
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(1).defaultOffAxisContentAlignStart();
        linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.current.player")).bgColor(BACKGROUND_COLOR).build());
        this.playerPosLabel = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, ArmorStandMoveScreen.getCurrentPosText((class_1297)this.getPlayer())).bgColor(BACKGROUND_COLOR).build());
        this.playerBlockLabel = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, ArmorStandMoveScreen.getCurrentBlockPosText((class_1297)this.getPlayer())).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(linearLayoutWidget2);
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.vertical().spacing(1).defaultOffAxisContentAlignStart();
        linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.current.stand")).bgColor(BACKGROUND_COLOR).build());
        this.standPosLabel = linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, ArmorStandMoveScreen.getCurrentPosText((class_1297)this.getArmorStand())).bgColor(BACKGROUND_COLOR).build());
        this.standBlockLabel = linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, ArmorStandMoveScreen.getCurrentBlockPosText((class_1297)this.getArmorStand())).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(linearLayoutWidget3);
        this.layout.topLeft.add(new HorizontalLineWidget(this.utilRow.method_25368() - 8).margin(12), linearLayoutCellConfigurator -> linearLayoutCellConfigurator.margin(Spacing.of(0, 0, 0, 4)));
        this.layout.topLeft.add(linearLayoutWidget);
    }

    private void initBottomLeft() {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignStart();
        linearLayoutWidget.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.move.snap")).bgColor(BACKGROUND_COLOR).build());
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2);
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.move.snap.standing"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.SNAP_STANDING)).method_46437(46, 16).method_46431());
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.move.snap.sitting"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.SNAP_SITTING)).method_46437(46, 16).method_46431());
        linearLayoutWidget.add(linearLayoutWidget2);
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.horizontal().spacing(2);
        linearLayoutWidget3.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.move.snap.corner"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.SNAP_CORNER)).method_46437(46, 16).method_46431());
        linearLayoutWidget3.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.move.snap.center"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.SNAP_CENTER)).method_46437(46, 16).method_46431());
        linearLayoutWidget3.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.move.snap.player"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.SNAP_PLAYER)).method_46437(46, 16).method_46431());
        linearLayoutWidget.add(linearLayoutWidget3);
        this.layout.bottomLeft.add(linearLayoutWidget);
    }

    private void initBottomRight() {
        this.layout.bottomRight.defaultOffAxisContentAlignEnd();
        this.layout.bottomRight.add(class_5676.method_32606(MoveMode::getOptionValueText).method_32624((Object[])MoveMode.values()).method_32619((Object)this.mode).method_57720(MoveMode.getOptionLabelText(), this::onMoveModeChange), (linearLayoutWidget, class_56762) -> class_56762.method_55445(118, 16));
        this.unitsButton = this.layout.bottomRight.add(class_5676.method_32606(MoveUnits::getOptionValueText).method_32624((Object[])MoveUnits.values()).method_32619((Object)this.units).method_57720(MoveUnits.getOptionLabelText(), this::onMoveUnitsChange), (linearLayoutWidget, class_56762) -> class_56762.method_55445(118, 16));
        this.layout.bottomRight.add(FillerWidget.ofHeight(8));
        this.facingLabel = this.layout.bottomRight.add(LabelWidget.builder(this.field_22793, ArmorStandMoveScreen.getFacingText(this.getCurrentFacing())).bgColor(BACKGROUND_COLOR).build());
        DIRECTIONS.forEach(this::initDirectionRow);
    }

    private void initDirectionRow(class_2350 class_23502) {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.horizontal().spacing(2).defaultOffAxisContentAlignCenter();
        LabelWidget labelWidget = LabelWidget.builder(this.field_22793, this.mode.getDirectionText(class_23502)).bgColor(BACKGROUND_COLOR).build();
        this.directionLabels.put(class_23502, labelWidget);
        linearLayoutWidget.add(labelWidget);
        linearLayoutWidget.add(this.createMoveButton(class_23502, 1));
        linearLayoutWidget.add(this.createMoveButton(class_23502, 2));
        linearLayoutWidget.add(this.createMoveButton(class_23502, 3));
        this.layout.bottomRight.add(linearLayoutWidget);
    }

    private class_4185 createMoveButton(class_2350 class_23502, int n) {
        MoveButtonRef moveButtonRef = new MoveButtonRef(class_23502, n, this.mode, this.units);
        this.moveButtons.add(moveButtonRef);
        return moveButtonRef.getButton();
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.playerPosLabel.setText(ArmorStandMoveScreen.getCurrentPosText((class_1297)this.getPlayer()));
        this.playerBlockLabel.setText(ArmorStandMoveScreen.getCurrentBlockPosText((class_1297)this.getPlayer()));
        this.standPosLabel.setText(ArmorStandMoveScreen.getCurrentPosText((class_1297)this.getArmorStand()));
        this.standBlockLabel.setText(ArmorStandMoveScreen.getCurrentBlockPosText((class_1297)this.getArmorStand()));
        class_2350 class_23502 = this.getCurrentFacing();
        if (!class_23502.equals((Object)this.prevFacing)) {
            this.facingLabel.setText(ArmorStandMoveScreen.getFacingText(this.getCurrentFacing()));
            this.layout.method_48222();
        }
        this.prevFacing = class_23502;
    }

    private void onMoveModeChange(class_5676<MoveMode> class_56762, MoveMode moveMode) {
        this.mode = moveMode;
        this.units = this.mode.getDefaultUnits();
        this.unitsButton.method_32605((Object)this.units);
        this.prevFacing = this.getCurrentFacing();
        this.facingLabel.setText(ArmorStandMoveScreen.getFacingText(this.prevFacing));
        this.moveButtons.forEach(moveButtonRef -> {
            moveButtonRef.setMode(this.mode);
            moveButtonRef.setUnits(this.units);
        });
        this.directionLabels.forEach((class_23502, labelWidget) -> labelWidget.setText(this.mode.getDirectionText((class_2350)class_23502)));
        this.layout.bottomRight.method_48222();
        this.layout.method_48222();
    }

    private void onMoveUnitsChange(class_5676<MoveUnits> class_56762, MoveUnits moveUnits) {
        this.units = moveUnits;
        this.moveButtons.forEach(moveButtonRef -> moveButtonRef.setUnits(this.units));
    }

    private class_2350 getCurrentFacing() {
        class_1531 class_15312 = this.mode.equals((Object)MoveMode.LOCAL_TO_STAND) ? this.getArmorStand() : this.getPlayer();
        return class_2350.method_10150((double)class_15312.method_36454());
    }

    private static class MoveButtonRef {
        private final class_4185 button;
        private final class_2350 direction;
        private final int amount;
        private MoveMode mode;
        private MoveUnits units;

        public MoveButtonRef(class_2350 class_23502, int n, MoveMode moveMode, MoveUnits moveUnits) {
            this.direction = class_23502;
            this.amount = n;
            this.mode = moveMode;
            this.units = moveUnits;
            this.button = class_4185.method_46430((class_2561)this.getMessage(), this::onPress).method_46437(28, 16).method_46431();
        }

        public class_4185 getButton() {
            return this.button;
        }

        public void setUnits(MoveUnits moveUnits) {
            this.units = moveUnits;
            this.button.method_25355(this.units.getButtonText(this.amount));
        }

        public void setMode(MoveMode moveMode) {
            this.mode = moveMode;
        }

        private class_2561 getMessage() {
            return this.units.getButtonText(this.amount);
        }

        private void onPress(class_4185 class_41852) {
            ClientNetworking.sendAdjustPosPacket(this.direction, this.amount, this.mode, this.units);
        }
    }
}

