/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.widget;

import java.util.Optional;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.util.actions.ScaleAction;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_6880;

public class ScaleSliderWidget
extends class_357 {
    private static final float MIN = 0.01f;
    private static final float MAX = 10.0f;
    private static final float SPLIT_SCALE = 2.0f;
    private static final double SPLIT_VALUE = 0.5;
    private final AbstractArmorStandScreen parent;
    private final class_1531 armorStand;
    private Optional<Float> lastScale = Optional.empty();
    private Optional<Long> lastScroll = Optional.empty();
    private boolean isDragging = false;
    private boolean pendingDragPing = false;

    public ScaleSliderWidget(AbstractArmorStandScreen abstractArmorStandScreen, int n, int n2, class_1531 class_15312) {
        super(0, 0, n, n2, (class_2561)class_2561.method_43473(), 0.0);
        this.parent = abstractArmorStandScreen;
        this.armorStand = class_15312;
        this.refresh();
    }

    public boolean isPending(class_437 class_4372) {
        return this.isDragging() || this.lastScroll.isPresent();
    }

    public void refresh() {
        float f = this.armorStand.method_55693();
        if (this.lastScale.isPresent() && Math.abs(f - this.lastScale.get().floatValue()) < 1.0E-5f) {
            return;
        }
        this.lastScale = Optional.of(Float.valueOf(f));
        this.setScale(f);
    }

    public void setToOne() {
        this.setScale(1.0f);
        this.persistValue();
    }

    public void increment() {
        float f = ScaleSliderWidget.nextTickUp(this.getScale());
        if (f - this.getScale() < 1.0E-5f) {
            f += ScaleSliderWidget.stepAmount(f, true);
        }
        this.setScale(f);
        this.persistValue();
    }

    public void decrement() {
        float f = ScaleSliderWidget.nextTickDown(this.getScale());
        if (this.getScale() - f < 1.0E-5f) {
            f -= ScaleSliderWidget.stepAmount(f, false);
        }
        this.setScale(f);
        this.persistValue();
    }

    public void tick() {
        this.lastScroll.ifPresent(l -> {
            if (System.currentTimeMillis() - l > 500L) {
                this.lastScroll = Optional.empty();
                this.persistValue();
            }
        });
    }

    public boolean isDragging() {
        return this.isDragging || this.pendingDragPing;
    }

    public void onPong() {
        this.pendingDragPing = false;
    }

    protected void method_25346() {
        this.method_25355(class_2561.method_30163((String)String.format("%.2f", Float.valueOf(this.getScale()))));
    }

    protected void method_25344() {
        ScaleAction.setScale(this.armorStand, this.getScale());
    }

    public void method_25348(class_11909 class_119092, boolean bl) {
        super.method_25348(class_119092, bl);
        this.isDragging = true;
    }

    public void method_25357(class_11909 class_119092) {
        super.method_25357(class_119092);
        this.isDragging = false;
        this.pendingDragPing = true;
        this.parent.sendPing();
        this.persistValue();
    }

    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.method_25405(d, d2)) {
            if (d4 > 0.0) {
                this.increment();
            } else {
                this.decrement();
            }
            this.method_25344();
            this.lastScroll = Optional.of(System.currentTimeMillis());
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    protected void method_25349(class_11909 class_119092, double d, double d2) {
        this.isDragging = true;
        super.method_25349(class_119092, d, d2);
    }

    public void method_25354(class_1144 class_11442) {
        class_11442.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    private float getScale() {
        return ScaleSliderWidget.valueToScale(this.field_22753);
    }

    public void setScale(float f) {
        this.setValue(ScaleSliderWidget.scaleToValue(f));
    }

    private void setValue(double d) {
        this.field_22753 = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
        this.method_25346();
    }

    private static float nextTickUp(float f) {
        float f2 = ScaleSliderWidget.stepAmount(f, true);
        return (float)(Math.ceil(f / f2) * (double)f2);
    }

    private static float nextTickDown(float f) {
        float f2 = ScaleSliderWidget.stepAmount(f, false);
        return (float)(Math.floor(f / f2) * (double)f2);
    }

    private static float stepAmount(float f, boolean bl) {
        return f < 2.0f || !bl && Math.abs(f - 2.0f) < 1.0E-5f ? 0.1f : 0.5f;
    }

    private static double scaleToValue(float f) {
        if (f < 2.0f) {
            return (double)((f - 0.01f) / 1.99f) * 0.5;
        }
        return 0.5 + (double)((f - 2.0f) / 8.0f) * 0.5;
    }

    private static float valueToScale(double d) {
        if (d < 0.5) {
            return (float)((double)0.01f + d / 0.5 * (double)1.99f);
        }
        return (float)(2.0 + (d - 0.5) / 0.5 * 8.0);
    }

    private void persistValue() {
        this.lastScroll = Optional.empty();
        ClientNetworking.sendSetScalePacket(this.getScale());
    }
}

