/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.network;

import me.roundaround.armorstands.client.gui.MessageRenderer;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandInventoryScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandMoveScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandPoseScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandPresetsScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandRotateScreen;
import me.roundaround.armorstands.client.gui.screen.ArmorStandUtilitiesScreen;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.Networking;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.MoveMode;
import me.roundaround.armorstands.util.MoveUnits;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.PosePreset;
import me.roundaround.armorstands.util.SavedPose;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1531;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public final class ClientNetworking {
    private ClientNetworking() {
    }

    public static void sendAdjustPosePacket(PosePart posePart, EulerAngleParameter eulerAngleParameter, float f) {
        ClientPlayNetworking.send((class_8710)new Networking.AdjustPoseC2S(posePart, eulerAngleParameter, f));
    }

    public static void sendAdjustPosPacket(class_2350 class_23502, int n, MoveMode moveMode, MoveUnits moveUnits) {
        ClientPlayNetworking.send((class_8710)new Networking.AdjustPosC2S(class_23502, n, moveMode, moveUnits));
    }

    public static void sendAdjustYawPacket(int n) {
        ClientPlayNetworking.send((class_8710)new Networking.AdjustYawC2S(n));
    }

    public static void sendPingPacket(class_746 class_7462) {
        if (ClientPlayNetworking.canSend(Networking.PingC2S.ID)) {
            ClientPlayNetworking.send((class_8710)new Networking.PingC2S(class_7462.method_5667()));
        }
    }

    public static void sendRequestScreenPacket(class_1531 class_15312, ScreenType screenType) {
        ClientPlayNetworking.send((class_8710)new Networking.RequestScreenC2S(class_15312.method_5628(), screenType));
    }

    public static void sendSetFlagPacket(ArmorStandFlag armorStandFlag, boolean bl) {
        ClientPlayNetworking.send((class_8710)new Networking.SetFlagC2S(armorStandFlag, bl));
    }

    public static void sendSetPosePacket(SavedPose savedPose) {
        ClientNetworking.sendSetPosePacket(savedPose.toPose());
    }

    public static void sendSetPosePacket(Pose pose) {
        ClientPlayNetworking.send((class_8710)new Networking.SetPoseC2S(pose));
    }

    public static void sendSetPosePresetPacket(PosePreset posePreset) {
        ClientPlayNetworking.send((class_8710)new Networking.SetPosePresetC2S(posePreset));
    }

    public static void sendSetScalePacket(float f) {
        ClientPlayNetworking.send((class_8710)new Networking.SetScaleC2S(f));
    }

    public static void sendSetYawPacket(float f) {
        ClientPlayNetworking.send((class_8710)new Networking.SetYawC2S(f));
    }

    public static void sendUndoPacket(boolean bl) {
        if (ClientPlayNetworking.canSend(Networking.UndoC2S.ID)) {
            ClientPlayNetworking.send((class_8710)new Networking.UndoC2S(bl));
        }
    }

    public static void sendUtilityActionPacket(UtilityAction utilityAction) {
        ClientPlayNetworking.send((class_8710)new Networking.UtilityActionC2S(utilityAction));
    }

    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(Networking.ClientUpdateS2C.ID, ClientNetworking::handleClientUpdate);
        ClientPlayNetworking.registerGlobalReceiver(Networking.MessageS2C.ID, ClientNetworking::handleMessage);
        ClientPlayNetworking.registerGlobalReceiver(Networking.OpenScreenS2C.ID, ClientNetworking::handleOpenScreen);
        ClientPlayNetworking.registerGlobalReceiver(Networking.PongS2C.ID, ClientNetworking::handlePong);
    }

    private static void handleClientUpdate(Networking.ClientUpdateS2C clientUpdateS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_437 class_4372 = context.client().field_1755;
            if (!(class_4372 instanceof AbstractArmorStandScreen)) {
                return;
            }
            AbstractArmorStandScreen abstractArmorStandScreen = (AbstractArmorStandScreen)class_4372;
            abstractArmorStandScreen.updatePosOnClient(clientUpdateS2C.x(), clientUpdateS2C.y(), clientUpdateS2C.z());
            abstractArmorStandScreen.updateYawOnClient(class_3532.method_15393((float)clientUpdateS2C.yaw()));
            abstractArmorStandScreen.updatePitchOnClient(class_3532.method_15393((float)clientUpdateS2C.pitch()));
            abstractArmorStandScreen.updateInvulnerableOnClient(clientUpdateS2C.invulnerable());
            abstractArmorStandScreen.updateDisabledSlotsOnClient(clientUpdateS2C.disabledSlots());
        });
    }

    private static void handleMessage(Networking.MessageS2C messageS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_437 class_4372 = context.client().field_1755;
            if (!(class_4372 instanceof AbstractArmorStandScreen)) {
                return;
            }
            AbstractArmorStandScreen abstractArmorStandScreen = (AbstractArmorStandScreen)class_4372;
            MessageRenderer messageRenderer = abstractArmorStandScreen.getMessageRenderer();
            messageRenderer.addMessage((class_2561)(messageS2C.translatable() ? class_2561.method_43471((String)messageS2C.message()) : class_2561.method_43470((String)messageS2C.message())), messageS2C.styled() ? messageS2C.color() : 0xFFFFFF);
        });
    }

    private static void handleOpenScreen(Networking.OpenScreenS2C openScreenS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_746 class_7462 = context.player();
            Object object = class_7462.method_73183().method_8469(openScreenS2C.armorStandId());
            if (!(object instanceof class_1531)) {
                return;
            }
            class_1531 class_15312 = (class_1531)object;
            object = new ArmorStandScreenHandler(openScreenS2C.syncId(), class_7462.method_31548(), class_15312, openScreenS2C.screenType());
            class_7462.field_7512 = object;
            class_310 class_3102 = context.client();
            class_3102.method_1507((class_437)(switch (((ArmorStandScreenHandler)((Object)((Object)object))).getScreenType()) {
                default -> throw new MatchException(null, null);
                case ScreenType.UTILITIES -> new ArmorStandUtilitiesScreen((ArmorStandScreenHandler)((Object)((Object)object)));
                case ScreenType.MOVE -> new ArmorStandMoveScreen((ArmorStandScreenHandler)((Object)((Object)object)));
                case ScreenType.ROTATE -> new ArmorStandRotateScreen((ArmorStandScreenHandler)((Object)((Object)object)));
                case ScreenType.POSE -> new ArmorStandPoseScreen((ArmorStandScreenHandler)((Object)((Object)object)));
                case ScreenType.PRESETS -> new ArmorStandPresetsScreen((ArmorStandScreenHandler)((Object)((Object)object)));
                case ScreenType.INVENTORY -> new ArmorStandInventoryScreen((ArmorStandScreenHandler)((Object)((Object)object)));
            }));
        });
    }

    private static void handlePong(Networking.PongS2C pongS2C, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            class_437 class_4372 = context.client().field_1755;
            if (!(class_4372 instanceof AbstractArmorStandScreen)) {
                return;
            }
            AbstractArmorStandScreen abstractArmorStandScreen = (AbstractArmorStandScreen)class_4372;
            abstractArmorStandScreen.onPong();
        });
    }
}

