/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.network;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import net.minecraft.class_1313;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public enum ArmorStandFlag {
    UNKNOWN(0, "unknown", false),
    HIDE_BASE_PLATE(1, "base", true),
    SHOW_ARMS(2, "arms", false),
    SMALL(3, "small", false),
    NO_GRAVITY(4, "gravity", true),
    INVISIBLE(5, "visible", false),
    NAME(6, "name", false),
    INVULNERABLE(7, "invulnerable", false),
    LOCK_INVENTORY(8, "inventory", false);

    public static final IntFunction<ArmorStandFlag> ID_TO_VALUE_FUNCTION;
    public static final class_9139<ByteBuf, ArmorStandFlag> PACKET_CODEC;
    private static final int ALL_SLOTS_DISABLED = 0x3F3F3F;
    private final int index;
    private final String id;
    private final boolean invertControl;

    private ArmorStandFlag(int n2, String string2, boolean bl) {
        this.index = n2;
        this.id = string2;
        this.invertControl = bl;
    }

    public String toString() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)("armorstands.flags." + this.id));
    }

    public boolean invertControl() {
        return this.invertControl;
    }

    public boolean getValue(class_1531 class_15312) {
        ArmorStandEntityAccessor armorStandEntityAccessor = (ArmorStandEntityAccessor)class_15312;
        return switch (this.ordinal()) {
            case 1 -> {
                if (!class_15312.method_61489()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> class_15312.method_6929();
            case 3 -> class_15312.method_6914();
            case 4 -> class_15312.method_5740();
            case 5 -> class_15312.method_5767();
            case 6 -> class_15312.method_5807();
            case 7 -> class_15312.method_5655();
            case 8 -> {
                if (armorStandEntityAccessor.getDisabledSlots() == 0x3F3F3F) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void setValue(class_1531 class_15312, boolean bl) {
        ArmorStandEntityAccessor armorStandEntityAccessor = (ArmorStandEntityAccessor)class_15312;
        switch (this.ordinal()) {
            case 1: {
                armorStandEntityAccessor.invokeSetHideBasePlate(bl);
                break;
            }
            case 2: {
                armorStandEntityAccessor.invokeSetShowArms(bl);
                break;
            }
            case 3: {
                armorStandEntityAccessor.invokeSetSmall(bl);
                break;
            }
            case 4: {
                class_15312.method_5875(bl);
                class_243 class_2432 = class_15312.method_18798();
                class_15312.method_18800(class_2432.field_1352, 0.0, class_2432.field_1350);
                if (bl) break;
                class_15312.field_5960 = false;
                class_15312.method_5808(class_15312.method_23317(), class_15312.method_23318() + 0.01, class_15312.method_23321(), class_15312.method_36454(), class_15312.method_36455());
                class_15312.method_5784(class_1313.field_6308, new class_243(0.0, -0.009, 0.0));
                break;
            }
            case 5: {
                class_15312.method_5648(bl);
                break;
            }
            case 6: {
                class_15312.method_5880(bl);
                break;
            }
            case 7: {
                class_15312.method_5684(bl);
                break;
            }
            case 8: {
                armorStandEntityAccessor.setDisabledSlots(bl ? 0x3F3F3F : 0);
                break;
            }
            default: {
                ArmorStandsMod.LOGGER.warn("Tried to set value to flag {}. Ignoring.", (Object)this.name());
            }
        }
    }

    public static ArmorStandFlag fromString(String string) {
        return Arrays.stream(ArmorStandFlag.values()).filter(armorStandFlag -> armorStandFlag.id.equals(string)).findFirst().orElseGet(() -> {
            ArmorStandsMod.LOGGER.warn("Unknown flag id '{}'. Returning UNKNOWN.", (Object)string);
            return UNKNOWN;
        });
    }

    public static List<ArmorStandFlag> getFlags() {
        return Arrays.stream(ArmorStandFlag.values()).filter(armorStandFlag -> armorStandFlag != UNKNOWN).toList();
    }

    static {
        ID_TO_VALUE_FUNCTION = class_7995.method_47914(ArmorStandFlag::getIndex, (Object[])ArmorStandFlag.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        PACKET_CODEC = class_9135.method_56375(ID_TO_VALUE_FUNCTION, ArmorStandFlag::getIndex);
    }
}

