/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.network;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.server.network.ServerNetworking;
import me.roundaround.armorstands.util.ArmorStandEditor;
import me.roundaround.armorstands.util.ArmorStandHelper;
import me.roundaround.armorstands.util.Clipboard;
import me.roundaround.armorstands.util.actions.ArmorStandAction;
import me.roundaround.armorstands.util.actions.HoldingAction;
import me.roundaround.armorstands.util.actions.PrepareAction;
import me.roundaround.armorstands.util.actions.SnapToGroundAction;
import me.roundaround.armorstands.util.actions.ToolRackAction;
import net.minecraft.class_1531;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public enum UtilityAction {
    COPY("copy"),
    PASTE("paste"),
    PREPARE("prepare"),
    TOOL_RACK("tool_rack"),
    UPRIGHT_ITEM("upright_item"),
    UPRIGHT_ITEM_SMALL("upright_item_small"),
    FLAT_ITEM("flat_item"),
    FLAT_ITEM_SMALL("flat_item_small"),
    BLOCK("block"),
    BLOCK_SMALL("block_small"),
    TOOL("tool"),
    TOOL_SMALL("tool_small"),
    SNAP_CORNER("snap_corner"),
    SNAP_CENTER("snap_center"),
    SNAP_STANDING("snap_standing"),
    SNAP_SITTING("snap_sitting"),
    SNAP_PLAYER("snap_player"),
    FACE_TOWARD("face_toward"),
    FACE_AWAY("face_away"),
    FACE_WITH("face_with"),
    UNKNOWN("unknown");

    public static final class_9139<ByteBuf, UtilityAction> PACKET_CODEC;
    private final String id;

    private UtilityAction(String string2) {
        this.id = string2;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void apply(ArmorStandEditor armorStandEditor, class_3222 class_32222) {
        class_1531 class_15312 = armorStandEditor.getArmorStand();
        switch (this.ordinal()) {
            case 0: {
                Clipboard.copy(class_32222, class_15312);
                break;
            }
            case 1: {
                Clipboard.paste(class_32222, armorStandEditor);
                break;
            }
            case 2: {
                armorStandEditor.applyAction(PrepareAction.create(class_15312));
                break;
            }
            case 3: {
                ToolRackAction toolRackAction = ToolRackAction.create(class_15312);
                if (toolRackAction == null) {
                    ServerNetworking.sendMessagePacket(class_32222, "armorstands.utility.toolRack.noHook", 0xFF0000);
                    break;
                }
                armorStandEditor.applyAction(toolRackAction);
                break;
            }
            case 4: 
            case 5: {
                armorStandEditor.applyAction(HoldingAction.uprightItem(class_15312, this == UPRIGHT_ITEM_SMALL));
                break;
            }
            case 6: 
            case 7: {
                armorStandEditor.applyAction(HoldingAction.flatItem(class_15312, this == FLAT_ITEM_SMALL));
                break;
            }
            case 8: 
            case 9: {
                armorStandEditor.applyAction(HoldingAction.block(class_15312, this == BLOCK_SMALL));
                break;
            }
            case 10: 
            case 11: {
                armorStandEditor.applyAction(HoldingAction.tool(class_15312, this == TOOL_SMALL));
                break;
            }
            case 12: {
                armorStandEditor.setPos(ArmorStandHelper.getCornerPos(class_15312));
                break;
            }
            case 13: {
                armorStandEditor.setPos(ArmorStandHelper.getCenterPos(class_15312));
                break;
            }
            case 14: 
            case 15: {
                armorStandEditor.applyAction(SnapToGroundAction.create(this == SNAP_SITTING));
                break;
            }
            case 16: {
                armorStandEditor.setPos(class_32222.armorstands$getPos());
                break;
            }
            case 17: {
                armorStandEditor.setRotation(ArmorStandHelper.getLookYaw(class_15312, class_32222.method_33571()));
                break;
            }
            case 18: {
                armorStandEditor.setRotation(180.0f + ArmorStandHelper.getLookYaw(class_15312, class_32222.method_33571()));
                break;
            }
            case 19: {
                armorStandEditor.setRotation(class_32222.method_36454());
                break;
            }
            default: {
                armorStandEditor.applyAction(ArmorStandAction.noop());
            }
        }
    }

    public UtilityAction forSmall(boolean bl) {
        return switch (this.ordinal()) {
            case 4, 5 -> {
                if (bl) {
                    yield UPRIGHT_ITEM_SMALL;
                }
                yield UPRIGHT_ITEM;
            }
            case 6, 7 -> {
                if (bl) {
                    yield FLAT_ITEM_SMALL;
                }
                yield FLAT_ITEM;
            }
            case 8, 9 -> {
                if (bl) {
                    yield BLOCK_SMALL;
                }
                yield BLOCK;
            }
            case 10, 11 -> {
                if (bl) {
                    yield TOOL_SMALL;
                }
                yield TOOL;
            }
            default -> this;
        };
    }

    public static UtilityAction fromString(String string) {
        return Arrays.stream(UtilityAction.values()).filter(utilityAction -> utilityAction.id.equals(string)).findFirst().orElseGet(() -> {
            ArmorStandsMod.LOGGER.warn("Unknown id '{}'. Defaulting to UNKNOWN.", (Object)string);
            return UNKNOWN;
        });
    }

    static {
        PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_48554, UtilityAction::getId, UtilityAction::fromString);
    }
}

