/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.client.gui.util;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import me.roundaround.armorstands.roundalib.client.gui.util.FloatRect;
import me.roundaround.armorstands.roundalib.client.gui.util.FourSided;
import net.minecraft.class_1735;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

public final class IntRect
extends Record
implements FourSided<Integer> {
    private final Integer left;
    private final Integer top;
    private final Integer right;
    private final Integer bottom;
    private static final int SLOT_SIZE = 16;

    public IntRect(Integer n, Integer n2, Integer n3, Integer n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public static IntRect zero() {
        return IntRect.byBounds(0, 0, 0, 0);
    }

    public static IntRect byBounds(int n, int n2, int n3, int n4) {
        return new IntRect(n, n2, n3, n4);
    }

    public static IntRect byDimensions(int n, int n2, int n3, int n4) {
        return new IntRect(n, n2, n + n3, n2 + n4);
    }

    public static IntRect fromSlot(class_1735 class_17352) {
        return IntRect.byBounds(class_17352.field_7873, class_17352.field_7872, 16, 16);
    }

    public static IntRect fromWidget(class_8021 class_80212) {
        return IntRect.byDimensions(class_80212.method_46426(), class_80212.method_46427(), class_80212.method_25368(), class_80212.method_25364());
    }

    public static IntRect fromScreenRect(class_8030 class_80302) {
        return IntRect.byDimensions(class_80302.method_49620(), class_80302.method_49618(), class_80302.comp_1196(), class_80302.comp_1197());
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public IntRect expandLeft(int n) {
        return this.expand(n, 0, 0, 0);
    }

    public IntRect expandTop(int n) {
        return this.expand(0, n, 0, 0);
    }

    public IntRect expandRight(int n) {
        return this.expand(0, 0, n, 0);
    }

    public IntRect expandBottom(int n) {
        return this.expand(0, 0, 0, n);
    }

    public IntRect expand(int n) {
        return this.expand(n, n, n, n);
    }

    public IntRect expand(FourSided<Integer> fourSided) {
        return this.expand(fourSided.left(), fourSided.top(), fourSided.right(), fourSided.bottom());
    }

    public IntRect expand(int n, int n2, int n3, int n4) {
        return IntRect.byBounds(this.left - n, this.top - n2, this.right + n3, this.bottom + n4);
    }

    public IntRect reduce(int n) {
        return this.expand(-n);
    }

    public IntRect reduce(FourSided<Integer> fourSided) {
        return this.expand(-fourSided.left().intValue(), -fourSided.top().intValue(), -fourSided.right().intValue(), -fourSided.bottom().intValue());
    }

    public IntRect shift(int n, int n2) {
        return IntRect.byBounds(this.left + n, this.top + n2, this.right + n, this.bottom + n2);
    }

    public IntRect shiftLeft(int n) {
        return this.shift(-n, 0);
    }

    public IntRect shiftUp(int n) {
        return this.shift(0, -n);
    }

    public IntRect shiftRight(int n) {
        return this.shift(n, 0);
    }

    public IntRect shiftDown(int n) {
        return this.shift(0, n);
    }

    public class_8030 toScreenRect() {
        return new class_8030(this.left.intValue(), this.top.intValue(), this.getWidth(), this.getHeight());
    }

    public FloatRect toFloatRect() {
        return FloatRect.byBounds(this.left.intValue(), this.top.intValue(), this.right.intValue(), this.bottom.intValue());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this, object);
    }

    @Override
    public Integer left() {
        return this.left;
    }

    @Override
    public Integer top() {
        return this.top;
    }

    @Override
    public Integer right() {
        return this.right;
    }

    @Override
    public Integer bottom() {
        return this.bottom;
    }
}

