/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.client.gui.widget.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.layout.screen.ThreeSectionLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.ParentElementEntryListWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.TooltipWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.Control;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.ControlRegistry;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.armorstands.roundalib.config.manage.ModConfig;
import me.roundaround.armorstands.roundalib.config.option.ConfigOption;
import me.roundaround.armorstands.roundalib.config.panic.IllegalStatePanic;
import me.roundaround.armorstands.roundalib.config.panic.Panic;
import me.roundaround.armorstands.roundalib.observable.Observable;
import me.roundaround.armorstands.roundalib.observable.Subscription;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class ConfigListWidget
extends ParentElementEntryListWidget<Entry> {
    protected final String modId;
    protected final ArrayList<Subscription> subscriptions = new ArrayList();

    public ConfigListWidget(class_310 class_3102, ThreeSectionLayoutWidget threeSectionLayoutWidget, String string, List<ModConfig> list) {
        super(class_3102, threeSectionLayoutWidget);
        this.modId = string;
        List<UnwrappedModConfig> list2 = list.stream().map(UnwrappedModConfig::unwrap).filter(UnwrappedModConfig::hasOptions).toList();
        list2.forEach(unwrappedModConfig -> {
            if (list2.size() > 1) {
                this.addConfigEntry(unwrappedModConfig.label());
            }
            unwrappedModConfig.optionsByGroup().forEach((string, list) -> {
                if (string != null && !string.isBlank()) {
                    this.addGroupEntry((String)string);
                }
                list.forEach(this::addOptionEntry);
            });
        });
    }

    protected void addConfigEntry(class_2561 class_25612) {
        this.addEntry((n, n2, n3, n4) -> new ConfigEntry(this.client.field_1772, class_25612, n, n2, n3, n4));
    }

    protected void addGroupEntry(String string) {
        this.addEntry((n, n2, n3, n4) -> new GroupEntry(this.client.field_1772, (class_2561)class_2561.method_43471((String)(this.modId + "." + string + ".title")), n, n2, n3, n4));
    }

    protected void addOptionEntry(ConfigOption<?> configOption) {
        if (!configOption.hasGuiControl()) {
            return;
        }
        this.addEntry((n, n2, n3, n4) -> {
            try {
                OptionEntry optionEntry = new OptionEntry(this.client, configOption, n, n2, n3, n4);
                this.subscriptions.addAll(optionEntry.initSubscriptions());
                return optionEntry;
            }
            catch (ControlRegistry.NotRegisteredException notRegisteredException) {
                Panic.panic(new IllegalStatePanic(String.format("Failed to create control for config option: %s", configOption), notRegisteredException));
                return null;
            }
        });
    }

    public List<Subscription> collectSubscriptions() {
        List<Subscription> list = List.copyOf(this.subscriptions);
        this.subscriptions.clear();
        return list;
    }

    public void tick() {
        this.forEachEntry(Entry::tick);
    }

    public static class OptionEntry<D, O extends ConfigOption<D>>
    extends Entry {
        protected static final int HEIGHT = 20;
        protected static final int CONTROL_MIN_WIDTH = 100;
        protected final O option;
        protected final TooltipWidget tooltip;
        protected final LinearLayoutWidget layout;
        protected final LabelWidget label;
        protected final Control<D, O> control;
        protected final IconButtonWidget resetButton;

        protected OptionEntry(class_310 class_3102, O o, int n, int n2, int n3, int n4) throws ControlRegistry.NotRegisteredException {
            super(n, n2, n3, n4, 20);
            this.option = o;
            ArrayList<class_2561> arrayList = new ArrayList<class_2561>();
            arrayList.add(((ConfigOption)o).getLabel());
            arrayList.add((class_2561)class_2561.method_43470((String)((ConfigOption)o).getPath().toString()).method_27692(class_124.field_1080));
            this.tooltip = this.addDrawable(new TooltipWidget(arrayList));
            this.layout = LinearLayoutWidget.horizontal(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()).spacing(4).defaultOffAxisContentAlignCenter();
            this.label = LabelWidget.builder(class_3102.field_1772, ((ConfigOption)o).getLabel()).alignTextLeft().alignTextCenterY().overflowBehavior(LabelWidget.OverflowBehavior.WRAP).maxLines(2).showShadow().hideBackground().build();
            this.layout.add(this.label, (linearLayoutWidget, labelWidget) -> labelWidget.method_55445(this.getLabelWidth((LinearLayoutWidget)linearLayoutWidget), this.getContentHeight()));
            this.control = ControlRegistry.getControlFactory(o).create(class_3102, o, this.getControlWidth(this.layout), this.getContentHeight());
            this.layout.add(this.control, (linearLayoutWidget, control) -> control.setDimensions(this.getControlWidth((LinearLayoutWidget)linearLayoutWidget), this.getContentHeight()));
            this.resetButton = IconButtonWidget.builder(BuiltinIcon.UNDO_18, ((ConfigOption)this.getOption()).getModId()).vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)(((ConfigOption)this.getOption()).getModId() + ".roundalib.reset.tooltip"))).onPress(class_41852 -> ((ConfigOption)this.getOption()).setDefault()).build();
            this.layout.add(this.resetButton);
            this.addLayout(this.layout, linearLayoutWidget -> linearLayoutWidget.setPositionAndDimensions(this.getContentLeft(), this.getContentTop(), this.getContentWidth(), this.getContentHeight()));
            this.layout.method_48206(class_40682 -> {
                class_339 cfr_ignored_0 = (class_339)this.addDrawableChild(class_40682);
            });
        }

        public O getOption() {
            return this.option;
        }

        public List<Subscription> initSubscriptions() {
            return List.of(this.control.initSubscriptions(), Observable.subscribeAll(((ConfigOption)this.option).isPendingDefault, ((ConfigOption)this.option).isDisabled, (bl, bl2) -> {
                this.resetButton.field_22763 = bl == false && bl2 == false;
            }));
        }

        private int getLabelWidth(LinearLayoutWidget linearLayoutWidget) {
            return linearLayoutWidget.method_25368() - 2 * linearLayoutWidget.getSpacing() - this.getControlWidth(linearLayoutWidget) - 20;
        }

        private int getControlWidth(LinearLayoutWidget linearLayoutWidget) {
            return Math.max(100, Math.round((float)linearLayoutWidget.method_25368() * 0.3f));
        }

        @Override
        public void method_48222() {
            super.method_48222();
            this.tooltip.setDimensionsAndPosition(this.label.method_25368(), this.label.method_25364(), this.label.method_46426(), this.label.method_46427());
        }

        @Override
        public void tick() {
            this.control.tick();
        }
    }

    public static class GroupEntry
    extends Entry {
        protected static final int HEIGHT = 22;
        protected final LabelWidget label;

        protected GroupEntry(class_327 class_3272, class_2561 class_25612, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, 22);
            this.setMarginY(DEFAULT_MARGIN.getVertical());
            this.label = LabelWidget.builder(class_3272, class_25612).alignTextCenterX().alignTextCenterY().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).showShadow().hideBackground().build();
            this.addDrawableChild(this.label);
        }

        @Override
        public void method_48222() {
            this.label.batchUpdates(() -> {
                this.label.method_48229(this.getContentLeft(), this.getContentTop());
                this.label.method_55445(this.getContentWidth(), this.getContentHeight());
            });
            super.method_48222();
        }

        @Override
        protected void renderBackground(class_332 class_3322, int n, int n2, float f) {
            GroupEntry.renderRowShade(class_3322, this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 10, 50);
        }
    }

    public static class ConfigEntry
    extends Entry {
        protected static final int HEIGHT = 24;
        protected final LabelWidget label;

        protected ConfigEntry(class_327 class_3272, class_2561 class_25612, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4, 24);
            this.setMarginY(DEFAULT_MARGIN.getVertical() + 4);
            this.label = LabelWidget.builder(class_3272, class_25612).alignTextCenterX().alignTextCenterY().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).showShadow().hideBackground().build();
            this.addDrawable(this.label);
        }

        @Override
        public void method_48222() {
            this.label.batchUpdates(() -> {
                this.label.method_48229(this.getContentLeft(), this.getContentTop());
                this.label.method_55445(this.getContentWidth(), this.getContentHeight());
            });
            super.method_48222();
        }

        @Override
        protected void renderBackground(class_332 class_3322, int n, int n2, float f) {
            ConfigEntry.renderRowShade(class_3322, this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 30, 150);
        }
    }

    private record UnwrappedModConfig(class_2561 label, Map<String, List<ConfigOption<?>>> optionsByGroup) {
        static UnwrappedModConfig unwrap(ModConfig modConfig) {
            return new UnwrappedModConfig(modConfig.getLabel(), modConfig.getByGroupWithGuiControl());
        }

        boolean hasOptions() {
            return !this.optionsByGroup.isEmpty();
        }
    }

    public static abstract class Entry
    extends ParentElementEntryListWidget.Entry {
        protected Entry(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4, n5);
        }

        public void tick() {
        }
    }
}

