/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.client.gui.widget.config;

import java.util.HashMap;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.Control;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.EnumCycleControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.FloatSliderControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.FloatTextControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.IntSliderControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.IntTextControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.TextControl;
import me.roundaround.armorstands.roundalib.client.gui.widget.config.ToggleControl;
import me.roundaround.armorstands.roundalib.config.option.BooleanConfigOption;
import me.roundaround.armorstands.roundalib.config.option.ConfigOption;
import me.roundaround.armorstands.roundalib.config.option.EnumConfigOption;
import me.roundaround.armorstands.roundalib.config.option.FloatConfigOption;
import me.roundaround.armorstands.roundalib.config.option.IntConfigOption;
import me.roundaround.armorstands.roundalib.config.option.StringConfigOption;
import me.roundaround.armorstands.roundalib.config.panic.IllegalStatePanic;
import me.roundaround.armorstands.roundalib.config.panic.Panic;
import me.roundaround.armorstands.roundalib.config.value.Difficulty;
import me.roundaround.armorstands.roundalib.config.value.EnumValue;
import me.roundaround.armorstands.roundalib.config.value.GameMode;
import me.roundaround.armorstands.roundalib.config.value.GuiAlignment;
import me.roundaround.armorstands.roundalib.config.value.GuiAlignmentWithCenter;
import me.roundaround.armorstands.roundalib.config.value.GuiTheme;
import net.minecraft.class_310;

public class ControlRegistry {
    private static final HashMap<Class<?>, Control.ControlFactory<?, ?>> byClazz = new HashMap();
    private static final HashMap<Class<?>, Control.ControlFactory<?, ?>> byOptionListClazz = new HashMap();
    private static final HashMap<String, Control.ControlFactory<?, ?>> byId = new HashMap();

    private ControlRegistry() {
    }

    private static void registerDefaults() {
        try {
            ControlRegistry.register(BooleanConfigOption.class, ToggleControl::new);
            ControlRegistry.register(StringConfigOption.class, TextControl::new);
            ControlRegistry.register(IntConfigOption.class, ControlRegistry::intControlFactory);
            ControlRegistry.register(FloatConfigOption.class, ControlRegistry::floatControlFactory);
            ControlRegistry.registerOptionList(Difficulty.class);
            ControlRegistry.registerOptionList(GameMode.class);
            ControlRegistry.registerOptionList(GuiAlignment.class);
            ControlRegistry.registerOptionList(GuiAlignmentWithCenter.class);
            ControlRegistry.registerOptionList(GuiTheme.class);
        }
        catch (RegistrationException registrationException) {
            Panic.panic(new IllegalStatePanic("There was an error registering the built-in control factories!", registrationException));
        }
    }

    public static <D, T extends ConfigOption<D>> void register(Class<T> clazz, Control.ControlFactory<D, T> controlFactory) throws RegistrationException {
        if (byClazz.containsKey(clazz)) {
            throw new RegistrationException();
        }
        byClazz.put(clazz, controlFactory);
    }

    public static <S extends EnumValue<S>> void registerOptionList(Class<S> clazz) throws RegistrationException {
        ControlRegistry.registerOptionList(clazz, EnumCycleControl::new);
    }

    public static <S extends EnumValue<S>, T extends EnumConfigOption<S>> void registerOptionList(Class<S> clazz, Control.ControlFactory<S, T> controlFactory) throws RegistrationException {
        if (byOptionListClazz.containsKey(clazz)) {
            throw new RegistrationException();
        }
        byOptionListClazz.put(clazz, controlFactory);
    }

    public static <D, T extends ConfigOption<D>> void register(String string, Control.ControlFactory<D, T> controlFactory) throws RegistrationException {
        if (byId.containsKey(string)) {
            throw new RegistrationException();
        }
        byId.put(string, controlFactory);
    }

    public static <D, T extends ConfigOption<D>> Control.ControlFactory<D, T> getControlFactory(T t) throws NotRegisteredException {
        Class<?> clazz;
        String string = t.getId();
        if (byId.containsKey(string)) {
            return byId.get(string);
        }
        Class<?> clazz2 = t.getClass();
        if (byClazz.containsKey(clazz2)) {
            return byClazz.get(clazz2);
        }
        if (clazz2.equals(EnumConfigOption.class) && byOptionListClazz.containsKey(clazz = t.getValue().getClass())) {
            return byOptionListClazz.get(clazz);
        }
        throw new NotRegisteredException();
    }

    private static Control<Integer, IntConfigOption> intControlFactory(class_310 class_3102, IntConfigOption intConfigOption, int n, int n2) {
        Control.ControlFactory controlFactory = intConfigOption.useSlider() ? IntSliderControl::new : IntTextControl::new;
        return controlFactory.create(class_3102, intConfigOption, n, n2);
    }

    private static Control<Float, FloatConfigOption> floatControlFactory(class_310 class_3102, FloatConfigOption floatConfigOption, int n, int n2) {
        Control.ControlFactory controlFactory = floatConfigOption.useSlider() ? FloatSliderControl::new : FloatTextControl::new;
        return controlFactory.create(class_3102, floatConfigOption, n, n2);
    }

    static {
        ControlRegistry.registerDefaults();
    }

    public static class RegistrationException
    extends Exception {
        private static final long serialVersionUID = 6700515423205896696L;
    }

    public static class NotRegisteredException
    extends Exception {
        private static final long serialVersionUID = -860661609717794905L;
    }
}

