/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.config;

import java.util.Objects;

public class ConfigPath
implements Comparable<ConfigPath> {
    public static final String DELIMITER = ".";
    protected final String group;
    protected final String id;

    protected ConfigPath(String string, String string2) {
        this.group = ConfigPath.sanitize(string);
        this.id = ConfigPath.sanitize(string2);
        assert (this.id != null);
    }

    public static ConfigPath of(String string) {
        return ConfigPath.of(null, string);
    }

    public static ConfigPath of(String string, String string2) {
        return new ConfigPath(string, string2);
    }

    public static ConfigPath parse(String string) {
        return ConfigPath.parse(string, DELIMITER);
    }

    public static ConfigPath parse(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return ConfigPath.of(string);
        }
        return ConfigPath.of(string.substring(0, n), string.substring(n + 1));
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }

    public String toString(String string) {
        if (this.group == null) {
            return this.id;
        }
        return this.group + string + this.id;
    }

    public String toString() {
        return this.toString(DELIMITER);
    }

    @Override
    public int compareTo(ConfigPath configPath) {
        int n = this.id.compareTo(configPath.id);
        if (n == 0) {
            n = Objects.compare(this.group, configPath.group, (string, string2) -> {
                if (string == null && string2 == null) {
                    return 0;
                }
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo((String)string2);
            });
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfigPath)) {
            return false;
        }
        ConfigPath configPath = (ConfigPath)object;
        return Objects.equals(this.group, configPath.group) && Objects.equals(this.id, configPath.id);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.id);
    }

    protected static String sanitize(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        return string.trim();
    }
}

