/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.AbstractConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.IncompatibleIntermediaryLevelException;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.TransformingSet;

public abstract class AbstractCommentedConfig
extends AbstractConfig
implements CommentedConfig {
    protected final Map<String, String> commentMap;

    public AbstractCommentedConfig(boolean bl) {
        super(bl);
        this.commentMap = AbstractCommentedConfig.getDefaultCommentMap(bl);
    }

    public AbstractCommentedConfig(Supplier<Map<String, Object>> supplier) {
        super(supplier);
        this.commentMap = AbstractConfig.getWildcardMapCreator(supplier).get();
    }

    public AbstractCommentedConfig(Map<String, Object> map) {
        super(map);
        this.commentMap = AbstractCommentedConfig.getDefaultCommentMap(map instanceof ConcurrentMap);
    }

    public AbstractCommentedConfig(Map<String, Object> map, Map<String, String> map2) {
        super(map);
        this.commentMap = map2;
    }

    public AbstractCommentedConfig(UnmodifiableConfig unmodifiableConfig, boolean bl) {
        super(unmodifiableConfig, bl);
        this.commentMap = AbstractCommentedConfig.getDefaultCommentMap(bl);
    }

    public AbstractCommentedConfig(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier) {
        super(unmodifiableConfig, supplier);
        this.commentMap = AbstractConfig.getWildcardMapCreator(supplier).get();
    }

    public AbstractCommentedConfig(UnmodifiableCommentedConfig unmodifiableCommentedConfig, boolean bl) {
        super((UnmodifiableConfig)unmodifiableCommentedConfig, bl);
        this.commentMap = AbstractCommentedConfig.getDefaultCommentMap(bl);
        this.commentMap.putAll(unmodifiableCommentedConfig.commentMap());
    }

    public AbstractCommentedConfig(UnmodifiableCommentedConfig unmodifiableCommentedConfig, Supplier<Map<String, Object>> supplier) {
        super((UnmodifiableConfig)unmodifiableCommentedConfig, supplier);
        this.commentMap = AbstractConfig.getWildcardMapCreator(supplier).get();
    }

    protected static Map<String, String> getDefaultCommentMap(boolean bl) {
        return AbstractConfig.getDefaultMapCreator(bl).get();
    }

    @Override
    public String getComment(List<String> list) {
        int n = list.size() - 1;
        String string = list.get(n);
        if (n == 0) {
            return this.commentMap.get(string);
        }
        Object t = this.getRaw(list.subList(0, n));
        if (t instanceof UnmodifiableCommentedConfig) {
            List<String> list2 = Collections.singletonList(string);
            return ((UnmodifiableCommentedConfig)t).getComment(list2);
        }
        return null;
    }

    @Override
    public String setComment(List<String> list, String string) {
        int n = list.size() - 1;
        String string2 = list.get(n);
        if (n == 0) {
            if (string != null) {
                return this.commentMap.put(string2, string);
            }
            return this.commentMap.remove(string2);
        }
        List<String> list2 = list.subList(0, n);
        Object t = this.getRaw(list2);
        List<String> list3 = Collections.singletonList(string2);
        if (t instanceof CommentedConfig) {
            return ((CommentedConfig)t).setComment(list3, string);
        }
        if (t == null) {
            Config config = this.createSubConfig();
            this.set(list2, (Object)config);
            return config.setComment(list3, string);
        }
        throw new IncompatibleIntermediaryLevelException("Cannot set a comment to path " + String.valueOf(list) + " because the parent entry is of incompatible type " + String.valueOf(t.getClass()));
    }

    @Override
    public String removeComment(List<String> list) {
        int n = list.size() - 1;
        String string = list.get(n);
        if (n == 0) {
            return this.commentMap.remove(string);
        }
        Object t = this.getRaw(list.subList(0, n));
        if (t instanceof CommentedConfig) {
            List<String> list2 = Collections.singletonList(string);
            return ((CommentedConfig)t).removeComment(list2);
        }
        return null;
    }

    @Override
    public boolean containsComment(List<String> list) {
        int n = list.size() - 1;
        String string = list.get(n);
        if (n == 0) {
            return this.commentMap.containsKey(string);
        }
        Object t = this.getRaw(list.subList(0, n));
        if (t instanceof CommentedConfig) {
            List<String> list2 = Collections.singletonList(string);
            return ((CommentedConfig)t).containsComment(list2);
        }
        return false;
    }

    @Override
    public Map<String, String> commentMap() {
        return this.commentMap;
    }

    @Override
    public Set<? extends CommentedConfig.Entry> entrySet() {
        return new TransformingSet<Map.Entry, CommentedEntryWrapper>(this.map.entrySet(), entry -> new CommentedEntryWrapper((Map.Entry<String, Object>)entry), commentedEntryWrapper -> null, object -> object);
    }

    @Override
    public abstract AbstractCommentedConfig clone();

    @Override
    public void clear() {
        super.clear();
        this.clearComments();
    }

    @Override
    public void clearComments() {
        this.commentMap.clear();
        for (Object v : this.map.values()) {
            if (!(v instanceof CommentedConfig)) continue;
            ((CommentedConfig)v).clearComments();
        }
    }

    protected class CommentedEntryWrapper
    extends AbstractConfig.EntryWrapper
    implements CommentedConfig.Entry {
        private List<String> path;

        public CommentedEntryWrapper(Map.Entry<String, Object> entry) {
            super(entry);
            this.path = null;
        }

        protected List<String> getPath() {
            if (this.path == null) {
                this.path = Collections.singletonList(this.getKey());
            }
            return this.path;
        }

        @Override
        public String getComment() {
            return AbstractCommentedConfig.this.getComment(this.getPath());
        }

        @Override
        public String setComment(String string) {
            return AbstractCommentedConfig.this.setComment(this.getPath(), string);
        }

        @Override
        public String removeComment() {
            return AbstractCommentedConfig.this.removeComment(this.getPath());
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CommentedEntryWrapper) {
                CommentedEntryWrapper commentedEntryWrapper = (CommentedEntryWrapper)object;
                return Objects.equals(this.getKey(), commentedEntryWrapper.getKey()) && Objects.equals(this.getValue(), commentedEntryWrapper.getValue()) && Objects.equals(this.getComment(), commentedEntryWrapper.getComment());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = 1;
            n = 31 * n + Objects.hashCode(this.getKey());
            n = 31 * n + Objects.hashCode(this.getValue());
            n = 31 * n + Objects.hashCode(this.getComment());
            return n;
        }

        public String toString() {
            return "CommentedEntryWrapper(" + this.getKey() + "=" + String.valueOf(this.getValue()) + ")";
        }
    }
}

