/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.CheckedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.InMemoryFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.SimpleConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.StringUtils;

public interface Config
extends UnmodifiableConfig {
    default public <T> T set(String string, Object object) {
        return this.set(StringUtils.split(string, '.'), object);
    }

    public <T> T set(List<String> var1, Object var2);

    public boolean add(List<String> var1, Object var2);

    default public boolean add(String string, Object object) {
        return this.add(StringUtils.split(string, '.'), object);
    }

    default public void addAll(UnmodifiableConfig unmodifiableConfig) {
        for (UnmodifiableConfig.Entry entry : unmodifiableConfig.entrySet()) {
            Object t;
            List<String> list = Collections.singletonList(entry.getKey());
            boolean bl = !this.add(list, t = entry.getRawValue());
            if (bl && !(t instanceof UnmodifiableConfig)) continue;
        }
    }

    default public void putAll(UnmodifiableConfig unmodifiableConfig) {
        this.valueMap().putAll(unmodifiableConfig.valueMap());
    }

    default public <T> T remove(String string) {
        return this.remove(StringUtils.split(string, '.'));
    }

    public <T> T remove(List<String> var1);

    default public void removeAll(UnmodifiableConfig unmodifiableConfig) {
        this.valueMap().keySet().removeAll(unmodifiableConfig.valueMap().keySet());
    }

    public void clear();

    default public UnmodifiableConfig unmodifiable() {
        return new UnmodifiableConfig(){

            @Override
            public <T> T getRaw(List<String> list) {
                return Config.this.getRaw(list);
            }

            @Override
            public boolean contains(List<String> list) {
                return Config.this.contains(list);
            }

            @Override
            public int size() {
                return Config.this.size();
            }

            @Override
            public Map<String, Object> valueMap() {
                return Collections.unmodifiableMap(Config.this.valueMap());
            }

            @Override
            public Set<? extends UnmodifiableConfig.Entry> entrySet() {
                return Config.this.entrySet();
            }

            @Override
            public ConfigFormat<?> configFormat() {
                return Config.this.configFormat();
            }
        };
    }

    default public Config checked() {
        return new CheckedConfig(this);
    }

    @Override
    public Map<String, Object> valueMap();

    public Set<? extends Entry> entrySet();

    public Config createSubConfig();

    default public void update(String string, Object object) {
        this.set(string, object);
    }

    default public void update(List<String> list, Object object) {
        this.set(list, object);
    }

    public static Config of(ConfigFormat<? extends Config> configFormat) {
        return new SimpleConfig(configFormat, false);
    }

    public static Config of(Supplier<Map<String, Object>> supplier, ConfigFormat<?> configFormat) {
        return new SimpleConfig(supplier, configFormat);
    }

    @Deprecated
    public static Config ofConcurrent(ConfigFormat<? extends Config> configFormat) {
        return new SimpleConfig(configFormat, true);
    }

    public static Config inMemory() {
        return InMemoryFormat.defaultInstance().createConfig();
    }

    public static Config inMemoryUniversal() {
        return InMemoryFormat.withUniversalSupport().createConfig();
    }

    @Deprecated
    public static Config inMemoryConcurrent() {
        return InMemoryFormat.defaultInstance().createConcurrentConfig();
    }

    @Deprecated
    public static Config inMemoryUniversalConcurrent() {
        return InMemoryFormat.withUniversalSupport().createConcurrentConfig();
    }

    public static Config wrap(Map<String, Object> map, ConfigFormat<?> configFormat) {
        return new SimpleConfig(map, configFormat);
    }

    public static Config copy(UnmodifiableConfig unmodifiableConfig) {
        return new SimpleConfig(unmodifiableConfig, unmodifiableConfig.configFormat(), false);
    }

    public static Config copy(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier) {
        return new SimpleConfig(unmodifiableConfig, supplier, unmodifiableConfig.configFormat());
    }

    public static Config copy(UnmodifiableConfig unmodifiableConfig, ConfigFormat<?> configFormat) {
        return new SimpleConfig(unmodifiableConfig, configFormat, false);
    }

    public static Config copy(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier, ConfigFormat<?> configFormat) {
        return new SimpleConfig(unmodifiableConfig, supplier, configFormat);
    }

    public static Config concurrentCopy(UnmodifiableConfig unmodifiableConfig) {
        return new SimpleConfig(unmodifiableConfig, unmodifiableConfig.configFormat(), true);
    }

    public static Config concurrentCopy(UnmodifiableConfig unmodifiableConfig, ConfigFormat<?> configFormat) {
        return new SimpleConfig(unmodifiableConfig, configFormat, true);
    }

    public static boolean isInsertionOrderPreserved() {
        String string = System.getProperty("nightconfig.preserveInsertionOrder");
        return string != null && (string.equals("true") || string.equals("1"));
    }

    public static void setInsertionOrderPreserved(boolean bl) {
        System.setProperty("nightconfig.preserveInsertionOrder", bl ? "true" : "false");
    }

    @Deprecated
    public static <T> Supplier<Map<String, T>> getDefaultMapCreator(boolean bl, boolean bl2) {
        if (bl2) {
            return bl ? () -> Collections.synchronizedMap(new LinkedHashMap()) : LinkedHashMap::new;
        }
        return bl ? ConcurrentHashMap::new : HashMap::new;
    }

    @Deprecated
    public static <T> Supplier<Map<String, T>> getDefaultMapCreator(boolean bl) {
        return Config.getDefaultMapCreator(bl, Config.isInsertionOrderPreserved());
    }

    public static interface Entry
    extends UnmodifiableConfig.Entry {
        public <T> T setValue(Object var1);
    }
}

