/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core;

import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.InMemoryFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigWriter;

public class InMemoryCommentedFormat
implements ConfigFormat<CommentedConfig> {
    private static final InMemoryCommentedFormat DEFAULT_INSTANCE = new InMemoryCommentedFormat(InMemoryFormat.DEFAULT_PREDICATE);
    private static final InMemoryCommentedFormat UNIVERSAL_INSTANCE = new InMemoryCommentedFormat(clazz -> true);
    private final Predicate<Class<?>> supportPredicate;

    public static InMemoryCommentedFormat defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static InMemoryCommentedFormat withSupport(Predicate<Class<?>> predicate) {
        return new InMemoryCommentedFormat(predicate);
    }

    public static InMemoryCommentedFormat withUniversalSupport() {
        return UNIVERSAL_INSTANCE;
    }

    private InMemoryCommentedFormat(Predicate<Class<?>> predicate) {
        this.supportPredicate = predicate;
    }

    @Override
    public ConfigWriter createWriter() {
        throw new UnsupportedOperationException("In memory configurations aren't meant to be written.");
    }

    @Override
    public ConfigParser<CommentedConfig> createParser() {
        throw new UnsupportedOperationException("In memory configurations aren't meant to be parsed.");
    }

    @Override
    public CommentedConfig createConfig(Supplier<Map<String, Object>> supplier) {
        return CommentedConfig.of(supplier, this);
    }

    @Override
    public boolean supportsComments() {
        return true;
    }

    @Override
    public boolean supportsType(Class<?> clazz) {
        return this.supportPredicate.test(clazz);
    }

    @Override
    public boolean isInMemory() {
        return true;
    }
}

