/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.armorstands.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.AnnotationUtils;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.Converter;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.ForceBreakdown;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.InvalidValueException;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.ReflectionException;
import me.roundaround.armorstands.roundalib.nightconfig.core.conversion.SpecEnum;

@Deprecated
public final class ObjectConverter {
    private final boolean bypassTransient;
    private final boolean bypassFinal;

    public ObjectConverter(boolean bl, boolean bl2) {
        this.bypassTransient = bl;
        this.bypassFinal = bl2;
    }

    public ObjectConverter() {
        this(false, true);
    }

    public void toConfig(Object object, Config config) {
        Objects.requireNonNull(object, "The object must not be null.");
        Objects.requireNonNull(config, "The config must not be null.");
        Class<?> clazz = object.getClass();
        List<String> list = AnnotationUtils.getPath(clazz);
        if (list != null) {
            config = (Config)config.getRaw(list);
        }
        this.convertToConfig(object, clazz, config);
    }

    public void toConfig(Class<?> clazz, Config config) {
        Objects.requireNonNull(config, "The config must not be null.");
        List<String> list = AnnotationUtils.getPath(clazz);
        if (list != null) {
            config = (Config)config.getRaw(list);
        }
        this.convertToConfig(null, clazz, config);
    }

    public <C extends Config> C toConfig(Object object, Supplier<C> supplier) {
        Config config = (Config)supplier.get();
        this.toConfig(object, config);
        return (C)config;
    }

    public <C extends Config> C toConfig(Class<?> clazz, Supplier<C> supplier) {
        Config config = (Config)supplier.get();
        this.toConfig(clazz, config);
        return (C)config;
    }

    public void toObject(UnmodifiableConfig unmodifiableConfig, Object object) {
        Objects.requireNonNull(unmodifiableConfig, "The config must not be null.");
        Objects.requireNonNull(object, "The object must not be null.");
        Class<?> clazz = object.getClass();
        List<String> list = AnnotationUtils.getPath(clazz);
        if (list != null) {
            unmodifiableConfig = (UnmodifiableConfig)unmodifiableConfig.getRaw(list);
        }
        this.convertToObject(unmodifiableConfig, object, clazz);
    }

    public <O> O toObject(UnmodifiableConfig unmodifiableConfig, Supplier<O> supplier) {
        O o = supplier.get();
        this.toObject(unmodifiableConfig, o);
        return o;
    }

    private void convertToConfig(Object object, Class<?> clazz, Config config) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                Object object2;
                Object object3;
                int n = field.getModifiers();
                if (object != null && Modifier.isStatic(n) || !this.bypassTransient && Modifier.isTransient(n)) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    object3 = field.get(object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ReflectionException("Unable to parse the field " + String.valueOf(field), illegalAccessException);
                }
                AnnotationUtils.checkField(field, object3);
                Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
                if (converter != null) {
                    object3 = converter.convertFromField(object3);
                }
                List<String> list = AnnotationUtils.getPath(field);
                ConfigFormat<?> configFormat = config.configFormat();
                if (object3 == null) {
                    config.set(list, null);
                    continue;
                }
                Class<?> clazz2 = object3.getClass();
                if (Enum.class.isAssignableFrom(clazz2)) {
                    if (config.configFormat().supportsType(Enum.class)) {
                        config.set(list, object3);
                        continue;
                    }
                    config.set(list, (Object)object3.toString());
                    continue;
                }
                if (field.isAnnotationPresent(ForceBreakdown.class) || !configFormat.supportsType(clazz2)) {
                    config.set(list, object3);
                    object2 = config.createSubConfig();
                    this.convertToConfig(object3, clazz2, (Config)object2);
                    config.set(list, object2);
                    continue;
                }
                if (object3 instanceof Collection) {
                    object2 = (Collection)object3;
                    Class<?> clazz3 = this.bottomElementType((Collection<?>)object2);
                    if (configFormat.supportsType(clazz3)) {
                        config.set(list, object3);
                        continue;
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(object2.size());
                    this.convertObjectsToConfigs((Collection<?>)object2, clazz3, (Collection<Object>)arrayList, config);
                    config.set(list, arrayList);
                    continue;
                }
                config.set(list, object3);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void convertToObject(UnmodifiableConfig unmodifiableConfig, Object object, Class<?> clazz) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                int n = field.getModifiers();
                if (object == null && Modifier.isStatic(n) || !this.bypassFinal && Modifier.isFinal(n)) continue;
                field.setAccessible(true);
                if (!this.bypassTransient && Modifier.isTransient(n)) continue;
                List<String> list = AnnotationUtils.getPath(field);
                Object object2 = unmodifiableConfig.get(list);
                Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
                if (converter != null) {
                    object2 = converter.convertToField(object2);
                }
                Class<?> clazz2 = field.getType();
                try {
                    Object object3;
                    Object object4;
                    Class<?> clazz3;
                    if (object2 instanceof UnmodifiableConfig && !clazz2.isAssignableFrom(object2.getClass())) {
                        clazz3 = (UnmodifiableConfig)object2;
                        object4 = field.get(object);
                        if (object4 == null) {
                            object4 = this.createInstance(clazz2);
                            field.set(object, object4);
                            this.convertToObject((UnmodifiableConfig)((Object)clazz3), object4, field.getType());
                            continue;
                        }
                        this.convertToObject((UnmodifiableConfig)((Object)clazz3), object4, field.getType());
                        continue;
                    }
                    if (object2 instanceof Collection && Collection.class.isAssignableFrom(clazz2)) {
                        clazz3 = (Collection)object2;
                        object4 = this.bottomElementType((Collection<?>)((Object)clazz3));
                        object3 = (ParameterizedType)field.getGenericType();
                        List<Class<?>> list2 = this.elementTypes((ParameterizedType)object3);
                        Class<?> clazz4 = list2.get(list2.size() - 1);
                        if (object4 == null || clazz4 == null || clazz4.isAssignableFrom((Class<?>)object4)) {
                            AnnotationUtils.checkField(field, object2);
                            field.set(object, object2);
                            continue;
                        }
                        Collection collection = (ArrayList)field.get(object);
                        if (collection == null) {
                            collection = clazz2 == ArrayList.class || clazz2.isInterface() || Modifier.isAbstract(clazz2.getModifiers()) ? new ArrayList(clazz3.size()) : (Collection)this.createInstance(clazz2);
                            field.set(object, collection);
                        }
                        this.convertConfigsToObject((Collection<?>)((Object)clazz3), collection, list2, 0);
                        AnnotationUtils.checkField(field, collection);
                        continue;
                    }
                    if (object2 == null && AnnotationUtils.mustPreserve(field, clazz)) {
                        AnnotationUtils.checkField(field, field.get(object));
                        continue;
                    }
                    AnnotationUtils.checkField(field, object2);
                    if (field.getType().isEnum()) {
                        clazz3 = field.getType();
                        object4 = field.getAnnotation(SpecEnum.class);
                        object3 = object4 == null ? EnumGetMethod.NAME_IGNORECASE : object4.method();
                        field.set(object, ((EnumGetMethod)((Object)object3)).get(object2, clazz3));
                        continue;
                    }
                    field.set(object, object2);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new ReflectionException("Unable to work with field " + String.valueOf(field), reflectiveOperationException);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private Class<?> bottomElementType(ParameterizedType parameterizedType) {
        if (parameterizedType != null && parameterizedType.getActualTypeArguments().length > 0) {
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType2 = (ParameterizedType)type;
                Class clazz = (Class)parameterizedType2.getRawType();
                if (clazz.isAssignableFrom(Collection.class)) {
                    return this.bottomElementType(parameterizedType2);
                }
                return clazz;
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return null;
    }

    private void detectElementTypes(ParameterizedType parameterizedType, List<Class<?>> list) {
        if (parameterizedType != null && parameterizedType.getActualTypeArguments().length > 0) {
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType2 = (ParameterizedType)type;
                Class clazz = (Class)parameterizedType2.getRawType();
                list.add(clazz);
                if (Collection.class.isAssignableFrom(clazz)) {
                    this.detectElementTypes(parameterizedType2, list);
                }
            } else if (type instanceof Class) {
                list.add((Class)type);
            }
        }
    }

    private List<Class<?>> elementTypes(ParameterizedType parameterizedType) {
        ArrayList arrayList = new ArrayList();
        this.detectElementTypes(parameterizedType, arrayList);
        return arrayList;
    }

    private Class<?> bottomElementType(Collection<?> collection) {
        for (Object obj : collection) {
            if (obj instanceof Collection) {
                return this.bottomElementType((Collection)obj);
            }
            if (obj == null) continue;
            return obj.getClass();
        }
        return null;
    }

    private void convertConfigsToObject(Collection<?> collection, Collection<Object> collection2, List<Class<?>> list, int n) {
        Class<?> clazz = list.get(n);
        for (Object obj : collection) {
            Object object;
            if (obj == null) {
                collection2.add(null);
                continue;
            }
            if (obj instanceof Collection) {
                object = (Collection)obj;
                Collection<Object> collection3 = clazz == ArrayList.class || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) ? new ArrayList<Object>() : (Collection)this.createInstance(clazz);
                this.convertConfigsToObject((Collection<?>)object, collection3, list, n + 1);
                collection2.add(collection3);
                continue;
            }
            if (obj instanceof UnmodifiableConfig) {
                object = this.createInstance(clazz);
                this.convertToObject((UnmodifiableConfig)obj, object, clazz);
                collection2.add(object);
                continue;
            }
            object = obj.getClass().toString();
            throw new InvalidValueException("Unexpected element of type " + (String)object + " in collection of objects");
        }
    }

    private void convertObjectsToConfigs(Collection<?> collection, Class<?> clazz, Collection<Object> collection2, Config config) {
        for (Object obj : collection) {
            Object object;
            if (obj == null) {
                collection2.add(null);
                continue;
            }
            if (clazz.isAssignableFrom(obj.getClass())) {
                object = config.createSubConfig();
                this.convertToConfig(obj, obj.getClass(), (Config)object);
                collection2.add(object);
                continue;
            }
            if (obj instanceof Collection) {
                object = new ArrayList();
                this.convertObjectsToConfigs((Collection)obj, clazz, (Collection<Object>)object, config);
                ((ArrayList)object).trimToSize();
                collection2.add(object);
                continue;
            }
            object = obj.getClass().toString();
            throw new InvalidValueException("Unexpected element of type " + (String)object + " in collection of " + String.valueOf(clazz));
        }
    }

    private <T> T createInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ReflectionException("Unable to create an instance of " + String.valueOf(clazz), reflectiveOperationException);
        }
    }
}

