/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Function;
import me.roundaround.armorstands.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.concurrent.SynchronizedConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.file.AsyncFileConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.file.ConfigLoadFilter;
import me.roundaround.armorstands.roundalib.nightconfig.core.file.FileNotFoundAction;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ConfigWriter;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.ParsingMode;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.WritingMode;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.CommentedConfigWrapper;

final class SyncFileConfig
extends CommentedConfigWrapper<SynchronizedConfig>
implements CommentedFileConfig {
    private final Path nioPath;
    private final Charset charset;
    private volatile boolean closed;
    private final ConfigWriter writer;
    private final WritingMode writingMode;
    private final ConfigParser<?> parser;
    private final FileNotFoundAction nefAction;
    private final ParsingMode parsingMode;
    private final ConfigLoadFilter reloadFilter;
    private final Runnable saveListener;
    private final Runnable loadListener;

    SyncFileConfig(SynchronizedConfig synchronizedConfig, Path path, Charset charset, ConfigWriter configWriter, WritingMode writingMode, ConfigParser<?> configParser, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, ConfigLoadFilter configLoadFilter, Runnable runnable, Runnable runnable2) {
        super(synchronizedConfig);
        this.nioPath = path;
        this.charset = charset;
        this.writer = configWriter;
        this.parser = configParser;
        this.parsingMode = parsingMode;
        this.nefAction = fileNotFoundAction;
        this.writingMode = writingMode;
        this.reloadFilter = configLoadFilter;
        this.saveListener = runnable;
        this.loadListener = runnable2;
    }

    @Override
    public File getFile() {
        return this.nioPath.toFile();
    }

    @Override
    public Path getNioPath() {
        return this.nioPath;
    }

    @Override
    public void save() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot save().");
        }
        ((SynchronizedConfig)this.config).bulkCommentedRead(unmodifiableCommentedConfig -> this.writer.write((UnmodifiableConfig)unmodifiableCommentedConfig, this.nioPath, this.writingMode, this.charset));
        this.saveListener.run();
    }

    @Override
    public void load() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot load().");
        }
        if (this.reloadFilter == null) {
            ((SynchronizedConfig)this.config).bulkCommentedUpdate((? super CommentedConfig commentedConfig) -> this.parser.parse(this.nioPath, (Config)commentedConfig, this.parsingMode, this.nefAction, this.charset));
        } else {
            Object obj = this.parser.parse(this.nioPath, this.nefAction, this.charset);
            CommentedConfig commentedConfig2 = CommentedConfig.fake(obj);
            if (!this.reloadFilter.acceptNewVersion(commentedConfig2)) {
                return;
            }
            switch (this.parsingMode) {
                case REPLACE: {
                    ((SynchronizedConfig)this.config).replaceContentBy(commentedConfig2);
                    break;
                }
                default: {
                    AsyncFileConfig.putWithParsingMode(this.parsingMode, commentedConfig2, (ConcurrentCommentedConfig)this.config);
                }
            }
        }
        this.loadListener.run();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        return ((SynchronizedConfig)this.config).bulkCommentedUpdate(function);
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> function) {
        return ((SynchronizedConfig)this.config).bulkUpdate(function);
    }
}

