/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.serde;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.NullObject;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.AnnotationProcessor;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.DeserializerContext;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.ObjectDeserializerBuilder;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.TypeConstraint;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.Util;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.ValueDeserializer;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.ValueDeserializerProvider;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdeDefault;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdePhase;

class AbstractObjectDeserializer {
    protected final List<ValueDeserializerProvider<?, ?>> generalProviders;
    protected ValueDeserializerProvider<?, ?> defaultProvider;
    protected final boolean applyTransientModifier;

    protected AbstractObjectDeserializer(ObjectDeserializerBuilder objectDeserializerBuilder) {
        this.generalProviders = objectDeserializerBuilder.deserializerProviders;
        this.defaultProvider = objectDeserializerBuilder.defaultProvider;
        this.applyTransientModifier = objectDeserializerBuilder.applyTransientModifier;
        assert (this.generalProviders != null && this.defaultProvider != null);
    }

    protected <C extends Collection<V>, V> C deserializeToCollection(Object object, Class<C> clazz, Class<V> clazz2) {
        DeserializerContext deserializerContext = new DeserializerContext(this);
        TypeConstraint typeConstraint = new TypeConstraint(new TypeConstraint.ManuallyParameterized(clazz, clazz2));
        return (C)((Collection)deserializerContext.deserializeValue(object, Optional.of(typeConstraint)));
    }

    protected <M extends Map<String, V>, V> M deserializeToMap(Object object, Class<M> clazz, Class<V> clazz2) {
        DeserializerContext deserializerContext = new DeserializerContext(this);
        TypeConstraint typeConstraint = new TypeConstraint(new TypeConstraint.ManuallyParameterized(clazz, new Type[]{String.class, clazz2}));
        return (M)((Map)deserializerContext.deserializeValue(object, Optional.of(typeConstraint)));
    }

    protected void deserializeFields(UnmodifiableConfig unmodifiableConfig, Object object) {
        DeserializerContext deserializerContext = new DeserializerContext(this);
        deserializerContext.deserializeFields(unmodifiableConfig, object);
    }

    protected <R> R deserializeFields(UnmodifiableConfig unmodifiableConfig, Supplier<? extends R> supplier) {
        R r = supplier.get();
        this.deserializeFields(unmodifiableConfig, r);
        return r;
    }

    protected <T, R> ValueDeserializer<T, R> findValueDeserializer(T t, TypeConstraint typeConstraint) {
        ValueDeserializer<?, ?> valueDeserializer;
        Class<?> clazz = t == null ? null : t.getClass();
        for (ValueDeserializerProvider<?, ?> valueDeserializerProvider : this.generalProviders) {
            valueDeserializer = valueDeserializerProvider.provide(clazz, typeConstraint);
            if (valueDeserializer == null) continue;
            return valueDeserializer;
        }
        valueDeserializer = this.defaultProvider.provide(clazz, typeConstraint);
        if (valueDeserializer != null) {
            return valueDeserializer;
        }
        Object object = clazz == null ? "" : " of type " + String.valueOf(clazz);
        throw new SerdeException("No suitable deserializer found for value" + (String)object + ": " + String.valueOf(t) + " and result constraint " + String.valueOf(typeConstraint));
    }

    protected Supplier<?> findDefaultValueSupplier(Object object, Field field, Object object2) {
        EnumMap<SerdeDefault.WhenValue, SerdeDefault> enumMap = AnnotationProcessor.getConfigDefaultAnnotations(field).get((Object)SerdePhase.DESERIALIZING);
        if (enumMap == null) {
            return null;
        }
        SerdeDefault serdeDefault = null;
        if (object == null) {
            serdeDefault = enumMap.get((Object)SerdeDefault.WhenValue.IS_MISSING);
        } else if (object == NullObject.NULL_OBJECT) {
            serdeDefault = enumMap.get((Object)SerdeDefault.WhenValue.IS_NULL);
        } else {
            SerdeDefault serdeDefault2 = enumMap.get((Object)SerdeDefault.WhenValue.IS_EMPTY);
            if (serdeDefault2 != null && Util.isEmpty(object)) {
                serdeDefault = serdeDefault2;
            }
        }
        if (serdeDefault == null) {
            return null;
        }
        return AnnotationProcessor.resolveConfigDefaultProvider(serdeDefault, object2);
    }
}

