/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.serde;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.armorstands.roundalib.nightconfig.core.NullObject;
import me.roundaround.armorstands.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.AbstractObjectDeserializer;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.AnnotationProcessor;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.SerdeAssertException;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.TypeConstraint;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.ValueDeserializer;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdeAssert;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdeKey;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdePhase;
import me.roundaround.armorstands.roundalib.nightconfig.core.serde.annotations.SerdeSkipDeserializingIf;

public final class DeserializerContext {
    final AbstractObjectDeserializer settings;

    DeserializerContext(AbstractObjectDeserializer abstractObjectDeserializer) {
        this.settings = abstractObjectDeserializer;
    }

    public Object deserializeValue(Object object, Optional<TypeConstraint> optional) {
        TypeConstraint typeConstraint = optional.orElse(new TypeConstraint((Type)((Object)Object.class)));
        ValueDeserializer valueDeserializer = this.settings.findValueDeserializer(object, typeConstraint);
        return valueDeserializer.deserialize(object, optional, this);
    }

    public void deserializeFields(UnmodifiableConfig unmodifiableConfig, Object object) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Object object2;
                List<String> list;
                Object object3;
                if (!this.preCheck(field) || this.skipField(field, object, object3 = unmodifiableConfig.getRaw(list = Collections.singletonList(this.configKey(field))))) continue;
                Supplier<?> supplier = this.settings.findDefaultValueSupplier(object3, field, object);
                if (supplier != null) {
                    try {
                        object2 = supplier.get();
                    }
                    catch (Exception exception) {
                        throw new SerdeException("Error in default value provider for field " + String.valueOf(field), exception);
                    }
                }
                object3 = this.normalizeForDeserialization(object3, list, field);
                TypeConstraint typeConstraint = new TypeConstraint(field.getGenericType());
                ValueDeserializer valueDeserializer = this.settings.findValueDeserializer(object3, typeConstraint);
                try {
                    Optional<TypeConstraint> optional = Optional.of(typeConstraint);
                    object2 = valueDeserializer.deserialize(object3, optional, this);
                }
                catch (Exception exception) {
                    throw new SerdeException("Error during deserialization of value `" + String.valueOf(object3) + "` to field `" + String.valueOf(field) + "` with deserializer " + String.valueOf(valueDeserializer), exception);
                }
                if (!this.assertField(field, object, object3)) {
                    throw new SerdeAssertException("Field `" + String.valueOf(field) + "` has an invalid value: " + String.valueOf(object3));
                }
                try {
                    field.set(object, object2);
                }
                catch (Exception exception) {
                    throw new SerdeException("Could not assign the deserialized value `" + String.valueOf(object2) + "` to the field " + String.valueOf(field) + ". The original config value was " + String.valueOf(object3));
                }
            }
        }
    }

    private Object normalizeForDeserialization(Object object, List<String> list, Field field) {
        if (object == null) {
            throw new SerdeException("Missing configuration entry " + String.valueOf(list) + " for field `" + String.valueOf(field) + "` declared in " + String.valueOf(field.getDeclaringClass()));
        }
        if (object == NullObject.NULL_OBJECT) {
            return null;
        }
        return object;
    }

    private String configKey(Field field) {
        SerdeKey serdeKey = field.getAnnotation(SerdeKey.class);
        return serdeKey == null ? field.getName() : serdeKey.value();
    }

    private boolean skipField(Field field, Object object, Object object2) {
        SerdeSkipDeserializingIf serdeSkipDeserializingIf = field.getAnnotation(SerdeSkipDeserializingIf.class);
        if (serdeSkipDeserializingIf == null) {
            return false;
        }
        try {
            Predicate<?> predicate = AnnotationProcessor.resolveSkipDeserializingIfPredicate(serdeSkipDeserializingIf, object);
            return predicate.test(object2);
        }
        catch (Exception exception) {
            String string = "Failed to resolve or apply skip predicate for deserialization of field " + String.valueOf(field);
            throw new SerdeException(string, exception);
        }
    }

    private boolean assertField(Field field, Object object, Object object2) {
        SerdeAssert[] serdeAssertArray = (SerdeAssert[])field.getAnnotationsByType(SerdeAssert.class);
        if (serdeAssertArray == null || serdeAssertArray.length == 0) {
            return true;
        }
        try {
            Predicate<?> predicate = AnnotationProcessor.resolveAssertPredicate(serdeAssertArray, object, SerdePhase.DESERIALIZING, field);
            if (predicate == null) {
                return true;
            }
            return predicate.test(object2);
        }
        catch (Exception exception) {
            String string = "Failed to resolve or apply assertion for deserialization of field " + String.valueOf(field);
            throw new SerdeException(string, exception);
        }
    }

    private boolean preCheck(Field field) {
        int n = field.getModifiers();
        if (Modifier.isStatic(n) || field.isSynthetic()) {
            return false;
        }
        if (Modifier.isTransient(n) && this.settings.applyTransientModifier) {
            return false;
        }
        if (Modifier.isFinal(n) || !Modifier.isPublic(n)) {
            field.setAccessible(true);
        }
        return true;
    }
}

