/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.core.utils;

import java.util.NoSuchElementException;

public final class IntDeque {
    private int[] data;
    private int head = 0;
    private int tail = 0;
    private int mask;

    public IntDeque() {
        this(4);
    }

    public IntDeque(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The capacity must be positive and non-zero.");
        }
        if (!this.isPowerOfTwo(n)) {
            n = this.nextPowerOfTwo(n);
        }
        this.data = new int[n];
        this.mask = n - 1;
    }

    private boolean isPowerOfTwo(int n) {
        return (n & -n) == n;
    }

    private int nextPowerOfTwo(int n) {
        return Integer.highestOneBit(n) << 1;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        if (this.tail >= this.head) {
            return this.tail - this.head;
        }
        return this.data.length - this.head + this.tail;
    }

    public void compact() {
        if (this.tail == this.head) {
            this.data = new int[1];
            this.head = 0;
            this.tail = 0;
            this.mask = 0;
            return;
        }
        int n = this.size();
        int n2 = n + 1;
        if (!this.isPowerOfTwo(n2)) {
            n2 = this.nextPowerOfTwo(n2);
        }
        int[] nArray = new int[n2];
        if (this.tail > this.head) {
            System.arraycopy(this.data, this.head, nArray, 0, this.tail - this.head);
        } else {
            int n3 = this.data.length - this.head;
            System.arraycopy(this.data, this.head, nArray, 0, n3);
            System.arraycopy(this.data, 0, nArray, n3, this.tail);
        }
        this.head = 0;
        this.tail = n;
        this.data = nArray;
        this.mask = nArray.length - 1;
    }

    private void grow() {
        int n = this.data.length << 1;
        if (n < 0) {
            throw new IllegalStateException("IntDeque too big");
        }
        int[] nArray = new int[n];
        int n2 = this.data.length - this.head;
        System.arraycopy(this.data, this.head, nArray, 0, n2);
        System.arraycopy(this.data, 0, nArray, n2, this.tail);
        this.head = 0;
        this.tail = this.data.length;
        this.data = nArray;
        this.mask = nArray.length - 1;
    }

    public void addFirst(int n) {
        this.head = this.head - 1 & this.mask;
        this.data[this.head] = n;
        if (this.head == this.tail) {
            this.grow();
        }
    }

    public void addLast(int n) {
        this.data[this.tail] = n;
        this.tail = this.tail + 1 & this.mask;
        if (this.tail == this.head) {
            this.grow();
        }
    }

    public int get(int n) {
        if (n >= this.size()) {
            throw new NoSuchElementException("No element at index " + n);
        }
        return this.data[this.head + n & this.mask];
    }

    public int getFirst() {
        if (this.tail == this.head) {
            throw new NoSuchElementException("Empty deque");
        }
        return this.data[this.head];
    }

    public int getLast() {
        if (this.tail == this.head) {
            throw new NoSuchElementException("Empty deque");
        }
        return this.data[this.tail - 1 & this.mask];
    }

    public int removeFirst() {
        if (this.tail == this.head) {
            throw new NoSuchElementException("Empty deque");
        }
        int n = this.data[this.head];
        this.head = this.head + 1 & this.mask;
        return n;
    }

    public int removeLast() {
        if (this.tail == this.head) {
            throw new NoSuchElementException("Empty deque");
        }
        this.tail = this.tail - 1 & this.mask;
        return this.data[this.tail];
    }
}

