/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.nightconfig.toml;

import java.util.Iterator;
import me.roundaround.armorstands.roundalib.nightconfig.core.io.CharacterOutput;
import me.roundaround.armorstands.roundalib.nightconfig.core.utils.StringUtils;
import me.roundaround.armorstands.roundalib.nightconfig.toml.Toml;
import me.roundaround.armorstands.roundalib.nightconfig.toml.TomlWriter;

final class StringWriter {
    private static final char[] ESCAPED_B = new char[]{'\\', 'b'};
    private static final char[] ESCAPED_F = new char[]{'\\', 'f'};
    private static final char[] ESCAPED_N = new char[]{'\\', 'n'};
    private static final char[] ESCAPED_R = new char[]{'\\', 'r'};
    private static final char[] ESCAPED_T = new char[]{'\\', 't'};
    private static final char[] ESCAPED_BACKSLASH = new char[]{'\\', '\\'};
    private static final char[] ESCAPED_QUOTE = new char[]{'\\', '\"'};

    static void writeBasic(String string, CharacterOutput characterOutput) {
        characterOutput.write('\"');
        string.codePoints().forEach(n -> StringWriter.writeBasicChar(n, characterOutput));
        characterOutput.write('\"');
    }

    static void writeBasicMultiline(String string, CharacterOutput characterOutput, TomlWriter tomlWriter) {
        characterOutput.write("\"\"\"");
        Iterator<String> iterator = StringUtils.splitLines(string).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            tomlWriter.writeNewline(characterOutput);
            char[] cArray = string2.toCharArray();
            block7: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (c) {
                    case '\"': {
                        if (i + 1 == cArray.length && !iterator.hasNext() || i + 1 < cArray.length && cArray[i + 1] == '\"' && i + 2 < cArray.length && cArray[i + 2] == '\"' && i + 3 < cArray.length) {
                            characterOutput.write(ESCAPED_QUOTE);
                            continue block7;
                        }
                        characterOutput.write(c);
                        continue block7;
                    }
                    case '\b': {
                        characterOutput.write(ESCAPED_B);
                        continue block7;
                    }
                    case '\f': {
                        characterOutput.write(ESCAPED_F);
                        continue block7;
                    }
                    case '\\': {
                        characterOutput.write(ESCAPED_BACKSLASH);
                        continue block7;
                    }
                    default: {
                        if (c != '\t' && c != '\n' && c != '\r' && Toml.isControlChar(c)) {
                            characterOutput.write(StringWriter.escapeUnicode(c));
                            continue block7;
                        }
                        characterOutput.write(Character.toChars(c));
                    }
                }
            }
        }
        characterOutput.write("\"\"\"");
    }

    static void writeLiteral(String string, CharacterOutput characterOutput) {
        characterOutput.write('\'');
        characterOutput.write(string);
        characterOutput.write('\'');
    }

    static void writeLiteralMultiline(String string, CharacterOutput characterOutput) {
        characterOutput.write("'''\n");
        characterOutput.write(string);
        characterOutput.write("''''");
    }

    private static void writeBasicChar(int n, CharacterOutput characterOutput) {
        switch (n) {
            case 92: {
                characterOutput.write(ESCAPED_BACKSLASH);
                break;
            }
            case 34: {
                characterOutput.write(ESCAPED_QUOTE);
                break;
            }
            case 8: {
                characterOutput.write(ESCAPED_B);
                break;
            }
            case 12: {
                characterOutput.write(ESCAPED_F);
                break;
            }
            case 10: {
                characterOutput.write(ESCAPED_N);
                break;
            }
            case 13: {
                characterOutput.write(ESCAPED_R);
                break;
            }
            case 9: {
                characterOutput.write(ESCAPED_T);
                break;
            }
            default: {
                if (Toml.isControlChar(n)) {
                    characterOutput.write(StringWriter.escapeUnicode(n));
                    break;
                }
                characterOutput.write(Character.toChars(n));
            }
        }
    }

    static String escapeUnicode(int n) {
        Object object;
        block3: {
            block2: {
                object = Integer.toHexString(n).toUpperCase();
                if (((String)object).length() >= 4) break block2;
                while (((String)object).length() < 4) {
                    object = "0" + (String)object;
                }
                break block3;
            }
            if (((String)object).length() >= 8) break block3;
            while (((String)object).length() < 8) {
                object = "0" + (String)object;
            }
        }
        return "\\u" + (String)object;
    }

    private StringWriter() {
    }
}

