/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.observable;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiPredicate;
import me.roundaround.armorstands.roundalib.observable.ComputedImpl;
import me.roundaround.armorstands.roundalib.observable.Mapper;
import me.roundaround.armorstands.roundalib.observable.Observable;
import me.roundaround.armorstands.roundalib.observable.Observer;
import me.roundaround.armorstands.roundalib.observable.Subscription;

public class ObservableImpl<T>
implements Observable<T> {
    protected static final Object PRESENT = new Object();
    protected final HashMap<Observer.P1<T>, Object> observers = new HashMap();
    protected T value;
    protected boolean isHot = true;
    protected BiPredicate<T, T> equals = Objects::equals;

    ObservableImpl(T t) {
        this.value = t;
    }

    @Override
    public ObservableImpl<T> hot() {
        this.isHot = true;
        return this;
    }

    @Override
    public ObservableImpl<T> cold() {
        this.isHot = false;
        return this;
    }

    @Override
    public ObservableImpl<T> nonDistinct() {
        this.equals = (object, object2) -> false;
        return this;
    }

    @Override
    public ObservableImpl<T> distinct(BiPredicate<T, T> biPredicate) {
        this.equals = biPredicate;
        return this;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void emit() {
        this.observers.keySet().forEach(p1 -> p1.handle(this.value));
    }

    @Override
    public Subscription subscribe(Observer.P0 p0) {
        if (this.isHot) {
            p0.handle();
        }
        return this.subscribe((T object) -> p0.handle());
    }

    @Override
    public Subscription subscribe(Observer.P1<T> p1) {
        if (this.isHot) {
            p1.handle(this.value);
        }
        this.observers.put(p1, PRESENT);
        return () -> this.unsubscribe(p1);
    }

    @Override
    public boolean unsubscribe(Observer.P1<T> p1) {
        return this.observers.remove(p1) != null;
    }

    @Override
    public void close() {
        this.observers.clear();
    }

    public <S> ComputedImpl<T, S> map(Mapper.P1<T, S> p1) {
        return new ComputedImpl<T, S>(this, p1);
    }

    void set(T t) {
        if (this.equals.test(this.value, t)) {
            return;
        }
        this.value = t;
        this.emit();
    }

    void setWithForceEmit(T t) {
        this.value = t;
        this.emit();
    }

    void setWithNoEmit(T t) {
        this.value = t;
    }

    public static <T> ObservableImpl<T> of(T t) {
        return new ObservableImpl<T>(t);
    }
}

