/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import me.roundaround.armorstands.entity.ArmorStandInventory;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.mixin.LivingEntityAccessor;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.server.network.ServerNetworking;
import me.roundaround.armorstands.util.ArmorStandEditor;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ArmorStandScreenHandler
extends class_1703 {
    private static final class_2960 EMPTY_MAINHAND_ARMOR_SLOT = class_2960.method_60656((String)"container/slot/sword");
    private static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_2960[] EMPTY_HAND_SLOT_TEXTURES = new class_2960[]{EMPTY_MAINHAND_ARMOR_SLOT, class_1723.field_21673};
    private static final class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private static final class_1304[] HAND_SLOT_ORDER = new class_1304[]{class_1304.field_6173, class_1304.field_6171};
    private final class_1661 playerInventory;
    private final class_1531 armorStand;
    private final ScreenType screenType;
    private final ArmorStandInventory inventory;
    private final ArmorStandEditor editor;
    private final ArrayList<Pair<class_1735, class_1304>> armorSlots = new ArrayList();

    public ArmorStandScreenHandler(int n, class_1661 class_16612, class_1531 class_15312, ScreenType screenType) {
        super(null, n);
        this.playerInventory = class_16612;
        this.armorStand = class_15312;
        this.screenType = screenType;
        this.inventory = new ArmorStandInventory(class_15312, ((LivingEntityAccessor)class_15312).getEquipment());
        class_1657 class_16572 = class_16612.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 class_32222 = (class_3222)class_16572;
            this.editor = ArmorStandEditor.get(class_32222, class_15312);
        } else {
            this.editor = null;
        }
        this.inventory.method_5435((class_11565)this.playerInventory.field_7546);
        if (this.screenType != null && this.screenType.usesInventory()) {
            this.initSlots();
        }
    }

    private void initSlots() {
        class_1304 class_13042;
        int n;
        int n2;
        for (n2 = 0; n2 < 9; ++n2) {
            this.method_7621(new class_1735((class_1263)this.playerInventory, n2, 8 + n2 * 18, 142));
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 9; ++n) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, n + (n2 + 1) * 9, 8 + n * 18, 84 + n2 * 18));
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            n = n2;
            class_13042 = HAND_SLOT_ORDER[n2];
            class_1735 class_17352 = this.method_7621(new class_1735(this.inventory, n, 116, 44 + n * 18){

                public void method_53512(class_1799 class_17992) {
                    ArmorStandScreenHandler.this.armorStand.method_5673(class_13042, class_17992);
                    this.method_7668();
                }

                public class_2960 method_7679() {
                    return EMPTY_HAND_SLOT_TEXTURES[n];
                }

                public boolean method_7674(class_1657 class_16572) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_68878() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, class_13042)) {
                        return false;
                    }
                    return super.method_7674(class_16572);
                }

                public boolean method_7680(class_1799 class_17992) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_68878() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, class_13042)) {
                        return false;
                    }
                    return super.method_7680(class_17992);
                }
            });
            this.armorSlots.add((Pair<class_1735, class_1304>)Pair.of((Object)class_17352, (Object)class_13042));
        }
        for (n2 = 0; n2 < 4; ++n2) {
            final class_1304 class_13043 = EQUIPMENT_SLOT_ORDER[n2];
            class_13042 = this.method_7621(new class_1735(this.inventory, 5 - n2, 44, 8 + n2 * 18){

                public void method_53512(class_1799 class_17992) {
                    ArmorStandScreenHandler.this.armorStand.method_5673(class_13043, class_17992);
                    this.method_7668();
                }

                public int method_7675() {
                    return 1;
                }

                public boolean method_7674(class_1657 class_16572) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_68878() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, class_13043)) {
                        return false;
                    }
                    return super.method_7674(class_16572);
                }

                public boolean method_7680(class_1799 class_17992) {
                    if (!ArmorStandScreenHandler.this.playerInventory.field_7546.method_68878() && ArmorStandScreenHandler.isSlotDisabled(ArmorStandScreenHandler.this.armorStand, class_13043)) {
                        return false;
                    }
                    return class_13043 == ArmorStandScreenHandler.this.armorStand.method_32326(class_17992);
                }

                public class_2960 method_7679() {
                    return EMPTY_ARMOR_SLOT_TEXTURES[class_13043.method_5927()];
                }
            });
            this.armorSlots.add((Pair<class_1735, class_1304>)Pair.of((Object)class_13042, (Object)class_13043));
        }
    }

    public ImmutableList<Pair<class_1735, class_1304>> getArmorSlots() {
        return ImmutableList.copyOf(this.armorSlots);
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    public ArmorStandEditor getEditor() {
        return this.editor;
    }

    public class_1661 getPlayerInventory() {
        return this.playerInventory;
    }

    public void method_7623() {
        if (this.playerInventory.field_7546 instanceof class_3222) {
            ServerNetworking.sendClientUpdatePacket((class_3222)this.playerInventory.field_7546, this.armorStand);
        }
        super.method_7623();
    }

    public boolean method_7597(class_1657 class_16572) {
        return this.inventory.method_5443(class_16572);
    }

    public class_1799 method_7601(class_1657 class_16572, int n) {
        if (n < 0 || n >= this.field_7761.size()) {
            return class_1799.field_8037;
        }
        class_1735 class_17352 = (class_1735)this.field_7761.get(n);
        if (!class_17352.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 class_17992 = class_17352.method_7677();
        class_1799 class_17993 = class_17992.method_7972();
        if (n < 36 ? !this.tryTransferArmor(class_17992) && !this.tryTransferToMainHand(class_17992) && !this.tryTransferToOffHand(class_17992) : !this.method_7616(class_17992, 0, 36, false)) {
            return class_1799.field_8037;
        }
        if (class_17992.method_7960()) {
            class_17352.method_53512(class_1799.field_8037);
        } else {
            class_17352.method_7668();
        }
        return class_17993;
    }

    private boolean tryTransferArmor(class_1799 class_17992) {
        class_1304 class_13042 = this.armorStand.method_32326(class_17992);
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_13042)) {
            return false;
        }
        int n = this.field_7761.size() - 1 - class_13042.method_5927();
        return this.method_7616(class_17992, n, n + 1, false);
    }

    private boolean tryTransferToMainHand(class_1799 class_17992) {
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_1304.field_6173)) {
            return false;
        }
        int n = 36;
        return this.method_7616(class_17992, n, n + 1, false);
    }

    private boolean tryTransferToOffHand(class_1799 class_17992) {
        if (ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_1304.field_6171)) {
            return false;
        }
        int n = 37;
        return this.method_7616(class_17992, n, n + 1, false);
    }

    public static boolean isSlotDisabled(class_1531 class_15312, class_1304 class_13042) {
        return (((ArmorStandEntityAccessor)class_15312).getDisabledSlots() & 1 << class_13042.method_5927()) != 0;
    }
}

