/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.server;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.roundaround.armorstands.network.Networking;
import me.roundaround.armorstands.roundalib.config.option.StringListConfigOption;
import me.roundaround.armorstands.server.config.ServerSideConfig;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ArmorStandUsers {
    public static final int PERMISSION_LEVEL = 2;

    private ArmorStandUsers() {
    }

    public static boolean canEditArmorStands(class_3222 class_32222) {
        MinecraftServer minecraftServer = class_32222.method_51469().method_8503();
        if (!(minecraftServer instanceof class_3176)) {
            return true;
        }
        if (!ServerPlayNetworking.canSend((class_3222)class_32222, Networking.PongS2C.ID)) {
            return false;
        }
        ServerSideConfig serverSideConfig = ServerSideConfig.getInstance();
        if (!((Boolean)serverSideConfig.enforcePermissions.getValue()).booleanValue()) {
            return true;
        }
        if (((Boolean)serverSideConfig.opsHavePermissions.getValue()).booleanValue() && class_32222.method_64475(2)) {
            return true;
        }
        return ArmorStandUsers.contains(class_32222.method_72498());
    }

    public static boolean contains(class_11560 class_115602) {
        return ((List)ServerSideConfig.getInstance().allowedUsers.getValue()).contains(class_115602.comp_4422().toString());
    }

    public static void add(class_11560 class_115602) {
        StringListConfigOption stringListConfigOption = ServerSideConfig.getInstance().allowedUsers;
        String string = class_115602.comp_4422().toString();
        if (((List)stringListConfigOption.getValue()).stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
            stringListConfigOption.add(string);
            if (stringListConfigOption.isDirty()) {
                ServerSideConfig.getInstance().writeToStore();
            }
        }
    }

    public static void remove(class_11560 class_115602) {
        StringListConfigOption stringListConfigOption = ServerSideConfig.getInstance().allowedUsers;
        stringListConfigOption.remove(class_115602.comp_4422().toString());
        if (stringListConfigOption.isDirty()) {
            ServerSideConfig.getInstance().writeToStore();
        }
    }

    public static void reload() {
        ServerSideConfig.getInstance().syncWithStore();
    }

    public static Collection<String> listNames(MinecraftServer minecraftServer) {
        class_11561 class_115612 = minecraftServer.method_73550().comp_4407();
        return ((List)ServerSideConfig.getInstance().allowedUsers.getValue()).stream().map(string -> {
            UUID uUID;
            try {
                uUID = UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            Optional optional = class_115612.method_14512(uUID);
            return optional.map(class_11560::comp_4423).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

