/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.server.config;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.mixin.AbstractPropertiesHandlerAccessor;
import me.roundaround.armorstands.mixin.ServerConfigEntryAccessor;
import me.roundaround.armorstands.roundalib.config.ConfigPath;
import me.roundaround.armorstands.roundalib.config.manage.ModConfigImpl;
import me.roundaround.armorstands.roundalib.config.manage.store.WorldScopedFileStore;
import me.roundaround.armorstands.roundalib.config.option.BooleanConfigOption;
import me.roundaround.armorstands.roundalib.config.option.StringListConfigOption;
import me.roundaround.armorstands.roundalib.nightconfig.core.Config;
import net.minecraft.class_11869;
import net.minecraft.class_11871;
import net.minecraft.class_3176;
import net.minecraft.class_3337;
import net.minecraft.class_3340;
import net.minecraft.class_3806;

public class ServerSideConfig
extends ModConfigImpl
implements WorldScopedFileStore,
AutoCloseable {
    private static ServerSideConfig instance = null;
    private static final String LEGACY_PROP_KEY = "enforce-armor-stand-permissions";
    private static final String LEGACY_USERS_FILE = "armorstandsusers.json";
    public BooleanConfigOption requireSneakingToEdit;
    public BooleanConfigOption enforcePermissions;
    public BooleanConfigOption opsHavePermissions;
    public StringListConfigOption allowedUsers;
    private class_3176 server;

    public static ServerSideConfig getInstance() {
        if (instance == null || ServerSideConfig.instance.server == null) {
            throw new RuntimeException("Armor Stands mod server-side config not initialized properly! This is a bug with the mod. Please report it to the mod's author.");
        }
        return instance;
    }

    public static ServerSideConfig create(class_3176 class_31762) {
        if (instance != null) {
            instance.close();
        }
        instance = new ServerSideConfig(class_31762);
        return instance;
    }

    private ServerSideConfig(class_3176 class_31762) {
        super("armorstands", "server");
        this.server = class_31762;
    }

    @Override
    public void initializeStore() {
        super.initializeStore();
    }

    @Override
    protected void registerOptions() {
        this.requireSneakingToEdit = this.buildRegistration((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("requireSneakingToEdit")).setDefaultValue(false)).setComment("Require users to sneak to use the mod.")).build()).serverOnly().commit();
        this.enforcePermissions = this.buildRegistration((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("enforcePermissions")).setDefaultValue(true)).setComment("Only allow permitted users to use the mod.")).build()).serverOnly().commit();
        this.opsHavePermissions = this.buildRegistration((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("opsHavePermissions")).setDefaultValue(true)).setComment("Whether server OPs are always permitted to use the mod.")).build()).serverOnly().commit();
        this.allowedUsers = this.buildRegistration((StringListConfigOption)((StringListConfigOption.Builder)StringListConfigOption.builder(ConfigPath.of("allowedUsers")).setComment("List of users by their UUID permitted to use the mod.")).build()).serverOnly().commit();
    }

    @Override
    public boolean performConfigUpdate(int n, Config config) {
        return this.performLegacyMigration(config);
    }

    private boolean performLegacyMigration(Config config) {
        String string;
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        String string2 = this.enforcePermissions.getPath().toString();
        if (!config.contains(string2)) {
            this.getLegacyPermissionsEnforced().ifPresent(bl -> {
                config.add(string2, bl);
                atomicBoolean.set(true);
            });
        }
        if (config.contains(string = this.allowedUsers.getPath().toString())) {
            if (Files.isReadable(Paths.get(LEGACY_USERS_FILE, new String[0]))) {
                ArmorStandsMod.LOGGER.warn("Users listed in config file, but legacy {} file still exists. Consider removing it.", (Object)LEGACY_USERS_FILE);
            }
        } else {
            config.set(string, this.getLegacyAllowlist());
            atomicBoolean.set(true);
        }
        return atomicBoolean.get();
    }

    @Override
    public void close() {
        this.server = null;
    }

    private Optional<Boolean> getLegacyPermissionsEnforced() {
        if (this.server == null) {
            return Optional.empty();
        }
        class_3806 class_38062 = this.server.method_16705();
        Properties properties = ((AbstractPropertiesHandlerAccessor)class_38062).getProperties();
        String string = properties.getProperty(LEGACY_PROP_KEY);
        properties.remove(LEGACY_PROP_KEY);
        if (string == null || string.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(string));
    }

    private List<String> getLegacyAllowlist() {
        Path path = Paths.get(LEGACY_USERS_FILE, new String[0]);
        if (!Files.isReadable(path)) {
            return List.of();
        }
        class_3337 class_33372 = new class_3337(path.toFile(), (class_11871)new class_11869());
        try {
            class_33372.method_14630();
        }
        catch (IOException iOException) {
            ArmorStandsMod.LOGGER.warn("Failed to parse legacy {} file during automatic config migration. Skipping.", (Object)LEGACY_USERS_FILE, (Object)iOException);
            return List.of();
        }
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            ArmorStandsMod.LOGGER.warn("Failed to remove legacy {} file during automatic config migration.", (Object)LEGACY_USERS_FILE, (Object)iOException);
        }
        return class_33372.method_14632().stream().map(this::extractUuid).toList();
    }

    private String extractUuid(class_3340 class_33402) {
        return ((GameProfile)((ServerConfigEntryAccessor)class_33402).invokeGetKey()).id().toString();
    }
}

