/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.server.network;

import java.util.function.Supplier;
import me.roundaround.armorstands.network.Networking;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.ArmorStandEditor;
import me.roundaround.armorstands.util.MoveMode;
import me.roundaround.armorstands.util.MoveUnits;
import me.roundaround.armorstands.util.actions.AdjustPosAction;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_2350;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class ServerNetworking {
    private ServerNetworking() {
    }

    public static void sendClientUpdatePacket(class_3222 class_32222, class_1531 class_15312) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.ClientUpdateS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.ClientUpdateS2C(class_15312));
        }
    }

    public static void sendMessagePacket(class_3222 class_32222, String string) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.MessageS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.MessageS2C(string));
        }
    }

    public static void sendMessagePacket(class_3222 class_32222, String string, int n) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.MessageS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.MessageS2C(string, n));
        }
    }

    public static void sendOpenScreenPacket(class_3222 class_32222, int n, class_1531 class_15312, ScreenType screenType) {
        if (ServerPlayNetworking.canSend((class_3222)class_32222, Networking.OpenScreenS2C.ID)) {
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.OpenScreenS2C(n, class_15312.method_5628(), screenType));
        }
    }

    public static void sendPongPacket(class_3222 class_32222) {
        ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new Networking.PongS2C(class_32222.method_5667()));
    }

    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(Networking.AdjustPoseC2S.ID, ServerNetworking::handleAdjustPose);
        ServerPlayNetworking.registerGlobalReceiver(Networking.AdjustPosC2S.ID, ServerNetworking::handleAdjustPos);
        ServerPlayNetworking.registerGlobalReceiver(Networking.AdjustYawC2S.ID, ServerNetworking::handleAdjustYaw);
        ServerPlayNetworking.registerGlobalReceiver(Networking.PingC2S.ID, ServerNetworking::handlePing);
        ServerPlayNetworking.registerGlobalReceiver(Networking.RequestScreenC2S.ID, ServerNetworking::handleRequestScreen);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetFlagC2S.ID, ServerNetworking::handleSetFlag);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetPoseC2S.ID, ServerNetworking::handleSetPose);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetPosePresetC2S.ID, ServerNetworking::handleSetPosePreset);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetScaleC2S.ID, ServerNetworking::handleSetScale);
        ServerPlayNetworking.registerGlobalReceiver(Networking.SetYawC2S.ID, ServerNetworking::handleSetYaw);
        ServerPlayNetworking.registerGlobalReceiver(Networking.UndoC2S.ID, ServerNetworking::handleUndo);
        ServerPlayNetworking.registerGlobalReceiver(Networking.UtilityActionC2S.ID, ServerNetworking::handleUtilityAction);
    }

    private static void handleAdjustPose(Networking.AdjustPoseC2S adjustPoseC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.adjustPose(adjustPoseC2S.part(), adjustPoseC2S.parameter(), adjustPoseC2S.amount());
        });
    }

    private static void handleAdjustPos(Networking.AdjustPosC2S adjustPosC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            MoveMode moveMode = adjustPosC2S.mode();
            class_2350 class_23502 = adjustPosC2S.direction();
            int n = adjustPosC2S.amount();
            MoveUnits moveUnits = adjustPosC2S.units();
            armorStandEditor.applyAction(moveMode.isLocal() ? AdjustPosAction.local(class_23502, n, moveUnits, moveMode.isLocalToPlayer()) : AdjustPosAction.relative(class_23502, n, moveUnits));
        });
    }

    private static void handleAdjustYaw(Networking.AdjustYawC2S adjustYawC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.rotate(adjustYawC2S.amount());
        });
    }

    private static void handlePing(Networking.PingC2S pingC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ServerNetworking.sendPongPacket(context.player()));
    }

    private static void handleRequestScreen(Networking.RequestScreenC2S requestScreenC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 class_32222 = context.player();
            class_1297 class_12972 = class_32222.method_51469().method_8469(requestScreenC2S.armorStandId());
            if (!(class_12972 instanceof class_1531)) {
                return;
            }
            class_1531 class_15312 = (class_1531)class_12972;
            class_32222.armorstands$openScreen(class_15312, requestScreenC2S.screenType());
        });
    }

    private static void handleSetFlag(Networking.SetFlagC2S setFlagC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 class_32222 = context.player();
            class_1703 class_17032 = class_32222.field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.setFlag(setFlagC2S.flag(), setFlagC2S.value());
            ServerNetworking.sendClientUpdatePacket(class_32222, armorStandEditor.getArmorStand());
        });
    }

    private static void handleSetPose(Networking.SetPoseC2S setPoseC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.setPose(setPoseC2S.head(), setPoseC2S.body(), setPoseC2S.rightArm(), setPoseC2S.leftArm(), setPoseC2S.rightLeg(), setPoseC2S.leftLeg());
        });
    }

    private static void handleSetPosePreset(Networking.SetPosePresetC2S setPosePresetC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.setPose(setPosePresetC2S.pose().toPose());
        });
    }

    private static void handleSetScale(Networking.SetScaleC2S setScaleC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.setScale(setScaleC2S.scale());
        });
    }

    private static void handleSetYaw(Networking.SetYawC2S setYawC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_1703 class_17032 = context.player().field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            armorStandEditor.setRotation(setYawC2S.angle());
        });
    }

    private static void handleUndo(Networking.UndoC2S undoC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            String string;
            class_3222 class_32222 = context.player();
            class_1703 class_17032 = class_32222.field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            Supplier<Boolean> supplier = undoC2S.redo() ? armorStandEditor::redo : armorStandEditor::undo;
            String string2 = undoC2S.redo() ? "armorstands.message.redo" : "armorstands.message.undo";
            String string3 = string = undoC2S.redo() ? "armorstands.message.redo.fail" : "armorstands.message.undo.fail";
            if (supplier.get().booleanValue()) {
                ServerNetworking.sendMessagePacket(class_32222, string2);
            } else {
                ServerNetworking.sendMessagePacket(class_32222, string);
            }
        });
    }

    private static void handleUtilityAction(Networking.UtilityActionC2S utilityActionC2S, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 class_32222 = context.player();
            class_1703 class_17032 = class_32222.field_7512;
            if (!(class_17032 instanceof ArmorStandScreenHandler)) {
                return;
            }
            ArmorStandScreenHandler armorStandScreenHandler = (ArmorStandScreenHandler)class_17032;
            ArmorStandEditor armorStandEditor = armorStandScreenHandler.getEditor();
            utilityActionC2S.action().apply(armorStandEditor, class_32222);
        });
    }
}

