{
  id: "blazingresolve",
  name: "Blazing Resolve",
  rating: 3,
  num: 9028,
  flags: {mirror:1},

  onStart(pokemon) {
    this.effectState.usedFire = false;
  },

  onAfterMovePriority: 1,
  onAfterMove(source, target, move) {
    if (source === this.effectState.target && move.type === 'Fire') {
      this.effectState.usedFire = true;
    }
  },

  onResidual(pokemon) {
    const s = this.effectState;
    if (pokemon === this.effectState.target && s.usedFire) {
      this.heal(Math.floor(pokemon.maxhp / 16), pokemon, 'ability: Blazing Resolve');
      s.usedFire = false;
    }
  }
}
