{
  id: "braveheart",
  name: "Braveheart",
  shortDesc: "Instant +1 to all stats and heal on entry; 1.5× STAB on Dragon/Fire that ignore resistance; blocks drops & status; regen each turn.",
  rating: 6,
  num: 9040,
  flags: {breakable: 1},

  onStart(pokemon) {
    this.effectState.target = pokemon;
    this.add("-ability", pokemon, "Braveheart");
    this.boost({atk: 1, def: 1, spa: 1, spd: 1, spe: 1}, pokemon);
    this.heal(pokemon.maxhp / 8);
  },

  onBasePowerPriority: 21,
  onBasePower(basePower, attacker, defender, move) {
    if (move.type === "Dragon" || move.type === "Fire") {
      return this.chainModify(1.5);
    }
  },

  onEffectiveness(typeMod, target, type, move) {
    if (move.type === "Dragon" || move.type === "Fire") {
      return 0;
    }
  },

  onTryBoost(boost, target, source, effect) {
    if (target === this.effectState.target && source && target !== source) {
      for (const stat in boost) {
        if (boost[stat] < 0) delete boost[stat];
      }
    }
  },

  onSetStatus(status, target, source, effect) {
    if (target === this.effectState.target && source && target !== source) {
      return false;
    }
  },

  onResidual(pokemon) {
    if (pokemon === this.effectState.target) {
      this.heal(pokemon.maxhp / 16);
    }
  },
}
