{
  id: "coreoverdrive",
  name: "Core Overdrive",
  rating: 4,
  num: 9032,
  flags: {mirror:1},

  onStart(pokemon) {
    const s = this.effectState;
    s.target = pokemon;
    s.coreActive = false;
    this.add('-ability', pokemon, "Core Overdrive");
  },

  onBasePowerPriority: 23,
  onBasePower(basePower, attacker, defender, move) {
    if (attacker === this.effectState.target && (move.type === 'Fire' || move.type === 'Steel')) {
      return this.chainModify(1.2);
    }
  },

  onAfterMove(source, target, move) {
    const s = this.effectState;
    if (source === s.target && (move.type === 'Fire' || move.type === 'Steel')) {
      s.coreActive = true;
    }
  },

  onModifyPriority(priority, source, move) {
    const s = this.effectState;
    if (source === s.target && s.coreActive) {
      return priority + 1;
    }
  }
}
