{
  name: "True Core",
  num: 9004,
  rating: 7,
  flags: {},

  onStart(pokemon) {
    this.add(`${pokemon.name}'s True Core awakens — ancient dragon data floods the battlefield!`);
    const foes = pokemon.side.foe.active.filter(f => f && !f.fainted);
    for (const foe of foes) {
      this.boost({ atk: -1, def: -1, spa: -1, spd: -1, spe: -1 }, foe);
      this.add(`${foe.name} is overwhelmed by the aura of the ancient dragon!`);
    }
  },

  onAfterMove(source, target, move) {
    if (move.category !== 'Status' && move.hit) {
      this.boost({ atk: 1, spa: 1, def: 1, spd: 1 }, source);
      this.add(`${source.name}'s True Core surges with overwhelming power!`);
    }
  },

  onModifyDamage(damage, source, target, move) {
    if (['Steel', 'Dragon', 'Fire'].includes(move.type)) {
      return this.chainModify(1.25);
    }
  },

  onSourceModifyDamage(damage, source, target, move) {
    if (move.type === 'Dragon') {
      this.add(`${target.name}'s dragon data shields it from draconic power!`);
      return this.chainModify(0.5);
    }
  }
}
