package iced.betterthanbread;

import iced.betterthanbread.blocks.ModBlockEntities;
import iced.betterthanbread.blocks.ModBlocks;
import iced.betterthanbread.recipes.ButterChurnRecipe;
import io.wispforest.owo.Owo;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import iced.betterthanbread.items.ModItems;

public class BetterThanBread implements ModInitializer {
	public static final String MOD_ID = "betterthanbread";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_3956<ButterChurnRecipe> BUTTER_CHURN = class_3956.method_17726("betterthanbread:butter_churn");

    public static final class_1865<ButterChurnRecipe> BUTTER_CHURN_SERIALIZER = class_2378.method_10230(
            class_7923.field_41189,
            new class_2960(MOD_ID, "butter_churn"),
            new ButterChurnRecipe.Serializer()
    );

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
        ModItems.registerModItems();
        ModItems.GROUP.initialize();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerModBlockEntities();
        LOGGER.info("Hello Fabric world!");
	}
}