package iced.betterthanbread.blocks.custom;

import iced.betterthanbread.blocks.entity.ButterChurnBlockEntity;
import iced.betterthanbread.items.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import iced.betterthanbread.BetterThanBread;

public class ButterChurnBlock extends class_2248 implements class_2343 {

    private static final class_265 SHAPE = class_2248.method_9541(3.0, 0.0, 3.0, 13.0, 13.0, 13.0);

    public ButterChurnBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos,
                              class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;

        var be = (ButterChurnBlockEntity) world.method_8321(pos);
        if (be == null) return class_1269.field_5811;

        class_1799 held = player.method_5998(hand);

        // Get recipe manager and find matching recipe
        var recipeManager = world.method_8433();
        var recipes = recipeManager.method_30027(BetterThanBread.BUTTER_CHURN);

        // Check if held item matches any recipe input
        for (var recipe : recipes) {
            if (recipe.getInput().method_8093(held)) {
                if (!be.hasInput()) {
                    be.insertInput(held.method_7909());
                    if (!player.method_7337()) {
                        held.method_7934(1);
                    }
                    return class_1269.field_21466;
                }
            }
        }

        if (held.method_31574(class_1802.field_8600) && be.hasInput()) {
            be.churn();
            return class_1269.field_21466;
        }

        if (held.method_7960() && be.isReady()) {
            // Get the output from the recipe
            for (var recipe : recipes) {
                if (recipe.getInput().method_8093(new class_1799(be.getInputItem()))) {
                    player.method_7270(recipe.getOutput().method_7972());
                    be.reset();
                    return class_1269.field_5812;
                }
            }
        }

        return class_1269.field_5811;
    }

    @Nullable
    @Override
    public ButterChurnBlockEntity method_10123(class_2338 pos, class_2680 state) {
        return new ButterChurnBlockEntity(pos, state);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }
}
