package iced.betterthanbread.compat.jei;

import iced.betterthanbread.BetterThanBread;
import iced.betterthanbread.blocks.ModBlocks;
import iced.betterthanbread.recipes.ButterChurnCategory;
import iced.betterthanbread.recipes.ButterChurnRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import mezz.jei.api.recipe.RecipeType;
import java.util.List;

@JeiPlugin
public class ButterChurnJeiPlugin implements IModPlugin {
    public static final RecipeType<ButterChurnRecipe> BUTTER_CHURN_TYPE =
            RecipeType.create(BetterThanBread.MOD_ID, "butter_churn", ButterChurnRecipe.class);

    private static final class_2960 PLUGIN_ID = new class_2960(BetterThanBread.MOD_ID, "jei_plugin");

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new ButterChurnCategory(registration.getJeiHelpers().getGuiHelper()));
    }

    @Override
    public class_2960 getPluginUid() {
        return PLUGIN_ID;
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        // Safely get recipes without relying on the world
        class_1863 recipeManager = null;
        class_310 client = class_310.method_1551();

        if (client != null && client.field_1687 != null) {
            recipeManager = client.field_1687.method_8433();
        }

        if (recipeManager != null) {
            List<ButterChurnRecipe> recipes = recipeManager.method_30027(BetterThanBread.BUTTER_CHURN);
            registration.addRecipes(BUTTER_CHURN_TYPE, recipes);
        }
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799(ModBlocks.BUTTER_CHURN.method_8389()), BUTTER_CHURN_TYPE);
    }
}