package iced.betterthanbread.blocks.entity;

import iced.betterthanbread.blocks.ModBlockEntities;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ButterChurnBlockEntity extends class_2586 {
    private boolean hasMilk = false;
    private int churnProgress = 0;
    private final int churnNeeded = 5;

    public ButterChurnBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BUTTER_CHURN, pos, state);
    }

    public void insertMilk() {
        hasMilk = true;
        churnProgress = 0;

        if (field_11863 != null) {
            field_11863.method_45447(
                    null,
                    field_11867,
                    class_3417.field_14834,
                    class_3419.field_15245
            );
        }

        method_5431();
    }

    public void churn() {
        if (field_11863 == null || field_11863.field_9236) return;

        if (hasMilk && churnProgress < churnNeeded) {
            churnProgress++;

            field_11863.method_45447(
                    null,
                    field_11867,
                    class_3417.field_17603,
                    class_3419.field_15245
            );

            if (field_11863 instanceof class_3218 serverWorld) {
                serverWorld.method_14199(
                        class_2398.field_11202,
                        field_11867.method_10263() + 0.5,
                        field_11867.method_10264() + 1,
                        field_11867.method_10260() + 0.5,
                        6,
                        0.25,
                        0.15,
                        0.25,
                        0.02
                );
            }

            method_5431();
        }
    }

    public boolean hasMilk() {
        return hasMilk;
    }

    public boolean isReady() {
        return hasMilk && churnProgress >= churnNeeded;
    }

    public void reset() {
        hasMilk = false;
        churnProgress = 0;

        if (field_11863 != null) {
            field_11863.method_45447(
                    null,
                    field_11867,
                    class_3417.field_17604,
                    class_3419.field_15245
            );
        }

        method_5431();
    }
}