package iced.betterthanbread.items;
import iced.betterthanbread.BetterThanBread;

import iced.betterthanbread.items.custom.RollingPinItem;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.Icon;

import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;

public class ModItems {
    // For the mod's ItemGroup
    public static final OwoItemGroup GROUP = OwoItemGroup
            .builder(new class_2960(BetterThanBread.MOD_ID, "betterthanbread"), () -> Icon.of(itemGroupIcon()))
            .build();

    // Lazily load the cinnamon texture
    private static class_1792 itemGroupIcon() {
        return CINNAMON;
    }

    public static final class_1792 CINNAMON = simpleItem("cinnamon", 0.1f);
    public static final class_1792 SAUSAGE = foodItem("sausage", ModFoodComponent.SAUSAGE, 0.45f);
    public static final class_1792 RAW_SAUSAGE = foodItem("raw_sausage", ModFoodComponent.RAW_SAUSAGE, 0.35f);

    public static final class_1792 RAW_CINNAMON_ROLL_DOUGH = foodItem("raw_cinnamon_roll_dough", ModFoodComponent.RAW_CINNAMON_ROLL_DOUGH, 0.3f);
    public static final class_1792 RAW_CINNAMON_ROLL = foodItem("raw_cinnamon_roll", ModFoodComponent.RAW_CINNAMON_ROLL, 0.3f);
    public static final class_1792 CINNAMON_ROLL = foodItem("cinnamon_roll", ModFoodComponent.CINNAMON_ROLL, 0.45f);
    public static final class_1792 GLAZED_CINNAMON_ROLL = foodItem("glazed_cinnamon_roll", ModFoodComponent.GLAZED_CINNAMON_ROLL, 0.5f);

    public static final class_1792 ROLLING_PIN = registerItem("rolling_pin",
            new RollingPinItem(new OwoItemSettings()
                    .group(ModItems.GROUP)
                    .method_7889(1)
                    .method_7895(64)
            ));

    public static final class_1792 RAW_CROISSANT = foodItem("raw_croissant", ModFoodComponent.RAW_CROISSANT, 0.25f);
    public static final class_1792 CROISSANT = foodItem("croissant", ModFoodComponent.CROISSANT, 0.4f);

    public static final class_1792 BUTTER = foodItem("butter", ModFoodComponent.BUTTER, 0.1f);

    //public static final Item SAUSAGE_IN_DOUGH = foodItem("sausage_in_dough", ModFoodComponent.MEAT_IN_DOUGH, 0.5f);
    //public static final Item BEEF_IN_DOUGH = foodItem("beef_in_dough", ModFoodComponent.MEAT_IN_DOUGH, 0.5f);
    //public static final Item RAW_SAUSAGE_IN_DOUGH = foodItem("raw_sausage_in_dough", ModFoodComponent.RAW_MEAT_IN_DOUGH, 0.35f);
    //public static final Item RAW_BEEF_IN_DOUGH = foodItem("raw_beef_in_dough", ModFoodComponent.RAW_MEAT_IN_DOUGH, 0.35f);

    // Mincer Parts
    public static final class_1792 BLADE = simpleItem("blade", 0);

    private static class_1792 registerItem(String name, class_1792 item) {
        return class_2378.method_10230(class_7923.field_41178, new class_2960(BetterThanBread.MOD_ID, name), item);
    }

    private static class_1792 foodItem(String name, class_4174 food, float composting) {
        class_1792 item = registerItem(name, new class_1792(new OwoItemSettings().method_19265(food)
                .group(ModItems.GROUP)
        ));
        if (composting > 0) {
            CompostingChanceRegistry.INSTANCE.add(item, composting);
        }
        return item;
    }

    private static class_1792 simpleItem(String name, float composting) {
        class_1792 item = registerItem(name, new class_1792(new OwoItemSettings()
                .group(ModItems.GROUP)
        ));
        if (composting > 0) {
            CompostingChanceRegistry.INSTANCE.add(item, composting);
        }
        return item;
    }

    public static void registerModItems() {
        BetterThanBread.LOGGER.info("Registering Mod Items for " + BetterThanBread.MOD_ID);
    }
}
