/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.crossbow_scoping.common;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5538;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import survivalblock.crossbow_scoping.client.networking.ScopedCrossbowC2SPayload;
import survivalblock.crossbow_scoping.common.init.CrossbowScopingDataComponentTypes;
import survivalblock.crossbow_scoping.common.init.CrossbowScopingGameRules;
import survivalblock.crossbow_scoping.common.init.CrossbowScopingTags;

public class CrossbowScoping
implements ModInitializer {
    public static final String MOD_ID = "crossbow_scoping";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"crossbow_scoping");

    public void onInitialize() {
        CrossbowScopingDataComponentTypes.init();
        CrossbowScopingGameRules.init();
        PayloadTypeRegistry.playC2S().register(ScopedCrossbowC2SPayload.ID, ScopedCrossbowC2SPayload.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ScopedCrossbowC2SPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)ScopedCrossbowC2SPayload.Receiver.INSTANCE);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static Pair<class_1799, class_1268> getCrossbowWithScope(class_1657 player) {
        return CrossbowScoping.getCrossbowWithScope(player, false, false);
    }

    public static Pair<class_1799, class_1268> getCrossbowWithScope(class_1657 player, boolean checkLoaded, boolean checkCooldown) {
        Predicate<class_1799> predicate = stack -> !(!CrossbowScoping.isValidCrossbow(stack) || ((class_1799)stack.method_58695(CrossbowScopingDataComponentTypes.CROSSBOW_SCOPE, (Object)class_1799.field_8037)).method_7960() || checkLoaded && !CrossbowScoping.isLoaded(stack) || checkCooldown && player.method_7357().method_7904(stack));
        class_1799 stack2 = player.method_6030();
        if (predicate.test(stack2)) {
            return Pair.of((Object)stack2, (Object)player.method_6058());
        }
        for (class_1268 hand : class_1268.values()) {
            stack2 = player.method_5998(hand);
            if (!predicate.test(stack2)) continue;
            return Pair.of((Object)stack2, (Object)hand);
        }
        return Pair.of((Object)class_1799.field_8037, (Object)class_1268.field_5808);
    }

    public static boolean isValidCrossbow(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1764 && !stack.method_31573(CrossbowScopingTags.INCOMPATIBLE_ITEMS);
    }

    public static boolean isLoaded(class_1799 stack) {
        return CrossbowScoping.isLoaded(stack, false);
    }

    public static boolean isLoaded(class_1799 stack, boolean checkLoading) {
        if (!CrossbowScoping.isValidCrossbow(stack)) {
            return false;
        }
        if (checkLoading && stack.method_57826(CrossbowScopingDataComponentTypes.LOADING_PHASE)) {
            return false;
        }
        class_9278 chargedProjectilesComponent = (class_9278)stack.method_58694(class_9334.field_49649);
        return chargedProjectilesComponent != null && !chargedProjectilesComponent.method_57442();
    }

    public static boolean canInsertSpyglass(class_1799 crossbow, class_1799 potentialSpyglass) {
        return crossbow.method_31573(CrossbowScopingTags.INCOMPATIBLE_ITEMS) ? potentialSpyglass.method_7960() : potentialSpyglass.method_7960() || CrossbowScoping.isASpyglass(potentialSpyglass);
    }

    public static boolean isASpyglass(class_1799 potentialSpyglass) {
        return !potentialSpyglass.method_7960() && potentialSpyglass.method_7909() instanceof class_5538;
    }
}

