/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.classes;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.enums.ConfigurationStorage;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lme/mochibit/defcon/classes/PluginConfiguration;", "", "storage", "Lme/mochibit/defcon/enums/ConfigurationStorage;", "<init>", "(Lme/mochibit/defcon/enums/ConfigurationStorage;)V", "configDir", "Ljava/io/File;", "configFile", "configuration", "Lorg/bukkit/configuration/file/FileConfiguration;", "ensureDirectories", "", "reloadConfig", "saveConfig", "saveDefaultConfig", "config", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "Companion", "Defcon"})
public final class PluginConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurationStorage storage;
    @NotNull
    private final File configDir;
    @NotNull
    private final File configFile;
    @Nullable
    private FileConfiguration configuration;
    @NotNull
    private static final Map<ConfigurationStorage, PluginConfiguration> configurations = new LinkedHashMap();

    public PluginConfiguration(@NotNull ConfigurationStorage storage) {
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        this.storage = storage;
        this.configDir = new File(Defcon.Companion.getInstance().getDataFolder(), this.storage.getStoragePath());
        this.configFile = new File(this.configDir, this.storage.getStorageFileName() + ".yml");
        this.ensureDirectories();
        this.saveDefaultConfig();
        this.reloadConfig();
    }

    private final void ensureDirectories() {
        if (!this.configDir.exists() && !this.configDir.mkdirs()) {
            throw new IllegalStateException(("Could not create directory: " + this.configDir).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadConfig() {
        this.ensureDirectories();
        this.configuration = (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream inputStream = Defcon.Companion.getInstance().getResource(this.configFile.getName());
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
                Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(...)");
                YamlConfiguration ymlFile = yamlConfiguration;
                FileConfiguration fileConfiguration = this.configuration;
                Intrinsics.checkNotNull((Object)fileConfiguration, (String)"null cannot be cast to non-null type org.bukkit.configuration.file.YamlConfiguration");
                ((YamlConfiguration)fileConfiguration).setDefaults((Configuration)ymlFile);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public final void saveConfig() {
        try {
            FileConfiguration fileConfiguration = this.configuration;
            if (fileConfiguration != null) {
                fileConfiguration.save(this.configFile);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(("Could not save config to " + this.configFile + ": " + e.getMessage()).toString());
        }
    }

    private final void saveDefaultConfig() {
        if (this.configFile.exists()) {
            return;
        }
        try {
            Defcon.Companion.getInstance().saveResource(this.storage.getStoragePath() + this.storage.getStorageFileName() + ".yml", false);
        }
        catch (Exception e) {
            throw new IllegalStateException(("Error while saving default config! " + e.getMessage()).toString());
        }
    }

    @NotNull
    public final FileConfiguration getConfig() {
        if (this.configuration == null) {
            this.reloadConfig();
        }
        FileConfiguration fileConfiguration = this.configuration;
        Intrinsics.checkNotNull((Object)fileConfiguration);
        return fileConfiguration;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/mochibit/defcon/classes/PluginConfiguration$Companion;", "", "<init>", "()V", "configurations", "", "Lme/mochibit/defcon/enums/ConfigurationStorage;", "Lme/mochibit/defcon/classes/PluginConfiguration;", "initializeAll", "", "get", "storage", "saveAll", "reloadAll", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public final void initializeAll() {
            for (ConfigurationStorage storage : ConfigurationStorage.getEntries()) {
                configurations.put(storage, new PluginConfiguration(storage));
            }
        }

        @NotNull
        public final PluginConfiguration get(@NotNull ConfigurationStorage storage) {
            Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
            PluginConfiguration pluginConfiguration = (PluginConfiguration)configurations.get((Object)storage);
            if (pluginConfiguration == null) {
                pluginConfiguration = new PluginConfiguration(storage);
            }
            return pluginConfiguration;
        }

        public final void saveAll() {
            for (PluginConfiguration config : configurations.values()) {
                config.saveConfig();
            }
        }

        public final void reloadAll() {
            for (PluginConfiguration config : configurations.values()) {
                config.reloadConfig();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

