/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.commands.CommandInfo;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u0003\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u000eH\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lme/mochibit/defcon/commands/GenericCommand;", "", "<init>", "()V", "commandInfo", "Lme/mochibit/defcon/commands/CommandInfo;", "getCommandInfo", "()Lme/mochibit/defcon/commands/CommandInfo;", "getCommand", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "getArguments", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "checkPermissions", "", "context", "safeCommandExecution", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "commandLogic", "sendMessage", "", "sender", "Lorg/bukkit/command/CommandSender;", "message", "", "isError", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nGenericCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericCommand.kt\nme/mochibit/defcon/commands/GenericCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n808#2,11:140\n*S KotlinDebug\n*F\n+ 1 GenericCommand.kt\nme/mochibit/defcon/commands/GenericCommand\n*L\n44#1:140,11\n*E\n"})
public abstract class GenericCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandInfo commandInfo;
    @NotNull
    public static final String COMMAND_ROOT = "defcon";

    /*
     * WARNING - void declaration
     */
    public GenericCommand() {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Iterable iterable = Reflection.getOrCreateKotlinClass(this.getClass()).getAnnotations();
        GenericCommand genericCommand = this;
        boolean $i$f$filterIsInstance = false;
        void var3_4 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CommandInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CommandInfo commandInfo = (CommandInfo)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (commandInfo == null) {
            throw new IllegalStateException("Command class " + this.getClass().getSimpleName() + " is missing required @CommandInfo annotation");
        }
        genericCommand.commandInfo = commandInfo;
    }

    @NotNull
    public final CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        void var2_2;
        String string = this.commandInfo.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String commandName = string;
        LiteralArgumentBuilder commandNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).requires(this::checkPermissions)).executes(this::safeCommandExecution);
        boolean bl = false;
        ArgumentBuilder<CommandSourceStack, ?> arguments = this.getArguments();
        if (arguments != null) {
            commandNode.then(arguments);
        }
        void v1 = var2_2;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"let(...)");
        return v1;
    }

    @Nullable
    public ArgumentBuilder<CommandSourceStack, ?> getArguments() {
        return null;
    }

    public boolean checkPermissions(@NotNull CommandSourceStack context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Entity executor = context.getExecutor();
        if (this.commandInfo.requiresPlayer() && !(executor instanceof Player)) {
            return false;
        }
        if (((CharSequence)this.commandInfo.permission()).length() > 0) {
            Entity entity = executor;
            return entity != null ? entity.hasPermission(this.commandInfo.permission()) : false;
        }
        return true;
    }

    private final int safeCommandExecution(CommandContext<CommandSourceStack> ctx) {
        int n;
        try {
            n = this.commandLogic(ctx);
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<red>An error occurred while executing this command");
            n = 1;
        }
        return n;
    }

    public int commandLogic(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getSender(...)");
        GenericCommand.sendMessage$default(this, commandSender, this.commandInfo.description(), false, 4, null);
        return 1;
    }

    protected final void sendMessage(@NotNull CommandSender sender, @NotNull String message, boolean isError) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String prefix = isError ? "<gradient:#ED213A:#93291E> <bold> DEFCON \u2622</bold> </gradient>" : "<gradient:#a8ff78:#78ffd6> <bold> DEFCON \u2622</bold> </gradient>";
        sender.sendRichMessage(prefix + " " + message);
    }

    public static /* synthetic */ void sendMessage$default(GenericCommand genericCommand, CommandSender commandSender, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendMessage");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        genericCommand.sendMessage(commandSender, string, bl);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/mochibit/defcon/commands/GenericCommand$Companion;", "", "<init>", "()V", "COMMAND_ROOT", "", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

