/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.commands.definitions;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.commands.CommandInfo;
import me.mochibit.defcon.commands.GenericCommand;
import me.mochibit.defcon.explosions.types.Explosion;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;

@CommandInfo(name="explode", permission="defcon.admin", requiresPlayer=false)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R,\u0010\u0004\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/mochibit/defcon/commands/definitions/ExplodeCommand;", "Lme/mochibit/defcon/commands/GenericCommand;", "<init>", "()V", "explosionNamesSuggestion", "Lkotlin/Function2;", "Lcom/mojang/brigadier/context/CommandContext;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "getArguments", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "commandLogic", "", "ctx", "handleWithRaycast", "handleWithCoordinate", "createExplosion", "sender", "Lorg/bukkit/command/CommandSender;", "explosionName", "", "location", "Lorg/bukkit/Location;", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nExplodeCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplodeCommand.kt\nme/mochibit/defcon/commands/definitions/ExplodeCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1#2:174\n1#2:185\n1617#3,9:175\n1869#3:184\n1870#3:186\n1626#3:187\n1869#3,2:188\n774#3:190\n865#3,2:191\n1563#3:193\n1634#3,3:194\n*S KotlinDebug\n*F\n+ 1 ExplodeCommand.kt\nme/mochibit/defcon/commands/definitions/ExplodeCommand\n*L\n141#1:185\n141#1:175,9\n141#1:184\n141#1:186\n141#1:187\n67#1:188,2\n56#1:190\n56#1:191,2\n58#1:193\n58#1:194,3\n*E\n"})
public final class ExplodeCommand
extends GenericCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<CommandContext<CommandSourceStack>, SuggestionsBuilder, CompletableFuture<Suggestions>> explosionNamesSuggestion = ExplodeCommand::explosionNamesSuggestion$lambda$2;
    @NotNull
    private static final Lazy<List<KClass<? extends Explosion>>> explosionClasses$delegate = LazyKt.lazy(ExplodeCommand::explosionClasses_delegate$lambda$11);
    private static final double MAX_RAYCAST_DISTANCE = 500.0;

    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> getArguments() {
        ArgumentBuilder argumentBuilder = ((RequiredArgumentBuilder)Commands.argument((String)"explosionName", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests((arg_0, arg_1) -> ExplodeCommand.getArguments$lambda$3(this.explosionNamesSuggestion, arg_0, arg_1)).then(Commands.literal((String)"pos").then(Commands.argument((String)"coordinate", (ArgumentType)ArgumentTypes.blockPosition()).executes(this::handleWithCoordinate)))).then(Commands.literal((String)"raycast").executes(this::handleWithRaycast));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    @Override
    public int commandLogic(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return 1;
    }

    private final int handleWithRaycast(CommandContext<CommandSourceStack> ctx) {
        Block hitBlock;
        RayTraceResult raycastResult;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getSender(...)");
        CommandSender sender = commandSender;
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "This command can only be executed by a player.", true);
            return 1;
        }
        RayTraceResult rayTraceResult = raycastResult = ((Player)sender).getWorld().rayTraceBlocks(((Player)sender).getEyeLocation(), ((Player)sender).getLocation().getDirection(), 500.0, FluidCollisionMode.SOURCE_ONLY, false);
        Object object = hitBlock = rayTraceResult != null ? rayTraceResult.getHitBlock() : null;
        if (hitBlock == null) {
            this.sendMessage(sender, "No block found within range. Try looking at a block.", true);
            return 1;
        }
        String explosionName = StringArgumentType.getString(ctx, (String)"explosionName");
        Intrinsics.checkNotNull((Object)explosionName);
        Location location = hitBlock.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return this.createExplosion(sender, explosionName, location);
    }

    private final int handleWithCoordinate(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getSender(...)");
        CommandSender sender = commandSender;
        String explosionName = StringArgumentType.getString(ctx, (String)"explosionName");
        BlockPositionResolver blockPositionResolver = (BlockPositionResolver)ctx.getArgument("coordinate", BlockPositionResolver.class);
        Object object = blockPositionResolver.resolve((CommandSourceStack)ctx.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolve(...)");
        BlockPosition coordinate = (BlockPosition)object;
        Entity entity = ((CommandSourceStack)ctx.getSource()).getExecutor();
        if (entity == null || (entity = entity.getWorld()) == null) {
            ExplodeCommand $this$handleWithCoordinate_u24lambda_u244 = this;
            boolean bl = false;
            $this$handleWithCoordinate_u24lambda_u244.sendMessage(sender, "Could not determine world for explosion.", true);
            return 1;
        }
        Entity world = entity;
        Intrinsics.checkNotNull((Object)explosionName);
        Location location = coordinate.toLocation((World)world);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toLocation(...)");
        return this.createExplosion(sender, explosionName, location);
    }

    /*
     * WARNING - void declaration
     */
    private final int createExplosion(CommandSender sender, String explosionName, Location location) {
        Object v0;
        block11: {
            Iterable iterable = Companion.getExplosionClasses();
            for (Object t : iterable) {
                KClass it = (KClass)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)explosionName)) continue;
                v0 = t;
                break block11;
            }
            v0 = null;
        }
        KClass explosionClass = v0;
        if (explosionClass == null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = Companion.getExplosionClasses();
            String string = explosionName;
            CommandSender commandSender = sender;
            ExplodeCommand explodeCommand = this;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KClass it = (KClass)element$iv$iv;
                boolean bl2 = false;
                if (it.getSimpleName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            explodeCommand.sendMessage(commandSender, "Unknown explosion type: " + string + ". Available types: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null), true);
            return 1;
        }
        try {
            Object object;
            block14: {
                block13: {
                    Object v2;
                    block12: {
                        object = KClasses.getPrimaryConstructor((KClass)explosionClass);
                        if (object == null || (object = object.getParameters()) == null) break block13;
                        Iterable iterable = (Iterable)object;
                        for (Object t : iterable) {
                            KParameter it = (KParameter)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"center")) continue;
                            v2 = t;
                            break block12;
                        }
                        v2 = null;
                    }
                    if ((object = (KParameter)v2) != null) break block14;
                }
                throw new IllegalStateException("No center parameter found for explosion class " + explosionName);
            }
            Object centerParam = object;
            Map params = MapsKt.mapOf((Pair)TuplesKt.to((Object)centerParam, (Object)location));
            Object object2 = KClasses.getPrimaryConstructor((KClass)explosionClass);
            if (object2 == null || (object2 = (Explosion)object2.callBy(params)) == null) {
                throw new IllegalStateException("Could not instantiate explosion of type " + explosionName);
            }
            Object explosionInstance = object2;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Defcon.Companion.getInstance(), () -> ExplodeCommand.createExplosion$lambda$8((Explosion)explosionInstance));
            this.sendMessage(sender, "Created explosion of type " + explosionName + " at " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ(), false);
            return 1;
        }
        catch (Exception e) {
            this.sendMessage(sender, "Failed to create explosion: " + e.getMessage(), true);
            e.printStackTrace();
            return 0;
        }
    }

    private static final CompletableFuture explosionNamesSuggestion$lambda$2(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterable $this$forEach$iv = Companion.getExplosionClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            KClass explosionClass = (KClass)element$iv;
            boolean bl = false;
            if (explosionClass.getSimpleName() == null) continue;
            boolean bl2 = false;
            builder.suggest(it);
        }
        return builder.buildFuture();
    }

    private static final CompletableFuture getArguments$lambda$3(Function2 $tmp0, CommandContext p0, SuggestionsBuilder p1) {
        return (CompletableFuture)$tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void createExplosion$lambda$8(Explosion $explosionInstance) {
        $explosionInstance.explode();
    }

    /*
     * WARNING - void declaration
     */
    private static final List explosionClasses_delegate$lambda$11() {
        void var3_3;
        void $this$mapTo$iv$iv;
        KClass subclass;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = Reflection.getOrCreateKotlinClass(Explosion.class).getSealedSubclasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            subclass = (KClass)element$iv$iv;
            boolean bl = false;
            if (!Explosion.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)subclass))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            subclass = (KClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        return (List)var3_3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R)\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/mochibit/defcon/commands/definitions/ExplodeCommand$Companion;", "", "<init>", "()V", "explosionClasses", "", "Lkotlin/reflect/KClass;", "Lme/mochibit/defcon/explosions/types/Explosion;", "getExplosionClasses", "()Ljava/util/List;", "explosionClasses$delegate", "Lkotlin/Lazy;", "MAX_RAYCAST_DISTANCE", "", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<? extends Explosion>> getExplosionClasses() {
            Lazy lazy = explosionClasses$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

