/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.effects.nuclear;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import me.mochibit.defcon.effects.AnimatedEffect;
import me.mochibit.defcon.effects.ParticleComponent;
import me.mochibit.defcon.effects.TemperatureComponent;
import me.mochibit.defcon.explosions.ExplosionComponent;
import me.mochibit.defcon.particles.emitter.CylinderShape;
import me.mochibit.defcon.particles.emitter.EmitterShape;
import me.mochibit.defcon.particles.emitter.ParticleEmitter;
import me.mochibit.defcon.particles.emitter.SphereShape;
import me.mochibit.defcon.particles.emitter.SphereSurfaceShape;
import me.mochibit.defcon.particles.templates.definition.ExplosionDustParticle;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/mochibit/defcon/effects/nuclear/NuclearExplosionVFX;", "Lme/mochibit/defcon/effects/AnimatedEffect;", "nuclearComponent", "Lme/mochibit/defcon/explosions/ExplosionComponent;", "center", "Lorg/bukkit/Location;", "<init>", "(Lme/mochibit/defcon/explosions/ExplosionComponent;Lorg/bukkit/Location;)V", "getCenter", "()Lorg/bukkit/Location;", "maxHeight", "", "currentHeight", "", "riseSpeed", "coreCloud", "Lme/mochibit/defcon/effects/ParticleComponent;", "secondaryCloud", "tertiaryCloud", "quaterniaryCloud", "coreNeck", "neckCone", "stem", "stemShape", "Lme/mochibit/defcon/particles/emitter/CylinderShape;", "neckConeShape", "Lme/mochibit/defcon/particles/emitter/SphereShape;", "animate", "", "delta", "processRise", "Defcon"})
public final class NuclearExplosionVFX
extends AnimatedEffect {
    @NotNull
    private final ExplosionComponent nuclearComponent;
    @NotNull
    private final Location center;
    private final double maxHeight;
    private float currentHeight;
    private float riseSpeed;
    @NotNull
    private final ParticleComponent coreCloud;
    @NotNull
    private final ParticleComponent secondaryCloud;
    @NotNull
    private final ParticleComponent tertiaryCloud;
    @NotNull
    private final ParticleComponent quaterniaryCloud;
    @NotNull
    private final ParticleComponent coreNeck;
    @NotNull
    private final ParticleComponent neckCone;
    @NotNull
    private final ParticleComponent stem;
    @NotNull
    private final CylinderShape stemShape;
    @NotNull
    private final SphereShape neckConeShape;

    /*
     * WARNING - void declaration
     */
    public NuclearExplosionVFX(@NotNull ExplosionComponent nuclearComponent, @NotNull Location center) {
        void $this$neckCone_u24lambda_u240;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)nuclearComponent, (String)"nuclearComponent");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        super(3600, null, 2, null);
        this.nuclearComponent = nuclearComponent;
        this.center = center;
        this.maxHeight = 250.0;
        this.riseSpeed = 5.0f;
        this.coreCloud = ParticleComponent.addSpawnableParticle$default(new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new SphereShape(30.0f, 50.0f, 0.0, 0.0, 0.0, 0.0, null, null, 252, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 35.0, 15, null)), new ExplosionDustParticle().scale(new Vector3f(30.0f, 30.0f, 30.0f)).velocity(new Vector3f(0.0f, 1.0f, 0.0f)), false, 2, null);
        this.secondaryCloud = ParticleComponent.addSpawnableParticle$default(new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new SphereSurfaceShape(50.0f, 50.0f, 0.0, 0.0, 0.0, 0.0, false, null, null, 508, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 105.0, 15, null)), new ExplosionDustParticle().scale(new Vector3f(45.0f, 45.0f, 45.0f)).velocity(new Vector3f(0.0f, 0.8f, 0.0f)), false, 2, null);
        this.tertiaryCloud = new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new SphereSurfaceShape(70.0f, 70.0f, 0.0, 0.0, 0.0, 0.0, false, null, null, 508, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 200.0, 15, null)).addSpawnableParticle(new ExplosionDustParticle().scale(new Vector3f(50.0f, 50.0f, 50.0f)).velocity(new Vector3f(0.0f, 0.6f, 0.0f)), true);
        this.quaterniaryCloud = new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new SphereSurfaceShape(90.0f, 60.0f, 0.0, 0.0, 0.0, 0.0, false, null, null, 508, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 300.0, 15, null)).addSpawnableParticle(new ExplosionDustParticle().scale(new Vector3f(55.0f, 55.0f, 55.0f)).velocity(new Vector3f(0.0f, -1.0f, 0.0f)), true).translate(new Vector3f(0.0f, -5.0f, 0.0f));
        this.coreNeck = ParticleComponent.addSpawnableParticle$default(new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new CylinderShape(30.0f, 30.0f, 60.0f, 0.0, 0.0, 0.0, 0.0, null, 248, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 40.0, 15, null)), new ExplosionDustParticle().velocity(new Vector3f(0.0f, -1.2f, 0.0f)), false, 2, null).translate(new Vector3f(0.0f, -30.0f, 0.0f));
        Object[] objectArray2 = objectArray = ParticleComponent.addSpawnableParticle$default(new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new SphereShape(40.0f, 70.0f, -15.0, 0.0, 0.0, 0.0, null, null, 248, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 100.0, 15, null)), new ExplosionDustParticle().velocity(new Vector3f(0.0f, -1.2f, 0.0f)), false, 2, null);
        NuclearExplosionVFX nuclearExplosionVFX = this;
        boolean bl = false;
        $this$neckCone_u24lambda_u240.setVisible(false);
        nuclearExplosionVFX.neckCone = objectArray.translate(new Vector3f(0.0f, -90.0f, 0.0f)).setVisibilityAfterDelay-HG0u8IE(true, DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)).applyRadialVelocityFromCenter(new Vector3f(5.0f, 0.0f, 5.0f));
        this.stem = ParticleComponent.addSpawnableParticle$default(new ParticleComponent(new ParticleEmitter(this.center, 8000.0, 0, new CylinderShape(15.0f, 15.0f, 1.0f, 0.0, 0.0, 0.0, 0.0, null, 248, null), null, null, null, 116, null), new TemperatureComponent(0.0, 0.0, 0.0, 0.0, 140.0, 15, null)), new ExplosionDustParticle().scale(new Vector3f(40.0f, 40.0f, 40.0f)).velocity(new Vector3f(0.0f, 1.0f, 0.0f)), false, 2, null);
        EmitterShape emitterShape = this.stem.getShape();
        Intrinsics.checkNotNull((Object)emitterShape, (String)"null cannot be cast to non-null type me.mochibit.defcon.particles.emitter.CylinderShape");
        this.stemShape = (CylinderShape)emitterShape;
        EmitterShape emitterShape2 = this.neckCone.getShape();
        Intrinsics.checkNotNull((Object)emitterShape2, (String)"null cannot be cast to non-null type me.mochibit.defcon.particles.emitter.SphereShape");
        this.neckConeShape = (SphereShape)emitterShape2;
        objectArray = new ParticleComponent[]{this.coreCloud, this.coreNeck, this.secondaryCloud, this.tertiaryCloud, this.quaterniaryCloud, this.neckCone, this.stem};
        this.getEffectComponents().addAll(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final Location getCenter() {
        return this.center;
    }

    @Override
    public void animate(float delta) {
        this.processRise(delta);
    }

    private final void processRise(float delta) {
        if ((double)this.currentHeight > this.maxHeight) {
            return;
        }
        float deltaMovement = this.riseSpeed * delta;
        Vector3f movementVector = new Vector3f(0.0f, deltaMovement, 0.0f);
        this.coreCloud.translate(movementVector);
        this.coreNeck.translate(movementVector);
        this.secondaryCloud.translate(movementVector);
        this.tertiaryCloud.translate(movementVector);
        this.quaterniaryCloud.translate(movementVector);
        this.neckCone.translate(movementVector);
        this.currentHeight += deltaMovement;
        if (this.neckCone.getVisible()) {
            SphereShape sphereShape = this.neckConeShape;
            sphereShape.setMaxY(sphereShape.getMaxY() + (double)(deltaMovement / (float)5));
        }
        this.stemShape.setHeight(this.currentHeight - (float)70);
    }
}

