/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.explosions.effects;

import com.github.shynixn.mccoroutine.bukkit.MCCoroutineKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.explosions.effects.BlindFlashEffect;
import me.mochibit.defcon.explosions.effects.ClientSideTextDisplay;
import me.mochibit.defcon.explosions.processor.RaycastedEffector;
import me.mochibit.defcon.threading.scheduling.SchedulingUtilsKt;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u00019B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0094@\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020*H\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0018\u00101\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u00020\u000bH\u0002J \u00103\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u00104\u001a\u0002052\u0006\u00102\u001a\u00020\u000bH\u0002J \u00106\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u00104\u001a\u0002052\u0006\u00102\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020%H\u0014J\b\u00108\u001a\u00020\u001dH\u0016R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lme/mochibit/defcon/explosions/effects/BlindFlashEffect;", "Lme/mochibit/defcon/explosions/processor/RaycastedEffector;", "Lorg/bukkit/event/Listener;", "center", "Lorg/bukkit/Location;", "reach", "", "raycastHeight", "duration", "Lkotlin/time/Duration;", "skyVisibilityRequired", "", "<init>", "(Lorg/bukkit/Location;IIJFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "playerDisplays", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ljava/util/EnumMap;", "Lme/mochibit/defcon/explosions/effects/BlindFlashEffect$CubeFace;", "Lme/mochibit/defcon/explosions/effects/ClientSideTextDisplay;", "textureScale", "Lorg/joml/Vector3f;", "cubeSize", "transforms", "", "Lorg/joml/Matrix4f;", "isListenerRegistered", "", "initializeTransforms", "", "onPlayerQuit", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "cleanupDisplays", "playerUUID", "getTargetEntities", "", "Lorg/bukkit/entity/Entity;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyEffect", "entity", "effectType", "Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;", "createEffectTask", "Ljava/io/Closeable;", "player", "Lorg/bukkit/entity/Player;", "initialEffectType", "cleanupDisplaysIfExists", "updateCubeDisplayEffect", "fadeFactor", "updateMidRangeEffect", "distanceSquared", "", "updateFarRangeEffect", "cleanup", "stop", "CubeFace", "Defcon"})
@SourceDebugExtension(value={"SMAP\nBlindFlashEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlindFlashEffect.kt\nme/mochibit/defcon/explosions/effects/BlindFlashEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1869#2,2:454\n774#2:456\n865#2,2:457\n1869#2,2:459\n1869#2,2:462\n1#3:461\n*S KotlinDebug\n*F\n+ 1 BlindFlashEffect.kt\nme/mochibit/defcon/explosions/effects/BlindFlashEffect\n*L\n135#1:454,2\n149#1:456\n149#1:457,2\n283#1:459,2\n442#1:462,2\n*E\n"})
public final class BlindFlashEffect
extends RaycastedEffector
implements Listener {
    @NotNull
    private final ConcurrentHashMap<UUID, EnumMap<CubeFace, ClientSideTextDisplay>> playerDisplays;
    @NotNull
    private final Vector3f textureScale;
    private final float cubeSize;
    @NotNull
    private final Map<CubeFace, Matrix4f> transforms;
    private boolean isListenerRegistered;

    private BlindFlashEffect(Location center, int reach, int raycastHeight, long duration, float skyVisibilityRequired) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        super(center, reach, raycastHeight, duration, skyVisibilityRequired, null);
        this.playerDisplays = new ConcurrentHashMap();
        this.textureScale = new Vector3f(8.0f, 4.0f, 1.0f);
        this.cubeSize = 50.0f;
        this.transforms = new LinkedHashMap();
        this.initializeTransforms();
        Defcon.Companion.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Defcon.Companion.getInstance());
        this.isListenerRegistered = true;
    }

    public /* synthetic */ BlindFlashEffect(Location location, int n, int n2, long l, float f, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        if ((n3 & 0x10) != 0) {
            f = 0.3f;
        }
        this(location, n, n2, l, f, null);
    }

    private final void initializeTransforms() {
        this.transforms.put(CubeFace.BACK, new Matrix4f().rotate((Quaternionfc)new Quaternionf()).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale((Vector3fc)this.textureScale));
        this.transforms.put(CubeFace.RIGHT, new Matrix4f().rotate((Quaternionfc)new Quaternionf().rotateY(1.5707964f)).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale(this.textureScale.x, this.textureScale.y, this.textureScale.x * this.cubeSize));
        this.transforms.put(CubeFace.FRONT, new Matrix4f().rotate((Quaternionfc)new Quaternionf().rotateY((float)Math.PI)).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale(this.textureScale.x, this.textureScale.y, this.textureScale.x));
        this.transforms.put(CubeFace.LEFT, new Matrix4f().rotate((Quaternionfc)new Quaternionf().rotateY(4.712389f)).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale(this.textureScale.x, this.textureScale.y, this.textureScale.x * this.cubeSize));
        this.transforms.put(CubeFace.TOP, new Matrix4f().rotate((Quaternionfc)new Quaternionf().rotateX(1.5707964f)).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale(this.textureScale.x, this.textureScale.y, this.textureScale.y * this.cubeSize));
        this.transforms.put(CubeFace.BOTTOM, new Matrix4f().rotate((Quaternionfc)new Quaternionf().rotateX(-1.5707964f)).scale(this.cubeSize, this.cubeSize, 1.0f).translate(-0.5f, -0.5f, -this.cubeSize / (float)2).translate(0.4f, 0.0f, 0.0f).scale(this.textureScale.x, this.textureScale.y, this.textureScale.y * this.cubeSize));
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        this.cleanupDisplays(uUID);
    }

    private final void cleanupDisplays(UUID playerUUID) {
        block3: {
            EnumMap<CubeFace, ClientSideTextDisplay> displays = this.playerDisplays.remove(playerUUID);
            EnumMap<CubeFace, ClientSideTextDisplay> enumMap = displays;
            if (enumMap == null || (enumMap = enumMap.values()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)((Object)enumMap);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClientSideTextDisplay it = (ClientSideTextDisplay)element$iv;
                boolean bl = false;
                try {
                    it.remove();
                }
                catch (Exception e) {
                    Defcon.Companion.getInstance().getLogger().warning("Error removing display for player " + playerUUID + ": " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Object getTargetEntities(@NotNull Continuation<? super List<? extends Entity>> $completion) {
        void $this$filterTo$iv$iv;
        List list = this.getWorld().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player player = (Player)element$iv$iv;
            boolean bl = false;
            if (!(player.getLocation().distanceSquared(this.getCenter()) <= (double)this.getReachSquared())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void applyEffect(@NotNull Entity entity, @NotNull RaycastedEffector.EffectType effectType) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)effectType), (String)"effectType");
        if (!(entity instanceof Player)) {
            return;
        }
        if (this.getAffectedEntities().containsKey(((Player)entity).getUniqueId())) {
            return;
        }
        if (!((Player)entity).hasPotionEffect(PotionEffectType.NIGHT_VISION)) {
            MCCoroutineKt.launch$default((Plugin)((Plugin)Defcon.Companion.getInstance()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(effectType, entity, this, null){
                int label;
                final /* synthetic */ RaycastedEffector.EffectType $effectType;
                final /* synthetic */ Entity $entity;
                final /* synthetic */ BlindFlashEffect this$0;
                {
                    this.$effectType = $effectType;
                    this.$entity = $entity;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            int amplifier = switch (applyEffect.WhenMappings.$EnumSwitchMapping$0[this.$effectType.ordinal()]) {
                                case 1 -> 255;
                                case 2 -> 200;
                                case 3 -> 150;
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            ((Player)this.$entity).addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, (int)me.mochibit.defcon.extensions.DurationKt.toTicks-LRDsOJo(BlindFlashEffect.access$getDuration-UwyO8pc(this.this$0)), amplifier));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        Closeable effectTask = this.createEffectTask((Player)entity, effectType);
        RaycastedEffector.EffectorData effectData = new RaycastedEffector.EffectorData(effectTask, System.currentTimeMillis(), Duration.getInWholeMilliseconds-impl((long)this.getDuration-UwyO8pc()), effectType);
        ((Map)this.getAffectedEntities()).put(((Player)entity).getUniqueId(), effectData);
    }

    private final Closeable createEffectTask(Player player, RaycastedEffector.EffectType initialEffectType) {
        return SchedulingUtilsKt.intervalAsync-NqJ4yvY$default(DurationKt.toDuration((int)50, (DurationUnit)DurationUnit.MILLISECONDS), 0L, (Function1)new Function1<Continuation<? super Unit>, Object>(player, this, null){
            int label;
            final /* synthetic */ Player $player;
            final /* synthetic */ BlindFlashEffect this$0;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        float smoothFadeFactor;
                        ResultKt.throwOnFailure((Object)object);
                        if (!this.$player.isOnline() || !Intrinsics.areEqual((Object)this.$player.getWorld(), (Object)BlindFlashEffect.access$getWorld(this.this$0))) {
                            this.this$0.cleanup((Entity)this.$player);
                            return Unit.INSTANCE;
                        }
                        UUID uUID = this.$player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                        UUID playerUUID = uUID;
                        RaycastedEffector.EffectorData effectorData = (RaycastedEffector.EffectorData)BlindFlashEffect.access$getAffectedEntities(this.this$0).get(playerUUID);
                        if (effectorData == null) {
                            return Unit.INSTANCE;
                        }
                        RaycastedEffector.EffectorData effectData = effectorData;
                        long elapsed = System.currentTimeMillis() - effectData.getStartTime();
                        double progressFactor = (double)elapsed / (double)effectData.getEffectDuration();
                        if (progressFactor >= 1.0 || !BlindFlashEffect.access$hasLineOfSightToSource(this.this$0, (Entity)this.$player)) {
                            this.this$0.cleanup((Entity)this.$player);
                            return Unit.INSTANCE;
                        }
                        float fadeFactor = (float)(1.0 - progressFactor);
                        if (progressFactor > 0.7) {
                            double normalizedProgress = (progressFactor - 0.7) / 0.3;
                            v2 = (float)(1.0 - normalizedProgress * normalizedProgress * normalizedProgress) * 0.3f;
                        } else {
                            v2 = smoothFadeFactor = fadeFactor;
                        }
                        if ((double)smoothFadeFactor < 0.05) {
                            this.this$0.cleanup((Entity)this.$player);
                            return Unit.INSTANCE;
                        }
                        double distanceSquared = this.$player.getLocation().distanceSquared(BlindFlashEffect.access$getCenter(this.this$0));
                        RaycastedEffector.EffectType currentEffectType = BlindFlashEffect.access$determineEffectType(this.this$0, distanceSquared);
                        if (currentEffectType != effectData.getCurrentEffectType()) {
                            effectData.setCurrentEffectType(currentEffectType);
                        }
                        try {
                            RaycastedEffector.EffectType effectType = currentEffectType;
                            switch (createEffectTask.WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                                case 1: {
                                    BlindFlashEffect.access$updateCubeDisplayEffect(this.this$0, this.$player, smoothFadeFactor);
                                    break;
                                }
                                case 2: {
                                    BlindFlashEffect.access$cleanupDisplaysIfExists(this.this$0, playerUUID);
                                    BlindFlashEffect.access$updateMidRangeEffect(this.this$0, this.$player, distanceSquared, smoothFadeFactor);
                                    break;
                                }
                                case 3: {
                                    BlindFlashEffect.access$cleanupDisplaysIfExists(this.this$0, playerUUID);
                                    if (BlindFlashEffect.access$isPlayerInOpenAir(this.this$0, this.$player)) {
                                        BlindFlashEffect.access$updateFarRangeEffect(this.this$0, this.$player, distanceSquared, smoothFadeFactor);
                                    }
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                        catch (Exception e) {
                            Defcon.Companion.getInstance().getLogger().warning("Error updating flash effect: " + e.getMessage());
                            this.this$0.cleanup((Entity)this.$player);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void cleanupDisplaysIfExists(UUID playerUUID) {
        EnumMap<CubeFace, ClientSideTextDisplay> displays = this.playerDisplays.get(playerUUID);
        if (displays != null) {
            Collection<ClientSideTextDisplay> collection = displays.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClientSideTextDisplay it = (ClientSideTextDisplay)element$iv;
                boolean bl = false;
                it.remove();
            }
            this.playerDisplays.remove(playerUUID);
        }
    }

    private final void updateCubeDisplayEffect(Player player, float fadeFactor) {
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID playerUUID = uUID;
        EnumMap enumMap = this.playerDisplays.computeIfAbsent(playerUUID, arg_0 -> BlindFlashEffect.updateCubeDisplayEffect$lambda$4(BlindFlashEffect::updateCubeDisplayEffect$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"computeIfAbsent(...)");
        EnumMap displays = enumMap;
        if (displays.isEmpty()) {
            for (CubeFace face : CubeFace.getEntries()) {
                ClientSideTextDisplay textDisplay = new ClientSideTextDisplay(player);
                ((Map)displays).put(face, textDisplay);
                textDisplay.setBillboard(Display.Billboard.FIXED);
                textDisplay.setInterpolationDuration(5);
                textDisplay.summon();
                if (this.transforms.get((Object)face) != null) {
                    Matrix4f it;
                    boolean bl = false;
                    textDisplay.applyTransform(it);
                }
            }
        }
        int opacityValue = RangesKt.coerceIn((int)((int)((float)255 * fadeFactor)), (int)0, (int)255);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location eyeLoc = location;
        for (CubeFace face : CubeFace.getEntries()) {
            ClientSideTextDisplay display;
            if ((ClientSideTextDisplay)displays.get((Object)face) == null) continue;
            display.teleport(eyeLoc);
            display.setOpacity(opacityValue);
        }
    }

    private final void updateMidRangeEffect(Player player, double distanceSquared, float fadeFactor) {
        if ((double)fadeFactor < 0.05) {
            return;
        }
        double distanceFactor = 1.0 - RangesKt.coerceIn((double)((distanceSquared - (double)this.getCloseRangeThresholdSquared()) / (double)(this.getFarRangeThresholdSquared() - this.getCloseRangeThresholdSquared())), (double)0.0, (double)1.0);
        double distanceToCenter = Math.sqrt(distanceSquared);
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        Location eyeLocation = location;
        Vector vector = this.getCenter().clone().subtract(eyeLocation).toVector().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"normalize(...)");
        Vector directionToExplosion = vector;
        double perspectiveDistance = 2.0 + distanceToCenter / (double)this.getReach() * 6.0;
        Location location2 = eyeLocation.clone().add(directionToExplosion.multiply(perspectiveDistance));
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        Location particleLocation = location2;
        int baseParticleCount = RangesKt.coerceAtLeast((int)((int)((double)50 * distanceFactor)), (int)8);
        int adjustedParticleCount = RangesKt.coerceAtLeast((int)((int)((float)baseParticleCount * fadeFactor)), (int)1);
        double particleSpread = RangesKt.coerceAtMost((double)(0.2 + distanceFactor * 0.6), (double)0.9);
        player.spawnParticle(Particle.FLASH, particleLocation, adjustedParticleCount, particleSpread * 0.3, particleSpread * 0.3, particleSpread * 0.3, 0.0);
    }

    private final void updateFarRangeEffect(Player player, double distanceSquared, float fadeFactor) {
        double distanceFactor = 1.0 - RangesKt.coerceIn((double)((distanceSquared - (double)this.getFarRangeThresholdSquared()) / (double)(this.getReachSquared() - this.getFarRangeThresholdSquared())), (double)0.0, (double)1.0);
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        Location eyeLocation = location;
        Vector vector = this.getCenter().clone().subtract(eyeLocation).toVector().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"normalize(...)");
        Vector directionToExplosion = vector;
        double horizonDistance = 15.0 + (1.0 - distanceFactor) * 10.0;
        Location location2 = eyeLocation.clone().add(directionToExplosion.multiply(horizonDistance));
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        Location particleLocation = location2;
        int particleCount = RangesKt.coerceAtLeast((int)((int)((double)5 * distanceFactor * (double)fadeFactor)), (int)1);
        double spreadFactor = 1.0 - distanceFactor;
        particleLocation.setY(particleLocation.getY() + horizonDistance * 0.1);
        player.spawnParticle(Particle.FLASH, particleLocation, particleCount, 1.0 + spreadFactor, 0.5, 1.0 + spreadFactor, 0.0);
        if ((double)fadeFactor > 0.3) {
            long l = player.getWorld().getTime();
            boolean bl = 13000L <= l ? l < 23001L : false;
            if (bl) {
                player.spawnParticle(Particle.END_ROD, particleLocation, 1, 0.1, 0.1, 0.1, 0.02);
            }
        }
    }

    @Override
    protected void cleanup(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player) {
            UUID uUID = ((Player)entity).getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.cleanupDisplays(uUID);
        }
        super.cleanup(entity);
    }

    @Override
    public void stop() {
        super.stop();
        Set set = this.playerDisplays.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerUUID = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)playerUUID);
            this.cleanupDisplays(playerUUID);
        }
        this.playerDisplays.clear();
        if (this.isListenerRegistered) {
            HandlerList.unregisterAll((Listener)this);
            this.isListenerRegistered = false;
        }
    }

    private static final EnumMap updateCubeDisplayEffect$lambda$3(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EnumMap(CubeFace.class);
    }

    private static final EnumMap updateCubeDisplayEffect$lambda$4(Function1 $tmp0, Object p0) {
        return (EnumMap)$tmp0.invoke(p0);
    }

    public /* synthetic */ BlindFlashEffect(Location center, int reach, int raycastHeight, long duration, float skyVisibilityRequired, DefaultConstructorMarker $constructor_marker) {
        this(center, reach, raycastHeight, duration, skyVisibilityRequired);
    }

    public static final /* synthetic */ long access$getDuration-UwyO8pc(BlindFlashEffect $this) {
        return $this.getDuration-UwyO8pc();
    }

    public static final /* synthetic */ World access$getWorld(BlindFlashEffect $this) {
        return $this.getWorld();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getAffectedEntities(BlindFlashEffect $this) {
        return $this.getAffectedEntities();
    }

    public static final /* synthetic */ boolean access$hasLineOfSightToSource(BlindFlashEffect $this, Entity entity) {
        return $this.hasLineOfSightToSource(entity);
    }

    public static final /* synthetic */ Location access$getCenter(BlindFlashEffect $this) {
        return $this.getCenter();
    }

    public static final /* synthetic */ RaycastedEffector.EffectType access$determineEffectType(BlindFlashEffect $this, double distanceSquared) {
        return $this.determineEffectType(distanceSquared);
    }

    public static final /* synthetic */ void access$updateCubeDisplayEffect(BlindFlashEffect $this, Player player, float fadeFactor) {
        $this.updateCubeDisplayEffect(player, fadeFactor);
    }

    public static final /* synthetic */ void access$cleanupDisplaysIfExists(BlindFlashEffect $this, UUID playerUUID) {
        $this.cleanupDisplaysIfExists(playerUUID);
    }

    public static final /* synthetic */ void access$updateMidRangeEffect(BlindFlashEffect $this, Player player, double distanceSquared, float fadeFactor) {
        $this.updateMidRangeEffect(player, distanceSquared, fadeFactor);
    }

    public static final /* synthetic */ boolean access$isPlayerInOpenAir(BlindFlashEffect $this, Player player) {
        return $this.isPlayerInOpenAir(player);
    }

    public static final /* synthetic */ void access$updateFarRangeEffect(BlindFlashEffect $this, Player player, double distanceSquared, float fadeFactor) {
        $this.updateFarRangeEffect(player, distanceSquared, fadeFactor);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lme/mochibit/defcon/explosions/effects/BlindFlashEffect$CubeFace;", "", "<init>", "(Ljava/lang/String;I)V", "FRONT", "RIGHT", "BACK", "LEFT", "TOP", "BOTTOM", "Defcon"})
    private static final class CubeFace
    extends Enum<CubeFace> {
        public static final /* enum */ CubeFace FRONT = new CubeFace();
        public static final /* enum */ CubeFace RIGHT = new CubeFace();
        public static final /* enum */ CubeFace BACK = new CubeFace();
        public static final /* enum */ CubeFace LEFT = new CubeFace();
        public static final /* enum */ CubeFace TOP = new CubeFace();
        public static final /* enum */ CubeFace BOTTOM = new CubeFace();
        private static final /* synthetic */ CubeFace[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CubeFace[] values() {
            return (CubeFace[])$VALUES.clone();
        }

        public static CubeFace valueOf(String value) {
            return Enum.valueOf(CubeFace.class, value);
        }

        @NotNull
        public static EnumEntries<CubeFace> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cubeFaceArray = new CubeFace[]{CubeFace.FRONT, CubeFace.RIGHT, CubeFace.BACK, CubeFace.LEFT, CubeFace.TOP, CubeFace.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

