/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.listeners.packet.biome;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.github.retrooper.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChunkData;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.biomes.CustomBiomeHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lme/mochibit/defcon/listeners/packet/biome/ClientSideBiome;", "Lcom/github/retrooper/packetevents/event/PacketListener;", "<init>", "()V", "onPacketSend", "", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "Defcon"})
@SourceDebugExtension(value={"SMAP\nClientSideBiome.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSideBiome.kt\nme/mochibit/defcon/listeners/packet/biome/ClientSideBiome\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1999#2,14:102\n*S KotlinDebug\n*F\n+ 1 ClientSideBiome.kt\nme/mochibit/defcon/listeners/packet/biome/ClientSideBiome\n*L\n40#1:102,14\n*E\n"})
public final class ClientSideBiome
implements PacketListener {
    public void onPacketSend(@NotNull PacketSendEvent event) {
        MappedEntity v$iv2;
        int chunkZ;
        Object e$iv;
        Object v1;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getPacketType() != PacketType.Play.Server.CHUNK_DATA) {
            return;
        }
        User user = event.getUser();
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        Set<CustomBiomeHandler.CustomBiomeBoundary> playerBiomes = CustomBiomeHandler.INSTANCE.getPlayerVisibleBiomes(uUID);
        if (playerBiomes.isEmpty()) {
            return;
        }
        Iterable $this$maxByOrNull$iv = playerBiomes;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                CustomBiomeHandler.CustomBiomeBoundary it = (CustomBiomeHandler.CustomBiomeBoundary)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPriority();
                do {
                    e$iv = iterator$iv.next();
                    CustomBiomeHandler.CustomBiomeBoundary it2 = (CustomBiomeHandler.CustomBiomeBoundary)e$iv;
                    $i$a$-maxByOrNull-ClientSideBiome$onPacketSend$biomeBoundary$1 = false;
                    int v$iv2 = it2.getPriority();
                    if (maxValue$iv >= v$iv2) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv2;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        CustomBiomeHandler.CustomBiomeBoundary customBiomeBoundary = v1;
        if (customBiomeBoundary == null) {
            return;
        }
        CustomBiomeHandler.CustomBiomeBoundary biomeBoundary = customBiomeBoundary;
        WrapperPlayServerChunkData chunkData = new WrapperPlayServerChunkData(event);
        int chunkX = chunkData.getColumn().getX();
        if (!biomeBoundary.intersectsChunk(chunkX, chunkZ = chunkData.getColumn().getZ())) {
            return;
        }
        int chunkMinX = chunkX * 16;
        int chunkMinZ = chunkZ * 16;
        e$iv = user.getRegistry(ResourceLocation.minecraft((String)"worldgen/biome"));
        if (e$iv == null || (v$iv2 = e$iv.getByName(biomeBoundary.getBiome().toString())) == null) {
            return;
        }
        MappedEntity element = v$iv2;
        int biomeId = element.getId(user.getClientVersion());
        int minSection = user.getMinWorldHeight() / 16;
        BaseChunk[] baseChunkArray = chunkData.getColumn().getChunks();
        Intrinsics.checkNotNullExpressionValue((Object)baseChunkArray, (String)"getChunks(...)");
        BaseChunk[] baseChunkArray2 = baseChunkArray;
        int n = baseChunkArray2.length;
        for (int i = 0; i < n; ++i) {
            int sectionY;
            int sectionMinY;
            int sectionMaxY;
            int sectionIndex = i;
            BaseChunk chunk = baseChunkArray2[i];
            if (!(chunk instanceof Chunk_v1_18) || (sectionMaxY = (sectionMinY = (sectionY = minSection + sectionIndex) * 16) + 15) < biomeBoundary.getMinY() || sectionMinY > biomeBoundary.getMaxY()) continue;
            for (int x = 0; x < 4; ++x) {
                int worldX = chunkMinX + x * 4;
                if (worldX + 3 < biomeBoundary.getMinX() || worldX > biomeBoundary.getMaxX()) continue;
                for (int z = 0; z < 4; ++z) {
                    int worldZ = chunkMinZ + z * 4;
                    if (worldZ + 3 < biomeBoundary.getMinZ() || worldZ > biomeBoundary.getMaxZ()) continue;
                    for (int y = 0; y < 4; ++y) {
                        int worldY = sectionMinY + y * 4;
                        if (worldY + 3 < biomeBoundary.getMinY() || worldY > biomeBoundary.getMaxY()) continue;
                        ((Chunk_v1_18)chunk).getBiomeData().set(x, y, z, biomeId);
                    }
                }
            }
        }
        event.markForReEncode(true);
    }
}

