/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.notification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.notification.Notification;
import me.mochibit.defcon.notification.NotificationType;
import me.mochibit.defcon.threading.scheduling.SchedulingUtilsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0006\u0010!\u001a\u00020\u001dJ\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u0018J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\u0018H\u0002J\"\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020+2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010.\u001a\u00020/J\"\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0018J\u0010\u00101\u001a\u00020\u001d2\b\b\u0002\u00102\u001a\u00020/J\u0006\u00103\u001a\u00020\u001dJ\b\u00104\u001a\u00020\u001dH\u0002J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001806J\r\u00107\u001a\u00020\u0007\u00a2\u0006\u0004\b8\u00109J\u0015\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0007\u00a2\u0006\u0004\b<\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006="}, d2={"Lme/mochibit/defcon/notification/NotificationManager;", "", "<init>", "()V", "CONFIG_FILENAME", "", "DEFAULT_BROADCAST_INTERVAL_SECONDS", "Lkotlin/time/Duration;", "J", "notificationFile", "Ljava/io/File;", "getNotificationFile", "()Ljava/io/File;", "notificationFile$delegate", "Lkotlin/Lazy;", "gson", "Lcom/google/gson/Gson;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "broadcastTask", "Ljava/io/Closeable;", "notifications", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lme/mochibit/defcon/notification/Notification;", "notificationIndex", "", "broadcastIntervalSeconds", "startBroadcastTask", "", "intervalSeconds", "startBroadcastTask-LRDsOJo", "(J)V", "stopBroadcastTask", "broadcastNotification", "notification", "showNotification", "audience", "Lnet/kyori/adventure/audience/Audience;", "playNotificationSound", "type", "Lme/mochibit/defcon/notification/NotificationType;", "getPrefix", "Lnet/kyori/adventure/text/Component;", "addNotification", "message", "saveToFile", "", "removeNotification", "clearNotifications", "saveChanges", "saveNotifications", "loadNotifications", "getNotifications", "", "getBroadcastInterval", "getBroadcastInterval-UwyO8pc", "()J", "setBroadcastInterval", "duration", "setBroadcastInterval-LRDsOJo", "Defcon"})
@SourceDebugExtension(value={"SMAP\nNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationManager.kt\nme/mochibit/defcon/notification/NotificationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1869#2,2:324\n774#2:326\n865#2,2:327\n774#2:329\n865#2,2:330\n*S KotlinDebug\n*F\n+ 1 NotificationManager.kt\nme/mochibit/defcon/notification/NotificationManager\n*L\n120#1:324,2\n260#1:326\n260#1:327,2\n281#1:329\n281#1:330,2\n*E\n"})
public final class NotificationManager {
    @NotNull
    public static final NotificationManager INSTANCE = new NotificationManager();
    @NotNull
    private static final String CONFIG_FILENAME = "notifications.json";
    private static final long DEFAULT_BROADCAST_INTERVAL_SECONDS = DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    private static final Lazy notificationFile$delegate = LazyKt.lazy(NotificationManager::notificationFile_delegate$lambda$1);
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final MiniMessage miniMessage;
    @Nullable
    private static Closeable broadcastTask;
    @NotNull
    private static final CopyOnWriteArrayList<Notification> notifications;
    private static int notificationIndex;
    private static long broadcastIntervalSeconds;

    private NotificationManager() {
    }

    private final File getNotificationFile() {
        Lazy lazy = notificationFile$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    public final void startBroadcastTask-LRDsOJo(long intervalSeconds) {
        this.stopBroadcastTask();
        broadcastIntervalSeconds = intervalSeconds;
        broadcastTask = SchedulingUtilsKt.interval-NqJ4yvY$default(broadcastIntervalSeconds, 0L, (Function1)new Function1<Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (NotificationManager.access$getNotifications$p().isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        Notification notification = (Notification)NotificationManager.access$getNotifications$p().get(NotificationManager.access$getNotificationIndex$p());
                        Intrinsics.checkNotNull((Object)notification);
                        NotificationManager.access$broadcastNotification(NotificationManager.INSTANCE, notification);
                        NotificationManager.access$setNotificationIndex$p((NotificationManager.INSTANCE.access$getNotificationIndex$p() + 1) % NotificationManager.access$getNotifications$p().size());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        Defcon.Companion.getInstance().getLogger().info("Notification broadcast task started with interval of " + Duration.toString-impl((long)intervalSeconds) + " seconds");
    }

    public static /* synthetic */ void startBroadcastTask-LRDsOJo$default(NotificationManager notificationManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = DEFAULT_BROADCAST_INTERVAL_SECONDS;
        }
        notificationManager.startBroadcastTask-LRDsOJo(l);
    }

    public final void stopBroadcastTask() {
        Closeable closeable = broadcastTask;
        if (closeable != null) {
            closeable.close();
        }
        broadcastTask = null;
        Defcon.Companion.getInstance().getLogger().info("Notification broadcast task stopped");
    }

    private final void broadcastNotification(Notification notification) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Collection onlinePlayers = collection;
        if (onlinePlayers.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = onlinePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            INSTANCE.showNotification((Audience)player, notification);
        }
    }

    public final void showNotification(@NotNull Audience audience, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        try {
            Component component = miniMessage.deserialize((Object)notification.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            Component message = component;
            Component prefix = this.getPrefix(notification);
            Component component2 = prefix.appendSpace().append(message);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"append(...)");
            Component formattedMessage = component2;
            audience.sendMessage(formattedMessage);
            this.playNotificationSound(audience, notification.getType());
        }
        catch (Exception e) {
            Defcon.Companion.getInstance().getLogger().warning("Failed to show notification: " + e.getMessage());
        }
    }

    private final void playNotificationSound(Audience audience, NotificationType type) {
        Sound.Builder builder = Sound.sound();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"sound(...)");
        Sound.Builder soundBuilder = builder;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Sound.Builder builder2 = soundBuilder.type(Key.key((String)"minecraft", (String)"block.note_block.pling")).volume(0.5f).pitch(1.0f);
                break;
            }
            case 2: {
                Sound.Builder builder2 = soundBuilder.type(Key.key((String)"minecraft", (String)"entity.experience_orb.pickup")).volume(0.5f).pitch(0.8f);
                break;
            }
            case 3: {
                Sound.Builder builder2 = soundBuilder.type(Key.key((String)"minecraft", (String)"entity.wither.spawn")).volume(0.3f).pitch(1.5f);
                break;
            }
            case 4: {
                Sound.Builder builder2 = soundBuilder.type(Key.key((String)"minecraft", (String)"entity.player.levelup")).volume(0.5f).pitch(1.2f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        audience.playSound((Sound)soundBuilder.build(), Sound.Emitter.self());
    }

    private final Component getPrefix(Notification notification) {
        Component component;
        switch (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()]) {
            case 1: {
                Component component2 = miniMessage.deserialize((Object)"<gradient:#a8ff78:#ACB6E5><bold>DEFCON \u2622</bold></gradient>");
                component = component2;
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"deserialize(...)");
                break;
            }
            case 2: {
                Component component3 = miniMessage.deserialize((Object)"<gradient:#f12711:#f5af19><bold>DEFCON \u2622</bold></gradient>");
                component = component3;
                Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"deserialize(...)");
                break;
            }
            case 3: {
                Component component4 = miniMessage.deserialize((Object)"<gradient:#FF416C:#FF4B2B><bold>DEFCON \u2622</bold></gradient>");
                component = component4;
                Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"deserialize(...)");
                break;
            }
            case 4: {
                Component component5 = miniMessage.deserialize((Object)"<gradient:#11998e:#38ef7d><bold>DEFCON \u2622</bold></gradient>");
                component = component5;
                Intrinsics.checkNotNullExpressionValue((Object)component5, (String)"deserialize(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return component;
    }

    @NotNull
    public final Notification addNotification(@NotNull Component message, @NotNull NotificationType type, boolean saveToFile) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Object object = miniMessage.serialize(message);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serialize(...)");
        Notification notification = new Notification((String)object, type, saveToFile, System.currentTimeMillis(), null, 16, null);
        notifications.add(notification);
        if (saveToFile) {
            this.saveNotifications();
        }
        return notification;
    }

    public static /* synthetic */ Notification addNotification$default(NotificationManager notificationManager, Component component, NotificationType notificationType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            notificationType = NotificationType.INFO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return notificationManager.addNotification(component, notificationType, bl);
    }

    @NotNull
    public final Notification addNotification(@NotNull String message, @NotNull NotificationType type, boolean saveToFile) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Component component = miniMessage.deserialize((Object)message);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        return this.addNotification(component, type, saveToFile);
    }

    public static /* synthetic */ Notification addNotification$default(NotificationManager notificationManager, String string, NotificationType notificationType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            notificationType = NotificationType.INFO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return notificationManager.addNotification(string, notificationType, bl);
    }

    public final void removeNotification(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        notifications.remove(notification);
        this.saveNotifications();
    }

    public final void clearNotifications(boolean saveChanges) {
        notifications.clear();
        if (saveChanges) {
            this.saveNotifications();
        }
    }

    public static /* synthetic */ void clearNotifications$default(NotificationManager notificationManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        notificationManager.clearNotifications(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void saveNotifications() {
        try {
            Closeable closeable = new FileWriter(this.getNotificationFile());
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                Iterable $this$filter$iv = notifications;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Notification it = (Notification)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.getSaveToFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notificationsToSave = (List)destination$iv$iv;
                gson.toJson((Object)notificationsToSave, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Defcon.Companion.getInstance().getLogger().warning("Failed to save notifications: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadNotifications() {
        try {
            if (this.getNotificationFile().length() <= 0L) {
                return;
            }
            Closeable closeable = new FileReader(this.getNotificationFile());
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                Type typeToken2 = new TypeToken<List<? extends Notification>>(){}.getType();
                Object object = gson.fromJson((Reader)reader, typeToken2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                List loadedNotifications = (List)object;
                Iterable iterable = loadedNotifications;
                CopyOnWriteArrayList<Notification> copyOnWriteArrayList = notifications;
                boolean $i$f$filter = false;
                void var10_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Notification it = (Notification)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.getSaveToFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                boolean bl3 = copyOnWriteArrayList.addAll((List)destination$iv$iv);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Defcon.Companion.getInstance().getLogger().warning("Failed to load notifications: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @NotNull
    public final List<Notification> getNotifications() {
        return CollectionsKt.toList((Iterable)notifications);
    }

    public final long getBroadcastInterval-UwyO8pc() {
        return broadcastIntervalSeconds;
    }

    public final void setBroadcastInterval-LRDsOJo(long duration) {
        if (Duration.getInWholeSeconds-impl((long)duration) < 1L) {
            throw new IllegalArgumentException("Broadcast interval must be at least 1 second");
        }
        broadcastIntervalSeconds = duration;
        if (broadcastTask != null) {
            this.startBroadcastTask-LRDsOJo(duration);
        }
    }

    private static final File notificationFile_delegate$lambda$1() {
        Object object = new String[]{CONFIG_FILENAME};
        Path path = Paths.get(Defcon.Companion.getInstance().getDataFolder().getPath(), (String[])object);
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        object = path2;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Object $this$notificationFile_delegate_u24lambda_u241_u24lambda_u240 = object = path.toFile();
        boolean bl = false;
        if (!((File)$this$notificationFile_delegate_u24lambda_u241_u24lambda_u240).exists()) {
            ((File)$this$notificationFile_delegate_u24lambda_u241_u24lambda_u240).createNewFile();
        }
        return object;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getNotifications$p() {
        return notifications;
    }

    public static final /* synthetic */ int access$getNotificationIndex$p() {
        return notificationIndex;
    }

    public static final /* synthetic */ void access$broadcastNotification(NotificationManager $this, Notification notification) {
        $this.broadcastNotification(notification);
    }

    public static final /* synthetic */ void access$setNotificationIndex$p(int n) {
        notificationIndex = n;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        NotificationManager.gson = gson;
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        NotificationManager.miniMessage = miniMessage;
        notifications = new CopyOnWriteArrayList();
        broadcastIntervalSeconds = DEFAULT_BROADCAST_INTERVAL_SECONDS;
        try {
            INSTANCE.loadNotifications();
            Defcon.Companion.getInstance().getLogger().info("NotificationManager initialized with " + notifications.size() + " notifications");
        }
        catch (Exception e) {
            Defcon.Companion.getInstance().getLogger().severe("Failed to initialize NotificationManager: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.SUCCESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

