/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.particles.emitter;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.lifecycle.Lifecycled;
import me.mochibit.defcon.particles.emitter.ClientSideParticleInstance;
import me.mochibit.defcon.particles.emitter.EmitterShape;
import me.mochibit.defcon.particles.emitter.ObjectPool;
import me.mochibit.defcon.particles.emitter.ParticleInstance;
import me.mochibit.defcon.particles.emitter.PointShape;
import me.mochibit.defcon.particles.mutators.AbstractShapeMutator;
import me.mochibit.defcon.particles.templates.AbstractParticle;
import me.mochibit.defcon.threading.scheduling.SchedulingUtilsKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\u0018\u0000 Y2\u00020\u0001:\u0002YZBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u000eH\u0002J\b\u0010K\u001a\u00020IH\u0016J,\u0010L\u001a\u00020I2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020+0N2\u0006\u0010O\u001a\u00020\u00052\f\u0010P\u001a\b\u0012\u0004\u0012\u0002000NH\u0002J\u0010\u0010Q\u001a\u00020I2\u0006\u0010O\u001a\u00020?H\u0016J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u0003H\u0002J\b\u0010T\u001a\u00020IH\u0002J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u0002000NH\u0002J\b\u0010V\u001a\u00020IH\u0016J\u0006\u0010W\u001a\u00020\u0007J\u0006\u0010X\u001a\u00020IR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00070/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00101\u001a\u0014\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u0002020-0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002090/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010B\u001a\u00020A2\u0006\u0010@\u001a\u00020A@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lme/mochibit/defcon/particles/emitter/ParticleEmitter;", "Lme/mochibit/defcon/lifecycle/Lifecycled;", "position", "Lorg/bukkit/Location;", "range", "", "maxParticles", "", "emitterShape", "Lme/mochibit/defcon/particles/emitter/EmitterShape;", "transform", "Lorg/joml/Matrix4f;", "spawnableParticles", "", "Lme/mochibit/defcon/particles/templates/AbstractParticle;", "shapeMutator", "Lme/mochibit/defcon/particles/mutators/AbstractShapeMutator;", "<init>", "(Lorg/bukkit/Location;DILme/mochibit/defcon/particles/emitter/EmitterShape;Lorg/joml/Matrix4f;Ljava/util/List;Lme/mochibit/defcon/particles/mutators/AbstractShapeMutator;)V", "getEmitterShape", "()Lme/mochibit/defcon/particles/emitter/EmitterShape;", "setEmitterShape", "(Lme/mochibit/defcon/particles/emitter/EmitterShape;)V", "getTransform", "()Lorg/joml/Matrix4f;", "getSpawnableParticles", "()Ljava/util/List;", "getShapeMutator", "()Lme/mochibit/defcon/particles/mutators/AbstractShapeMutator;", "setShapeMutator", "(Lme/mochibit/defcon/particles/mutators/AbstractShapeMutator;)V", "origin", "Lorg/joml/Vector3f;", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "rangeSquared", "vectorPool", "Lme/mochibit/defcon/particles/emitter/ObjectPool;", "positionCursor", "particles", "Lme/mochibit/defcon/particles/emitter/ParticleEmitter$ConcurrentVectorList;", "Lme/mochibit/defcon/particles/emitter/ParticleInstance;", "particlesToRemove", "Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "visiblePlayers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "batchedUpdates", "Lme/mochibit/defcon/particles/emitter/ClientSideParticleInstance;", "activeCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "dyingOut", "Ljava/util/concurrent/atomic/AtomicBoolean;", "updateCounter", "lastUpdateTimes", "", "radialVelocity", "getRadialVelocity", "()Lorg/joml/Vector3f;", "particlesPerFrame", "spawnProbability", "", "value", "", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "workThreads", "spawnParticle", "", "particle", "start", "updateParticleRange", "particleRange", "", "delta", "players", "update", "getLodLevel", "playerLocation", "updateVisiblePlayers", "getPlayersInRange", "stop", "getParticleCount", "reset", "Companion", "ConcurrentVectorList", "Defcon"})
@SourceDebugExtension(value={"SMAP\nParticleEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleEmitter.kt\nme/mochibit/defcon/particles/emitter/ParticleEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,505:1\n1869#2,2:506\n808#2,11:508\n1563#2:519\n1634#2,3:520\n1869#2,2:523\n1869#2,2:525\n1869#2,2:527\n*S KotlinDebug\n*F\n+ 1 ParticleEmitter.kt\nme/mochibit/defcon/particles/emitter/ParticleEmitter\n*L\n182#1:506,2\n327#1:508,11\n336#1:519\n336#1:520,3\n347#1:523,2\n86#1:525,2\n461#1:527,2\n*E\n"})
public final class ParticleEmitter
implements Lifecycled {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxParticles;
    @NotNull
    private EmitterShape emitterShape;
    @NotNull
    private final Matrix4f transform;
    @NotNull
    private final List<AbstractParticle> spawnableParticles;
    @Nullable
    private AbstractShapeMutator shapeMutator;
    @NotNull
    private final Vector3f origin;
    @NotNull
    private final World world;
    private final double rangeSquared;
    @NotNull
    private final ObjectPool<Vector3f> vectorPool;
    @NotNull
    private final Vector3f positionCursor;
    @NotNull
    private final ConcurrentVectorList<ParticleInstance> particles;
    @NotNull
    private final ObjectArrayList<ParticleInstance> particlesToRemove;
    @NotNull
    private final ConcurrentHashMap<Player, Integer> visiblePlayers;
    @NotNull
    private final ConcurrentHashMap<Player, ObjectArrayList<ClientSideParticleInstance>> batchedUpdates;
    @NotNull
    private final AtomicInteger activeCount;
    @NotNull
    private final AtomicBoolean dyingOut;
    @NotNull
    private final AtomicInteger updateCounter;
    @NotNull
    private final ConcurrentHashMap<Integer, Long> lastUpdateTimes;
    @NotNull
    private final Vector3f radialVelocity;
    private int particlesPerFrame;
    private float spawnProbability;
    private boolean visible;
    private final int workThreads;
    private static final int LOD_CLOSE = 4;
    private static final int LOD_MEDIUM = 2;
    private static final int LOD_FAR = 1;
    private static final double LOD_CLOSE_DISTANCE_SQ = 100.0;
    private static final double LOD_MEDIUM_DISTANCE_SQ = 400.0;
    private static final int BATCH_SIZE = 1000;

    public ParticleEmitter(@NotNull Location position, double range, int maxParticles, @NotNull EmitterShape emitterShape, @NotNull Matrix4f transform, @NotNull List<AbstractParticle> spawnableParticles, @Nullable AbstractShapeMutator shapeMutator) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)emitterShape, (String)"emitterShape");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter(spawnableParticles, (String)"spawnableParticles");
        this.maxParticles = maxParticles;
        this.emitterShape = emitterShape;
        this.transform = transform;
        this.spawnableParticles = spawnableParticles;
        this.shapeMutator = shapeMutator;
        this.origin = new Vector3f((float)position.getX(), (float)position.getY(), (float)position.getZ());
        World world = position.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        this.world = world;
        this.rangeSquared = range * range;
        this.vectorPool = new ObjectPool(1000, ParticleEmitter::vectorPool$lambda$0);
        this.positionCursor = new Vector3f();
        this.particles = new ConcurrentVectorList(this.maxParticles);
        this.particlesToRemove = new ObjectArrayList(200);
        this.visiblePlayers = new ConcurrentHashMap(32);
        this.batchedUpdates = new ConcurrentHashMap(32);
        this.activeCount = new AtomicInteger(0);
        this.dyingOut = new AtomicBoolean(false);
        this.updateCounter = new AtomicInteger(0);
        this.lastUpdateTimes = new ConcurrentHashMap(this.maxParticles);
        this.radialVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
        this.particlesPerFrame = 15;
        this.spawnProbability = 1.0f;
        this.visible = true;
        this.workThreads = RangesKt.coerceAtMost((int)Runtime.getRuntime().availableProcessors(), (int)4);
    }

    public /* synthetic */ ParticleEmitter(Location location, double d, int n, EmitterShape emitterShape, Matrix4f matrix4f, List list, AbstractShapeMutator abstractShapeMutator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1500;
        }
        if ((n2 & 8) != 0) {
            emitterShape = PointShape.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            matrix4f = new Matrix4f();
        }
        if ((n2 & 0x20) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 0x40) != 0) {
            abstractShapeMutator = null;
        }
        this(location, d, n, emitterShape, matrix4f, list, abstractShapeMutator);
    }

    @NotNull
    public final EmitterShape getEmitterShape() {
        return this.emitterShape;
    }

    public final void setEmitterShape(@NotNull EmitterShape emitterShape) {
        Intrinsics.checkNotNullParameter((Object)emitterShape, (String)"<set-?>");
        this.emitterShape = emitterShape;
    }

    @NotNull
    public final Matrix4f getTransform() {
        return this.transform;
    }

    @NotNull
    public final List<AbstractParticle> getSpawnableParticles() {
        return this.spawnableParticles;
    }

    @Nullable
    public final AbstractShapeMutator getShapeMutator() {
        return this.shapeMutator;
    }

    public final void setShapeMutator(@Nullable AbstractShapeMutator abstractShapeMutator) {
        this.shapeMutator = abstractShapeMutator;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final Vector3f getRadialVelocity() {
        return this.radialVelocity;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean value) {
        if (this.visible == value) {
            return;
        }
        this.visible = value;
        if (!value) {
            List<Player> players = this.getPlayersInRange();
            this.particles.forEach((Function1<ParticleInstance, Unit>)((Function1)arg_0 -> ParticleEmitter._set_visible_$lambda$2(players, arg_0)));
        }
    }

    private final void spawnParticle(AbstractParticle particle) {
        if (this.activeCount.get() >= this.maxParticles || !this.visible || this.dyingOut.get()) {
            return;
        }
        this.positionCursor.set((Vector3fc)this.origin);
        if (!Intrinsics.areEqual((Object)this.emitterShape, (Object)PointShape.INSTANCE)) {
            this.emitterShape.maskLoc(this.positionCursor);
            this.transform.transformPosition(this.positionCursor);
            AbstractShapeMutator abstractShapeMutator = this.shapeMutator;
            if (abstractShapeMutator != null) {
                abstractShapeMutator.mutateLoc(this.positionCursor);
            }
        } else {
            this.transform.transformPosition(this.positionCursor);
        }
        ParticleInstance newParticle = ParticleInstance.Companion.fromTemplate(particle, this.positionCursor);
        if (this.radialVelocity.lengthSquared() > 0.0f) {
            Vector3f velocity = this.vectorPool.obtain();
            velocity.set((Vector3fc)this.positionCursor).sub((Vector3fc)this.origin).normalize().mul((Vector3fc)this.radialVelocity);
            newParticle.addVelocity(velocity);
            this.vectorPool.free(velocity);
        }
        this.particles.add(newParticle);
        this.activeCount.incrementAndGet();
        List<Player> playersInRange = this.getPlayersInRange();
        Iterable $this$forEach$iv = playersInRange;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            newParticle.show(player);
        }
    }

    @Override
    public void start() {
        this.updateCounter.set(0);
        this.activeCount.set(0);
        if (this.visible && !((Collection)this.spawnableParticles).isEmpty()) {
            int initialParticles = this.maxParticles / 10;
            int n = RangesKt.coerceAtMost((int)initialParticles, (int)this.maxParticles);
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.spawnParticle(this.spawnableParticles.get(ThreadLocalRandom.current().nextInt(this.spawnableParticles.size())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateParticleRange(List<? extends ParticleInstance> particleRange, double delta, List<? extends Player> players) {
        int currentFrame = this.updateCounter.get();
        for (ParticleInstance particleInstance : particleRange) {
            Serializable serializable;
            boolean needsPositionUpdate = false;
            int particleId = System.identityHashCode(particleInstance);
            int maxLodFactor = 1;
            for (Player player : players) {
                Integer n = this.visiblePlayers.get(player);
                int lod = n != null ? n : 1;
                maxLodFactor = Math.max(maxLodFactor, lod);
            }
            long currentTime = System.currentTimeMillis();
            Long l = this.lastUpdateTimes.getOrDefault(particleId, 0L);
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getOrDefault(...)");
            long lastUpdateTime = ((Number)l).longValue();
            if (currentTime - lastUpdateTime >= (long)(50 / maxLodFactor)) {
                double scaledDelta = delta * (double)maxLodFactor;
                needsPositionUpdate = particleInstance.update(scaledDelta);
                serializable = particleId;
                Long l2 = currentTime;
                ((Map)this.lastUpdateTimes).put(serializable, l2);
            }
            if (needsPositionUpdate && particleInstance instanceof ClientSideParticleInstance) {
                for (Player player : players) {
                    serializable = this.batchedUpdates;
                    synchronized (serializable) {
                        boolean bl = false;
                        boolean bl2 = this.batchedUpdates.computeIfAbsent(player, arg_0 -> ParticleEmitter.updateParticleRange$lambda$7$lambda$6(ParticleEmitter::updateParticleRange$lambda$7$lambda$5, arg_0)).add((Object)particleInstance);
                    }
                }
            }
            if (!particleInstance.isDead()) continue;
            ObjectArrayList<ParticleInstance> objectArrayList = this.particlesToRemove;
            synchronized (objectArrayList) {
                boolean bl = false;
                boolean bl3 = this.particlesToRemove.add((Object)particleInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        int availableCapacity;
        this.updateVisiblePlayers();
        Set set = this.visiblePlayers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        List players = CollectionsKt.toList((Iterable)set);
        if (this.activeCount.get() < this.maxParticles && !this.dyingOut.get() && this.visible && !((Collection)this.spawnableParticles).isEmpty() && ThreadLocalRandom.current().nextFloat() < this.spawnProbability && (availableCapacity = this.maxParticles - this.activeCount.get()) > 0) {
            int particlesToCreate = Math.min(this.particlesPerFrame, availableCapacity);
            int n = 0;
            while (n < particlesToCreate) {
                int it = n++;
                boolean bl = false;
                this.spawnParticle(this.spawnableParticles.get(ThreadLocalRandom.current().nextInt(this.spawnableParticles.size())));
            }
        }
        ConcurrentHashMap<Player, ObjectArrayList<ClientSideParticleInstance>> particlesToCreate = this.batchedUpdates;
        synchronized (particlesToCreate) {
            boolean $i$a$-synchronized-ParticleEmitter$update$52 = false;
            this.batchedUpdates.clear();
            Unit $i$a$-synchronized-ParticleEmitter$update$52 = Unit.INSTANCE;
        }
        int size = this.particles.size();
        if (size > 1000 && this.workThreads > 1) {
            int batchSize = size / this.workThreads;
            ArrayList futures = new ArrayList(this.workThreads);
            ExecutorService executor = Executors.newFixedThreadPool(this.workThreads);
            int n = this.workThreads;
            for (int i = 0; i < n; ++i) {
                int start2 = i * batchSize;
                int end = i == this.workThreads - 1 ? size : (i + 1) * batchSize;
                Future<?> future = executor.submit(() -> ParticleEmitter.update$lambda$11(this, start2, end, delta, players));
                futures.add(future);
            }
            Iterator iterator = futures.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator i = iterator;
            while (i.hasNext()) {
                Object e = i.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Future future = (Future)e;
                future.get();
            }
            executor.shutdown();
        } else {
            List<ParticleInstance> particleBatch = this.particles.getRange(0, size);
            this.updateParticleRange(particleBatch, delta, players);
        }
        ConcurrentHashMap<Player, ObjectArrayList<ClientSideParticleInstance>> concurrentHashMap = this.batchedUpdates;
        synchronized (concurrentHashMap) {
            boolean $i$a$-synchronized-ParticleEmitter$update$62 = false;
            block12: for (Map.Entry future : ((Map)this.batchedUpdates).entrySet()) {
                Player player = (Player)future.getKey();
                ObjectArrayList particleList = (ObjectArrayList)future.getValue();
                int batchSize = 128;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)particleList.size())), (int)batchSize);
                int i = intProgression.getFirst();
                int n = intProgression.getLast();
                int n2 = intProgression.getStep();
                if ((n2 <= 0 || i > n) && (n2 >= 0 || n > i)) continue;
                while (true) {
                    int end = Math.min(i + batchSize, particleList.size());
                    for (int j = i; j < end; ++j) {
                        ((ClientSideParticleInstance)particleList.get(j)).updatePosition(player);
                    }
                    if (i == n) continue block12;
                    i += n2;
                }
            }
            this.batchedUpdates.clear();
            Unit $i$a$-synchronized-ParticleEmitter$update$62 = Unit.INSTANCE;
        }
        concurrentHashMap = this.particlesToRemove;
        synchronized (concurrentHashMap) {
            boolean bl = false;
            if (!((Collection)this.particlesToRemove).isEmpty()) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = (Iterable)this.particlesToRemove;
                int $i$f$filterIsInstance = 0;
                Iterable player = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ClientSideParticleInstance)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List clientSideParticles = (List)destination$iv$iv;
                if (!((Collection)clientSideParticles).isEmpty()) {
                    int batchSize = 100;
                    int i = 0;
                    $i$f$filterIsInstance = ((Collection)clientSideParticles).size() + -1;
                    int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)$i$f$filterIsInstance, (int)batchSize);
                    if (i <= n) {
                        while (true) {
                            void $this$mapTo$iv$iv;
                            int end = Math.min(i + batchSize, clientSideParticles.size());
                            List batch = clientSideParticles.subList(i, end);
                            Iterable $this$map$iv = batch;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                ClientSideParticleInstance clientSideParticleInstance = (ClientSideParticleInstance)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl2 = false;
                                collection.add(it.getParticleID());
                            }
                            Object object = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2));
                            int[] nArray = Arrays.copyOf((int[])object, ((int[])object).length);
                            WrapperPlayServerDestroyEntities destroyPacket = new WrapperPlayServerDestroyEntities(nArray);
                            object = this.getPlayersInRange().iterator();
                            while (object.hasNext()) {
                                Player player2 = (Player)object.next();
                                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player2, (PacketWrapper)destroyPacket);
                            }
                            if (i == n) break;
                            i += batchSize;
                        }
                    }
                    this.activeCount.addAndGet(-clientSideParticles.size());
                    Iterable $this$forEach$iv = clientSideParticles;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ClientSideParticleInstance particle = (ClientSideParticleInstance)element$iv;
                        boolean bl3 = false;
                        int particleId = System.identityHashCode(particle);
                        this.lastUpdateTimes.remove(particleId);
                    }
                }
                this.particles.removeAll((Collection)this.particlesToRemove);
                this.particlesToRemove.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.updateCounter.incrementAndGet();
    }

    private final int getLodLevel(Location playerLocation) {
        float distSq = this.origin.distanceSquared((float)playerLocation.getX(), (float)playerLocation.getY(), (float)playerLocation.getZ());
        return (double)distSq < 100.0 ? 4 : ((double)distSq < 400.0 ? 2 : 1);
    }

    private final void updateVisiblePlayers() {
        if (this.updateCounter.get() % 10 != 0) {
            return;
        }
        HashMap playersToUpdate = new HashMap();
        for (Player player : this.world.getPlayers()) {
            Location playerLocation;
            Intrinsics.checkNotNullExpressionValue((Object)player.getLocation(), (String)"getLocation(...)");
            float distSquared = this.origin.distanceSquared((float)playerLocation.getX(), (float)playerLocation.getY(), (float)playerLocation.getZ());
            if ((double)distSquared < this.rangeSquared) {
                int lodLevel = this.getLodLevel(playerLocation);
                Integer n = lodLevel;
                ((Map)playersToUpdate).put(player, n);
                if (this.visiblePlayers.containsKey(player) || !this.visible) continue;
                this.particles.forEach((Function1<ParticleInstance, Unit>)((Function1)arg_0 -> ParticleEmitter.updateVisiblePlayers$lambda$16(player, arg_0)));
                continue;
            }
            if (!this.visiblePlayers.containsKey(player)) continue;
            this.particles.forEach((Function1<ParticleInstance, Unit>)((Function1)arg_0 -> ParticleEmitter.updateVisiblePlayers$lambda$17(player, arg_0)));
        }
        this.visiblePlayers.clear();
        this.visiblePlayers.putAll(playersToUpdate);
    }

    private final List<Player> getPlayersInRange() {
        Set set = this.visiblePlayers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    @Override
    public void stop() {
        this.dyingOut.set(true);
        SchedulingUtilsKt.intervalAsyncWithTask(0L, 1L, (Function1<? super BukkitTask, Unit>)((Function1)arg_0 -> ParticleEmitter.stop$lambda$18(this, arg_0)));
    }

    public final int getParticleCount() {
        return this.activeCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        List<Player> players = this.getPlayersInRange();
        this.particles.forEach((Function1<ParticleInstance, Unit>)((Function1)arg_0 -> ParticleEmitter.reset$lambda$20(players, arg_0)));
        ObjectArrayList<ParticleInstance> objectArrayList = this.particlesToRemove;
        synchronized (objectArrayList) {
            boolean bl = false;
            this.particlesToRemove.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.activeCount.set(0);
        this.updateCounter.set(0);
        this.lastUpdateTimes.clear();
    }

    private static final Vector3f vectorPool$lambda$0() {
        return new Vector3f();
    }

    private static final Unit _set_visible_$lambda$2(List $players, ParticleInstance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ClientSideParticleInstance) {
            Iterable $this$forEach$iv = $players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                ((ClientSideParticleInstance)it).sendDespawnPacket(player);
            }
        }
        return Unit.INSTANCE;
    }

    private static final ObjectArrayList updateParticleRange$lambda$7$lambda$5(Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ObjectArrayList();
    }

    private static final ObjectArrayList updateParticleRange$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (ObjectArrayList)$tmp0.invoke(p0);
    }

    private static final void update$lambda$11(ParticleEmitter this$0, int $start, int $end, float $delta, List $players) {
        List<ParticleInstance> particleBatch = this$0.particles.getRange($start, $end);
        this$0.updateParticleRange(particleBatch, $delta, $players);
    }

    private static final Unit updateVisiblePlayers$lambda$16(Player $player, ParticleInstance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ClientSideParticleInstance) {
            ClientSideParticleInstance clientSideParticleInstance = (ClientSideParticleInstance)it;
            Intrinsics.checkNotNull((Object)$player);
            clientSideParticleInstance.sendSpawnPacket($player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateVisiblePlayers$lambda$17(Player $player, ParticleInstance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ClientSideParticleInstance) {
            ClientSideParticleInstance clientSideParticleInstance = (ClientSideParticleInstance)it;
            Intrinsics.checkNotNull((Object)$player);
            clientSideParticleInstance.sendDespawnPacket($player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit stop$lambda$18(ParticleEmitter this$0, BukkitTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this$0.particles.isEmpty()) {
            task.cancel();
            return Unit.INSTANCE;
        }
        this$0.update(0.05f);
        return Unit.INSTANCE;
    }

    private static final Unit reset$lambda$20(List $players, ParticleInstance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ClientSideParticleInstance) {
            Iterable $this$forEach$iv = $players;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                ((ClientSideParticleInstance)it).sendDespawnPacket(player);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/mochibit/defcon/particles/emitter/ParticleEmitter$Companion;", "", "<init>", "()V", "LOD_CLOSE", "", "LOD_MEDIUM", "LOD_FAR", "LOD_CLOSE_DISTANCE_SQ", "", "LOD_MEDIUM_DISTANCE_SQ", "BATCH_SIZE", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\u001a\u0010\u0014\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0011R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/mochibit/defcon/particles/emitter/ParticleEmitter$ConcurrentVectorList;", "T", "", "initialCapacity", "", "<init>", "(I)V", "backingList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lock", "add", "", "element", "(Ljava/lang/Object;)V", "size", "removeAll", "", "elements", "", "forEach", "action", "Lkotlin/Function1;", "getRange", "", "start", "end", "isEmpty", "Defcon"})
    @SourceDebugExtension(value={"SMAP\nParticleEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleEmitter.kt\nme/mochibit/defcon/particles/emitter/ParticleEmitter$ConcurrentVectorList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,505:1\n1869#2,2:506\n*S KotlinDebug\n*F\n+ 1 ParticleEmitter.kt\nme/mochibit/defcon/particles/emitter/ParticleEmitter$ConcurrentVectorList\n*L\n125#1:506,2\n*E\n"})
    private static final class ConcurrentVectorList<T> {
        @NotNull
        private final ArrayList<T> backingList;
        @NotNull
        private final Object lock;

        public ConcurrentVectorList(int initialCapacity) {
            this.backingList = new ArrayList(initialCapacity);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(T element) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.backingList.add(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int size() {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                int n = this.backingList.size();
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean removeAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.backingList.removeAll(CollectionsKt.toSet((Iterable)elements));
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void forEach(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            ArrayList snapshot = null;
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                snapshot = new ArrayList(this.backingList);
                Unit unit = Unit.INSTANCE;
            }
            Iterable $this$forEach$iv = snapshot;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<T> getRange(int start2, int end) {
            Object object = this.lock;
            synchronized (object) {
                int actualEnd;
                block4: {
                    boolean bl = false;
                    actualEnd = RangesKt.coerceAtMost((int)this.backingList.size(), (int)end);
                    if (start2 < actualEnd) break block4;
                    List list = CollectionsKt.emptyList();
                    return list;
                }
                List list = new ArrayList(this.backingList.subList(start2, actualEnd));
                return list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = this.backingList.isEmpty();
                return bl2;
            }
        }
    }
}

