/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.EventManager;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.mochibit.defcon.Defcon;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lme/mochibit/defcon/registers/EventRegister;", "", "<init>", "()V", "packageName", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "getPlugin", "()Lorg/bukkit/plugin/java/JavaPlugin;", "setPlugin", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "registerPacketListeners", "registerListeners", "Defcon"})
public final class EventRegister {
    @NotNull
    public static final EventRegister INSTANCE = new EventRegister();
    @NotNull
    private static String packageName;
    @NotNull
    private static JavaPlugin plugin;

    private EventRegister() {
    }

    @NotNull
    public final JavaPlugin getPlugin() {
        return plugin;
    }

    public final void setPlugin(@NotNull JavaPlugin javaPlugin) {
        Intrinsics.checkNotNullParameter((Object)javaPlugin, (String)"<set-?>");
        plugin = javaPlugin;
    }

    @NotNull
    public final EventRegister registerPacketListeners() {
        Set<Class<PacketListener>> packetListeners = new Reflections(packageName + ".listeners.packet", new Scanner[0]).getSubTypesOf(PacketListener.class);
        EventManager packetManager = PacketEvents.getAPI().getEventManager();
        for (Class<PacketListener> listener : packetListeners) {
            try {
                System.out.println((Object)("Registering packet listener: " + listener.getName()));
                PacketListener listenerObj = listener.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                packetManager.registerListener(listenerObj, PacketListenerPriority.NORMAL);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @NotNull
    public final EventRegister registerListeners() {
        plugin.getLogger().info("Registering listeners from " + packageName + ".listeners");
        Set<Class<Listener>> bukkitListeners = new Reflections(packageName + ".listeners", new Scanner[0]).getSubTypesOf(Listener.class);
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        PluginManager bukkitManager = pluginManager;
        for (Class<Listener> listener : bukkitListeners) {
            try {
                System.out.println((Object)("Registering bukkit listener: " + listener.getName()));
                Listener listenerObj = listener.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bukkitManager.registerEvents(listenerObj, (Plugin)plugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    static {
        String string = ((Object)((Object)Defcon.Companion.getInstance())).getClass().getPackage().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        packageName = string;
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue((Object)javaPlugin, (String)"getPlugin(...)");
        plugin = javaPlugin;
    }
}

