/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.classes.CustomItemDefinition;
import me.mochibit.defcon.classes.PluginConfiguration;
import me.mochibit.defcon.enums.ConfigurationStorage;
import me.mochibit.defcon.enums.ItemBehaviour;
import me.mochibit.defcon.exceptions.ItemNotRegisteredException;
import me.mochibit.defcon.interfaces.PluginItem;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/mochibit/defcon/registers/ItemRegister;", "", "<init>", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerItems", "", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nItemRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemRegister.kt\nme/mochibit/defcon/registers/ItemRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1869#2,2:116\n*S KotlinDebug\n*F\n+ 1 ItemRegister.kt\nme/mochibit/defcon/registers/ItemRegister\n*L\n57#1:116,2\n*E\n"})
public final class ItemRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin pluginInstance;
    @NotNull
    private static HashMap<String, PluginItem> registeredItems = new HashMap();

    public ItemRegister() {
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue((Object)javaPlugin, (String)"getPlugin(...)");
        this.pluginInstance = javaPlugin;
    }

    public final boolean registerItems() {
        registeredItems = new HashMap();
        FileConfiguration itemConfig = PluginConfiguration.Companion.get(ConfigurationStorage.Items).getConfig();
        if (itemConfig.getList("enabled-items") == null) {
            return false;
        }
        List list = itemConfig.getList("enabled-items");
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ItemBehaviour behaviourValue;
            String itemMinecraftId;
            String itemName;
            String string;
            NamespacedKey itemModel;
            boolean itemEquipable;
            boolean itemDroppable;
            boolean itemTransportable;
            boolean itemUsable;
            int itemStackSize;
            String itemCustomBlockId;
            String itemDescription;
            String itemId;
            Object item;
            block12: {
                block11: {
                    Object element$iv;
                    item = element$iv = iterator.next();
                    boolean bl = false;
                    itemId = String.valueOf(item);
                    if (registeredItems.get(itemId) != null) continue;
                    if (itemConfig.getString(item + ".item-name") == null) {
                        throw new ItemNotRegisteredException(itemId);
                    }
                    itemDescription = itemConfig.getString(item + ".item-description");
                    if (itemConfig.getString(item + ".item-minecraft-id") == null) {
                        throw new ItemNotRegisteredException(itemId);
                    }
                    itemCustomBlockId = itemConfig.getString(item + ".definitions-block-id", null);
                    itemStackSize = itemConfig.getInt(item + ".max-stack-size");
                    itemUsable = itemConfig.getBoolean(item + ".is-usable");
                    itemTransportable = itemConfig.getBoolean(item + ".is-transportable");
                    itemDroppable = itemConfig.getBoolean(item + ".is-droppable");
                    itemEquipable = itemConfig.getBoolean(item + ".is-equipable", false);
                    if (itemConfig.getString(item + ".item-model") != null) {
                        String it;
                        boolean bl2 = false;
                        v1 = NamespacedKey.fromString((String)it);
                    } else {
                        v1 = itemModel = null;
                    }
                    if ((string = itemConfig.getString(item + ".equip-slot")) == null) break block11;
                    String string2 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    string = string2;
                    if (string2 != null) break block12;
                }
                string = "HAND";
            }
            EquipmentSlot equipSlot = EquipmentSlot.valueOf((String)string);
            String behaviourName = itemConfig.getString(item + ".behaviour");
            if (behaviourName == null) {
                behaviourName = "generic";
            }
            if (ItemBehaviour.Companion.fromString(behaviourName) == null) {
                throw new IllegalArgumentException("Behaviour " + behaviourName + " is not valid");
            }
            PluginItem customItem = new CustomItemDefinition(itemId, itemName, itemDescription, itemMinecraftId, itemModel, equipSlot, itemCustomBlockId, itemUsable, itemEquipable, itemDroppable, itemStackSize, itemTransportable, behaviourValue);
            Defcon.Logger.INSTANCE.info("Registered item " + itemId);
            ((Map)registeredItems).put(customItem.getId(), customItem);
        }
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R>\u0010\u0004\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005j\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lme/mochibit/defcon/registers/ItemRegister$Companion;", "", "<init>", "()V", "registeredItems", "Ljava/util/HashMap;", "", "Lme/mochibit/defcon/interfaces/PluginItem;", "Lkotlin/collections/HashMap;", "getRegisteredItems", "()Ljava/util/HashMap;", "setRegisteredItems", "(Ljava/util/HashMap;)V", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, PluginItem> getRegisteredItems() {
            return registeredItems;
        }

        public final void setRegisteredItems(@NotNull HashMap<String, PluginItem> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            registeredItems = hashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

