/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.mochibit.defcon.Defcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0010H$J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\"\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u0003H\u0002J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00072\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'H\u0004J\u0018\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020 H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lme/mochibit/defcon/registers/PackRegister;", "", "zipDestination", "", "<init>", "(Z)V", "tempPath", "Ljava/nio/file/Path;", "getTempPath", "()Ljava/nio/file/Path;", "destinationPath", "getDestinationPath", "packRegistered", "isPackRegistered", "()Z", "register", "", "getFolderHash", "", "pathToHash", "write", "onPackCreated", "finalPath", "onMove", "zipFolder", "folderPath", "zipPath", "zipFolderPathContent", "zipFile", "fileToZip", "Ljava/io/File;", "fileName", "", "zipOut", "Ljava/util/zip/ZipOutputStream;", "copyFoldersFromResource", "resourceFolderPath", "targetPath", "excludedPaths", "", "createMcmetaJson", "formatVersion", "description", "Defcon"})
@SourceDebugExtension(value={"SMAP\nPackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackRegister.kt\nme/mochibit/defcon/registers/PackRegister\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n13472#2,2:235\n13472#2,2:237\n1#3:239\n1761#4,3:240\n*S KotlinDebug\n*F\n+ 1 PackRegister.kt\nme/mochibit/defcon/registers/PackRegister\n*L\n133#1:235,2\n159#1:237,2\n194#1:240,3\n*E\n"})
public abstract class PackRegister {
    private final boolean zipDestination;
    private boolean packRegistered;

    public PackRegister(boolean zipDestination) {
        this.zipDestination = zipDestination;
    }

    public /* synthetic */ PackRegister(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public abstract Path getTempPath();

    @Nullable
    public abstract Path getDestinationPath();

    public final boolean isPackRegistered() {
        return this.packRegistered;
    }

    public final void register() {
        boolean moved;
        if (Files.exists(this.getTempPath(), new LinkOption[0])) {
            File file = this.getTempPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file);
        }
        Files.createDirectories(this.getTempPath(), new FileAttribute[0]);
        this.write();
        Path path = this.getDestinationPath();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Defcon.Logger.INSTANCE.info("Moving pack to " + it);
            if (this.getFolderHash(this.getTempPath()) == this.getFolderHash(it)) {
                v2 = false;
            } else {
                if (Files.exists(it, new LinkOption[0])) {
                    File file = it.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    FilesKt.deleteRecursively((File)file);
                }
                Files.move(this.getTempPath(), it, new CopyOption[0]);
                Defcon.Logger.INSTANCE.info("Pack moved to " + it);
                v2 = true;
            }
        } else {
            v2 = moved = false;
        }
        if (moved) {
            this.onMove();
        }
        if (this.zipDestination) {
            Path path2 = this.getDestinationPath();
            if (path2 != null) {
                Path it = path2;
                boolean bl = false;
                Path zipPath = Paths.get(it + ".zip", new String[0]);
                if (Files.exists(zipPath, new LinkOption[0])) {
                    Files.delete(zipPath);
                }
                Intrinsics.checkNotNull((Object)zipPath);
                this.zipFolder(it, zipPath, true);
                this.onPackCreated(zipPath);
                File file = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
        } else {
            Path path3 = this.getDestinationPath();
            if (path3 != null) {
                Path it = path3;
                boolean bl = false;
                this.onPackCreated(it);
            }
        }
        File file = this.getTempPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
        this.packRegistered = true;
    }

    private final int getFolderHash(Path pathToHash) {
        return Files.exists(pathToHash, new LinkOption[0]) ? Files.walk(pathToHash, new FileVisitOption[0]).filter(arg_0 -> PackRegister.getFolderHash$lambda$4(PackRegister::getFolderHash$lambda$3, arg_0)).map(arg_0 -> PackRegister.getFolderHash$lambda$6(PackRegister::getFolderHash$lambda$5, arg_0)).reduce(PackRegister::getFolderHash$lambda$7).hashCode() : 0;
    }

    protected abstract void write();

    public void onPackCreated(@NotNull Path finalPath) {
        Intrinsics.checkNotNullParameter((Object)finalPath, (String)"finalPath");
    }

    public void onMove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFolder(Path folderPath, Path zipPath, boolean zipFolderPathContent) {
        Closeable closeable = new FileOutputStream(((Object)zipPath).toString());
        Throwable throwable = null;
        try {
            Unit unit;
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(fos);
            Throwable throwable2 = null;
            try {
                Unit unit2;
                ZipOutputStream zipOut = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                File fileToZip = folderPath.toFile();
                if (fileToZip.isDirectory()) {
                    if (zipFolderPathContent) {
                        File[] fileArray = fileToZip.listFiles();
                        if (fileArray != null) {
                            File[] $this$forEach$iv = fileArray;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int i = 0; i < n; ++i) {
                                File element$iv;
                                File childFile = element$iv = $this$forEach$iv[i];
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)childFile);
                                String string = childFile.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                this.zipFile(childFile, string, zipOut);
                            }
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                    } else {
                        Intrinsics.checkNotNull((Object)fileToZip);
                        String string = fileToZip.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this.zipFile(fileToZip, string, zipOut);
                        unit2 = Unit.INSTANCE;
                    }
                } else {
                    Intrinsics.checkNotNull((Object)fileToZip);
                    String string = fileToZip.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.zipFile(fileToZip, string, zipOut);
                    unit2 = Unit.INSTANCE;
                }
                unit = unit2;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit3 = unit;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void zipFolder$default(PackRegister packRegister, Path path, Path path2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: zipFolder");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        packRegister.zipFolder(path, path2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            Object entryName = StringsKt.endsWith$default((String)fileName, (String)"/", (boolean)false, (int)2, null) ? fileName : fileName + "/";
            zipOut.putNextEntry(new ZipEntry((String)entryName));
            zipOut.closeEntry();
            File[] fileArray = fileToZip.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File childFile = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)childFile);
                    this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
            }
            return;
        }
        Closeable closeable = new FileInputStream(fileToZip);
        Throwable throwable = null;
        try {
            FileInputStream fis = (FileInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] buffer = new byte[8192];
            int length = 0;
            while (true) {
                int n;
                int it = n = fis.read(buffer);
                boolean bl2 = false;
                length = it;
                if (n < 0) break;
                zipOut.write(buffer, 0, length);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyFoldersFromResource(@NotNull String resourceFolderPath, @NotNull Path targetPath, @NotNull Set<String> excludedPaths) {
        Intrinsics.checkNotNullParameter((Object)resourceFolderPath, (String)"resourceFolderPath");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter(excludedPaths, (String)"excludedPaths");
        File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        Closeable closeable = new JarFile(jarFile);
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                Long l;
                Comparable comparable;
                String initialPath;
                String $i$f$any2;
                boolean bl2;
                JarEntry entry;
                block15: {
                    entry = entries.nextElement();
                    Iterable $this$any$iv = excludedPaths;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)resourceFolderPath, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)entry.getName(), (String)"getName(...)");
                int n = resourceFolderPath.length();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$any2.substring(n), (String)"substring(...)");
                Path target = targetPath.resolve(initialPath);
                if (entry.isDirectory()) {
                    Defcon.Logger.INSTANCE.info("Creating directory " + target);
                    comparable = Files.createDirectories(target, new FileAttribute[0]);
                    continue;
                }
                Closeable closeable2 = jar.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    InputStream input = (InputStream)closeable2;
                    boolean bl4 = false;
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    l = Files.copy(input, target, copyOptionArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                comparable = l;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void copyFoldersFromResource$default(PackRegister packRegister, String string, Path path, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyFoldersFromResource");
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        packRegister.copyFoldersFromResource(string, path, set);
    }

    @NotNull
    protected final String createMcmetaJson(int formatVersion, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return StringsKt.trimIndent((String)("\n        {\n            \"pack\": {\n                \"pack_format\": " + formatVersion + ",\n                \"description\": \"" + description + "\"\n            }\n        }\n        "));
    }

    private static final boolean getFolderHash$lambda$3(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private static final boolean getFolderHash$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getFolderHash$lambda$5(Path path) {
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return FilesKt.readText$default((File)file, null, (int)1, null);
    }

    private static final String getFolderHash$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String getFolderHash$lambda$7(String acc, String s) {
        return acc + s;
    }

    public PackRegister() {
        this(false, 1, null);
    }
}

