/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.customassets.fonts.AbstractCustomFont;
import me.mochibit.defcon.customassets.fonts.FontData;
import me.mochibit.defcon.customassets.items.AbstractCustomItemModel;
import me.mochibit.defcon.customassets.items.ModelData;
import me.mochibit.defcon.customassets.sounds.AbstractCustomSound;
import me.mochibit.defcon.customassets.sounds.SoundData;
import me.mochibit.defcon.customassets.sounds.SoundInfo;
import me.mochibit.defcon.registers.PackRegister;
import me.mochibit.defcon.registers.packformat.FormatReader;
import me.mochibit.defcon.server.ResourcePackServer;
import net.kyori.adventure.resource.ResourcePackInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0014J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006*"}, d2={"Lme/mochibit/defcon/registers/ResourcePackRegister;", "Lme/mochibit/defcon/registers/PackRegister;", "<init>", "()V", "pluginResourcePackPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "tempPath", "getTempPath", "()Ljava/nio/file/Path;", "destinationPath", "getDestinationPath", "jsonParser", "Lorg/json/simple/parser/JSONParser;", "packageName", "", "resourcePackHash", "resourcePackInfo", "Lnet/kyori/adventure/resource/ResourcePackInfo;", "localResourcePackInfo", "generateResourcePackHash", "path", "packInfo", "getPackInfo", "()Lnet/kyori/adventure/resource/ResourcePackInfo;", "localPackInfo", "getLocalPackInfo", "onPackCreated", "", "finalPath", "write", "copyStaticAssets", "localAssetsPath", "minecraftPath", "fontPath", "processCustomFonts", "processCustomSounds", "processCustomItemModels", "createItemModelFile", "targetMinecraftPath", "modelData", "Lme/mochibit/defcon/customassets/items/ModelData;", "Defcon"})
@SourceDebugExtension(value={"SMAP\nResourcePackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePackRegister.kt\nme/mochibit/defcon/registers/ResourcePackRegister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
public final class ResourcePackRegister
extends PackRegister {
    @NotNull
    public static final ResourcePackRegister INSTANCE = new ResourcePackRegister();
    private static final Path pluginResourcePackPath;
    @NotNull
    private static final Path tempPath;
    @Nullable
    private static final Path destinationPath;
    @NotNull
    private static final JSONParser jsonParser;
    private static final String packageName;
    @Nullable
    private static String resourcePackHash;
    @Nullable
    private static ResourcePackInfo resourcePackInfo;
    @Nullable
    private static ResourcePackInfo localResourcePackInfo;

    private ResourcePackRegister() {
        super(true);
    }

    @Override
    @NotNull
    public Path getTempPath() {
        return tempPath;
    }

    @Override
    @Nullable
    public Path getDestinationPath() {
        return destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String generateResourcePackHash(Path path) {
        Closeable closeable = new BufferedInputStream(new FileInputStream(path.toFile()));
        Throwable throwable = null;
        try {
            BufferedInputStream bis = (BufferedInputStream)closeable;
            boolean bl = false;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = bis.read(buffer);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                digest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            String string = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, ResourcePackRegister::generateResourcePackHash$lambda$2$lambda$1, (int)30, null);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final ResourcePackInfo getPackInfo() {
        ResourcePackInfo resourcePackInfo;
        ResourcePackInfo resourcePackInfo2 = ResourcePackRegister.resourcePackInfo;
        if (resourcePackInfo2 != null) {
            ResourcePackInfo it = resourcePackInfo2;
            boolean bl = false;
            return it;
        }
        String string = resourcePackHash;
        if (string == null) {
            ResourcePackRegister $this$_get_packInfo__u24lambda_u244 = this;
            boolean bl = false;
            Defcon.Logger.INSTANCE.warn("Resource pack hash is null !");
            string = "0";
        }
        String hash = string;
        ResourcePackInfo resourcePackInfo3 = ResourcePackInfo.resourcePackInfo().uri(URI.create("http://" + Defcon.Companion.getInstance().getServer().getIp() + ":" + ResourcePackServer.INSTANCE.getPort() + "/resourcepack.zip")).hash(hash).build();
        Intrinsics.checkNotNullExpressionValue((Object)resourcePackInfo3, (String)"build(...)");
        ResourcePackInfo it = resourcePackInfo = resourcePackInfo3;
        boolean bl = false;
        ResourcePackRegister.resourcePackInfo = it;
        return resourcePackInfo;
    }

    @NotNull
    public final ResourcePackInfo getLocalPackInfo() {
        ResourcePackInfo resourcePackInfo;
        ResourcePackInfo resourcePackInfo2 = localResourcePackInfo;
        if (resourcePackInfo2 != null) {
            ResourcePackInfo it = resourcePackInfo2;
            boolean bl = false;
            return it;
        }
        String string = resourcePackHash;
        if (string == null) {
            ResourcePackRegister $this$_get_localPackInfo__u24lambda_u247 = this;
            boolean bl = false;
            Defcon.Logger.INSTANCE.warn("Resource pack hash is null !");
            string = "0";
        }
        String hash = string;
        ResourcePackInfo.Builder builder = ResourcePackInfo.resourcePackInfo().uri(URI.create("http://127.0.0.1:" + ResourcePackServer.INSTANCE.getPort() + "/resourcepack.zip"));
        String string2 = resourcePackHash;
        if (string2 == null) {
            string2 = "0";
        }
        ResourcePackInfo resourcePackInfo3 = builder.hash(string2).build();
        Intrinsics.checkNotNullExpressionValue((Object)resourcePackInfo3, (String)"build(...)");
        ResourcePackInfo it = resourcePackInfo = resourcePackInfo3;
        boolean bl = false;
        localResourcePackInfo = it;
        return resourcePackInfo;
    }

    @Override
    public void onPackCreated(@NotNull Path finalPath) {
        Intrinsics.checkNotNullParameter((Object)finalPath, (String)"finalPath");
        if (!Files.exists(finalPath, new LinkOption[0]) || Files.size(finalPath) == 0L) {
            Defcon.Logger.INSTANCE.warn("Resource pack creation failed, file does not exist or is empty at " + finalPath);
            return;
        }
        Defcon.Logger.INSTANCE.info("Resource pack created at " + finalPath);
        resourcePackHash = this.generateResourcePackHash(finalPath);
        resourcePackInfo = null;
        localResourcePackInfo = null;
        ResourcePackServer.INSTANCE.updatePackPath(finalPath);
    }

    @Override
    protected void write() {
        Defcon.Logger.INSTANCE.info("Creating resource pack for Defcon");
        try {
            Path localAssetsPath = Paths.get(this.getTempPath() + "/assets", new String[0]);
            Path minecraftPath = Paths.get(localAssetsPath + "/minecraft", new String[0]);
            Path fontPath = Paths.get(minecraftPath + "/font", new String[0]);
            Files.createDirectories(localAssetsPath, new FileAttribute[0]);
            Files.createDirectories(minecraftPath, new FileAttribute[0]);
            Files.createDirectories(fontPath, new FileAttribute[0]);
            String mcmetaContent = this.createMcmetaJson(FormatReader.INSTANCE.getPackFormat().getResourceVersion(), "Defcon auto-generated resource pack");
            Path path = Paths.get(this.getTempPath() + "/pack.mcmeta", new String[0]);
            String string = mcmetaContent;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(path, byArray, new OpenOption[0]);
            Intrinsics.checkNotNull((Object)localAssetsPath);
            Intrinsics.checkNotNull((Object)minecraftPath);
            Intrinsics.checkNotNull((Object)fontPath);
            this.copyStaticAssets(localAssetsPath, minecraftPath, fontPath);
            this.processCustomFonts(fontPath);
            this.processCustomSounds(minecraftPath);
            this.processCustomItemModels(minecraftPath);
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.warn("Error creating resource pack: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyStaticAssets(Path localAssetsPath, Path minecraftPath, Path fontPath) {
        this.copyFoldersFromResource("assets/", localAssetsPath, SetsKt.setOf((Object)"assets/defcon"));
        try {
            String jarFile = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            Closeable closeable = new JarFile(jarFile);
            Throwable throwable = null;
            try {
                Long l;
                ZipEntry fontEntry;
                JarFile jar = (JarFile)closeable;
                boolean bl = false;
                ZipEntry zipEntry = fontEntry = jar.getEntry("assets/defcon/fonts/default.json");
                if (zipEntry != null) {
                    long l2;
                    ZipEntry it = zipEntry;
                    boolean bl2 = false;
                    Closeable closeable2 = jar.getInputStream(it);
                    Throwable throwable2 = null;
                    try {
                        InputStream input = (InputStream)closeable2;
                        boolean bl3 = false;
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        l2 = Files.copy(input, fontPath.resolve("default.json"), copyOptionArray);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    l = l2;
                } else {
                    l = null;
                }
                Long l3 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.info("Error copying default.json: " + e.getMessage());
        }
        PackRegister packRegister = this;
        Path path = Paths.get(minecraftPath + "/textures", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        PackRegister.copyFoldersFromResource$default(packRegister, "assets/defcon/textures/", path, null, 4, null);
        PackRegister packRegister2 = this;
        Path path2 = Paths.get(minecraftPath + "/models", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        PackRegister.copyFoldersFromResource$default(packRegister2, "assets/defcon/models/", path2, null, 4, null);
        PackRegister packRegister3 = this;
        Path path3 = Paths.get(minecraftPath + "/optifine", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        PackRegister.copyFoldersFromResource$default(packRegister3, "assets/defcon/optifine/", path3, null, 4, null);
        PackRegister packRegister4 = this;
        Path path4 = Paths.get(minecraftPath + "/sounds", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        PackRegister.copyFoldersFromResource$default(packRegister4, "assets/defcon/sounds/", path4, null, 4, null);
    }

    private final void processCustomFonts(Path fontPath) {
        try {
            Path defaultJsonPath = fontPath.resolve("default.json");
            BufferedReader jsonReader = Files.newBufferedReader(defaultJsonPath);
            Object object = jsonParser.parse((Reader)jsonReader);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.simple.JSONObject");
            JSONObject defaultJson = (JSONObject)object;
            Object object2 = defaultJson.get((Object)"providers");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.json.simple.JSONArray");
            JSONArray providers = (JSONArray)object2;
            jsonReader.close();
            Set<Class<AbstractCustomFont>> customFonts = new Reflections(packageName + ".customassets.fonts.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomFont.class);
            for (Class<AbstractCustomFont> fontClass : customFonts) {
                try {
                    AbstractCustomFont fontInstance = fontClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    FontData fontData = fontInstance.getFontData();
                    JSONObject newFont = new JSONObject();
                    ((Map)newFont).put("file", fontData.getFile());
                    ((Map)newFont).put("type", fontData.getType());
                    ((Map)newFont).put("ascent", fontData.getAscent());
                    ((Map)newFont).put("height", fontData.getHeight());
                    JSONArray chars = new JSONArray();
                    chars.addAll((Collection)fontData.getChars());
                    ((Map)newFont).put("chars", chars);
                    ((Map)newFont).put("advances", fontData.getAdvances());
                    providers.add((Object)newFont);
                }
                catch (Exception e) {
                    Defcon.Logger.INSTANCE.info("Error processing font " + fontClass.getSimpleName() + ": " + e.getMessage());
                }
            }
            String string = defaultJson.toJSONString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(defaultJsonPath, byArray, new OpenOption[0]);
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.info("Error processing custom fonts: " + e.getMessage());
        }
    }

    private final void processCustomSounds(Path minecraftPath) {
        try {
            JSONObject soundsJson = new JSONObject();
            Set<Class<AbstractCustomSound>> customSounds = new Reflections(packageName + ".customassets.sounds.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomSound.class);
            for (Class<AbstractCustomSound> soundClass : customSounds) {
                try {
                    AbstractCustomSound soundInstance = soundClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    SoundInfo soundInfo = soundInstance.getSoundInfo();
                    SoundData soundData = soundInstance.getSoundData();
                    JSONObject soundObject = new JSONObject();
                    JSONArray soundsArray = new JSONArray();
                    soundsArray.addAll((Collection)soundData.getSounds());
                    ((Map)soundObject).put("sounds", soundsArray);
                    String soundKey = ((CharSequence)soundInfo.directory()).length() > 0 ? soundInfo.directory() + "." + soundInfo.name() : soundInfo.name();
                    ((Map)soundsJson).put(soundKey, soundObject);
                }
                catch (Exception e) {
                    Defcon.Logger.INSTANCE.info("Error processing sound " + soundClass.getSimpleName() + ": " + e.getMessage());
                }
            }
            Path path = minecraftPath.resolve("sounds.json");
            String string = soundsJson.toJSONString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(path, byArray, new OpenOption[0]);
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.info("Error processing custom sounds: " + e.getMessage());
        }
    }

    private final void processCustomItemModels(Path minecraftPath) {
        try {
            Path targetModelsPath = Paths.get(minecraftPath + "/models", new String[0]);
            Set<Class<AbstractCustomItemModel>> customItemModels = new Reflections(packageName + ".customassets.items.definitions", new Scanner[0]).getSubTypesOf(AbstractCustomItemModel.class);
            for (Class<AbstractCustomItemModel> itemModelClass : customItemModels) {
                try {
                    AbstractCustomItemModel itemModelInstance = itemModelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.createItemModelFile(minecraftPath, itemModelInstance.getModelData());
                }
                catch (Exception e) {
                    Defcon.Logger.INSTANCE.info("Error processing item model " + itemModelClass.getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.info("Error processing custom item models: " + e.getMessage());
        }
    }

    private final void createItemModelFile(Path targetMinecraftPath, ModelData modelData) {
        JSONObject model = new JSONObject();
        ((Map)model).put("type", modelData.getType());
        ((Map)model).put("model", modelData.getModel());
        Path path = targetMinecraftPath.resolve("items/" + modelData.getName() + ".json");
        String string = model.toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private static final CharSequence generateResourcePackHash$lambda$2$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    static {
        Path path = pluginResourcePackPath = Defcon.Companion.getInstance().getDataFolder().toPath().resolve("resourcepack");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginResourcePackPath");
        String[] stringArray = new String[]{"defcon_temp_resourcepack"};
        Path path2 = Paths.get(((Object)path).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        tempPath = path2;
        Path path3 = pluginResourcePackPath;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"pluginResourcePackPath");
        String[] stringArray2 = new String[]{"defcon_resourcepack"};
        destinationPath = Paths.get(((Object)path3).toString(), stringArray2);
        jsonParser = new JSONParser();
        packageName = Defcon.class.getPackage().getName();
    }
}

