/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.classes.PluginConfiguration;
import me.mochibit.defcon.classes.StructureBlock;
import me.mochibit.defcon.classes.structures.StructureQuery;
import me.mochibit.defcon.enums.BlockDataKey;
import me.mochibit.defcon.enums.ConfigurationStorage;
import me.mochibit.defcon.enums.StructureBehaviour;
import me.mochibit.defcon.exceptions.BlockNotRegisteredException;
import me.mochibit.defcon.extensions.ByteKt;
import me.mochibit.defcon.interfaces.PluginBlock;
import me.mochibit.defcon.interfaces.StructureDefinition;
import me.mochibit.defcon.registers.BlockRegister;
import me.mochibit.defcon.utils.FloodFill3D;
import me.mochibit.defcon.utils.Geometry;
import me.mochibit.defcon.utils.MetaManager;
import me.mochibit.lib.customblockdata.CustomBlockData;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/mochibit/defcon/registers/StructureRegister;", "", "<init>", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerStructures", "", "searchByBlock", "Lme/mochibit/defcon/classes/structures/StructureQuery;", "location", "Lorg/bukkit/Location;", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nStructureRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureRegister.kt\nme/mochibit/defcon/registers/StructureRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 MetaManager.kt\nme/mochibit/defcon/utils/MetaManager\n*L\n1#1,246:1\n1869#2:247\n739#2,9:248\n739#2,9:261\n1870#2:274\n1056#2:288\n2393#2,14:289\n2393#2,14:303\n2393#2,14:317\n37#3:257\n36#3,3:258\n37#3:270\n36#3,3:271\n38#4,13:275\n*S KotlinDebug\n*F\n+ 1 StructureRegister.kt\nme/mochibit/defcon/registers/StructureRegister\n*L\n59#1:247\n81#1:248,9\n105#1:261,9\n59#1:274\n170#1:288\n173#1:289,14\n174#1:303,14\n175#1:317,14\n81#1:257\n81#1:258,3\n105#1:270\n105#1:271,3\n153#1:275,13\n*E\n"})
public final class StructureRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JavaPlugin pluginInstance = JavaPlugin.getPlugin(Defcon.class);
    @NotNull
    private static HashMap<String, StructureDefinition> registeredStructures = new HashMap();

    /*
     * WARNING - void declaration
     */
    public final void registerStructures() {
        HashMap<String, PluginBlock> hashMap;
        registeredStructures = new HashMap();
        FileConfiguration structureConfig = PluginConfiguration.Companion.get(ConfigurationStorage.Structures).getConfig();
        try {
            hashMap = BlockRegister.Companion.getRegisteredBlocks();
        }
        catch (BlockNotRegisteredException e) {
            throw new RuntimeException("Unable to register structures, blocks not registered");
        }
        HashMap<String, PluginBlock> registeredBlocks = hashMap;
        List list = structureConfig.getList("enabled-structures");
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            List interfaceBlockNames;
            List blockDispositions;
            Object rawDefinition2;
            List rawDefinitions;
            String behaviour;
            Object element$iv;
            Object item = element$iv = iterator.next();
            boolean bl = false;
            StructureDefinition structure = null;
            if (structureConfig.getString(item + ".behaviour") == null) continue;
            boolean requiresInterface = structureConfig.getBoolean(item + ".requires-interface");
            StructureBehaviour structureBehaviour = StructureBehaviour.Companion.fromString(behaviour);
            try {
                if (structureBehaviour != null) {
                    GenericDeclaration genericDeclaration = structureBehaviour.getStructureClass();
                    structure = genericDeclaration != null && (genericDeclaration = ((Class)genericDeclaration).getDeclaredConstructor(new Class[0])) != null ? (StructureDefinition)((Constructor)genericDeclaration).newInstance(new Object[0]) : null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (structure == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)structureConfig.getStringList(item + ".block-set"), (String)"getStringList(...)");
            HashMap customBlockDefinitions = new HashMap();
            for (Object rawDefinition2 : rawDefinitions) {
                void $this$toTypedArray$iv;
                List list2;
                Collection $this$dropLastWhile$iv;
                Intrinsics.checkNotNull((Object)rawDefinition2);
                Object object = (CharSequence)rawDefinition2;
                Regex regex = new Regex(":");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] definition = thisCollection$iv.toArray(new String[0]);
                ((Map)customBlockDefinitions).put(definition[0], definition[1]);
            }
            Intrinsics.checkNotNull((Object)structureConfig.getList(item + ".block-dispositions"));
            rawDefinition2 = blockDispositions.iterator();
            while (rawDefinition2.hasNext()) {
                Object set;
                Object blockDisposition = rawDefinition2.next();
                Intrinsics.checkNotNull(blockDisposition, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>");
                LinkedHashMap blockDispositionDef = (LinkedHashMap)blockDisposition;
                Set set2 = blockDispositionDef.keySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
                if (CollectionsKt.first((Iterable)set2) == null) continue;
                Object v = ((Map)blockDispositionDef).get(set);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>");
                LinkedHashMap effectiveBlockDisposition = (LinkedHashMap)v;
                Object v2 = ((Map)effectiveBlockDisposition).get("y");
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Int");
                int y = (Integer)v2;
                Object v3 = ((Map)effectiveBlockDisposition).get("dispositions");
                Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List dispositions = (List)v3;
                int n = ((Collection)dispositions).size();
                for (int z = 0; z < n; ++z) {
                    void $this$toTypedArray$iv;
                    List list3;
                    Collection $this$dropLastWhile$iv;
                    Object object = String.valueOf(dispositions.get(z));
                    Regex regex = new Regex(",");
                    int n2 = 0;
                    object = regex.split((CharSequence)object, n2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl3 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list3 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list3;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] dispositionBlocks = thisCollection$iv.toArray(new String[0]);
                    int n3 = dispositionBlocks.length;
                    for (int x = 0; x < n3; ++x) {
                        String blockName = dispositionBlocks[x];
                        if (!customBlockDefinitions.containsKey(blockName)) {
                            throw new RuntimeException("Unable to register structure, block variable " + blockName + " is unknown");
                        }
                        String blockId = (String)customBlockDefinitions.get(blockName);
                        HashMap<String, PluginBlock> hashMap2 = registeredBlocks;
                        if (hashMap2 == null || (hashMap2 = hashMap2.get(blockId)) == null) {
                            throw new RuntimeException("Unable to register structure, block " + blockId + " is unknown");
                        }
                        HashMap<String, PluginBlock> block = hashMap2;
                        structure.getStructureBlocks().add(new StructureBlock((PluginBlock)((Object)block), x, y, z, false, 16, null));
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)structureConfig.getStringList(item + ".interface-blocks"), (String)"getStringList(...)");
            for (String interfaceBlockName : interfaceBlockNames) {
                if (!customBlockDefinitions.containsKey(interfaceBlockName)) {
                    throw new RuntimeException("Unable to register structure, block variable " + interfaceBlockName + " is unknown");
                }
                String blockId = (String)customBlockDefinitions.get(interfaceBlockName);
                for (StructureBlock structureBlock : structure.getStructureBlocks()) {
                    if (!Intrinsics.areEqual((Object)structureBlock.getBlock().getId(), (Object)blockId)) continue;
                    structureBlock.setInterface(true);
                }
            }
            Function1[] function1Array = new Function1[]{StructureRegister::registerStructures$lambda$5$lambda$2, StructureRegister::registerStructures$lambda$5$lambda$3, StructureRegister::registerStructures$lambda$5$lambda$4};
            structure.setStructureBlocks(CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)structure.getStructureBlocks(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))));
            structure.setRequiredInterface(requiresInterface);
            structure.setId(String.valueOf(item));
            JavaPlugin javaPlugin = this.pluginInstance;
            Intrinsics.checkNotNull((Object)javaPlugin);
            javaPlugin.getLogger().info("Registered structure " + structure + ".id");
            ((Map)registeredStructures).put(String.valueOf(item), structure);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StructureQuery searchByBlock(@NotNull Location location) {
        Object t;
        Object t2;
        Object t3;
        StructureDefinition foundStructure;
        String foundStructureId;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        List foundStructures = TypeIntrinsics.asMutableList(new ArrayList());
        MetaManager metaManager = MetaManager.INSTANCE;
        BlockDataKey key$iv = BlockDataKey.StructureId;
        boolean $i$f$getBlockData = false;
        Block block = location.getWorld().getBlockAt(location);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlockAt(...)");
        Block block$iv = block;
        PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
        PersistentDataType<?, ?> dataType$iv = this_$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(String.class));
        Object object = blockData$iv.get(key$iv.getKey(), dataType$iv);
        if (object == null) {
            v2 = null;
        } else {
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            Object value$iv = object2;
            v2 = foundStructureId = String.class == Boolean.class ? (String)((Object)Boolean.valueOf(ByteKt.toBoolean((Byte)value$iv))) : (String)value$iv;
        }
        if (foundStructureId != null && (foundStructure = registeredStructures.get(foundStructureId)) != null) {
            foundStructures.add(foundStructure);
            List<Location> list = Collections.singletonList(location);
            Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
            return new StructureQuery(foundStructures, list);
        }
        List pluginBlockLocations = FloodFill3D.getFloodFill$default(FloodFill3D.INSTANCE, location, 200, false, true, 4, null);
        if (pluginBlockLocations.isEmpty()) {
            return new StructureQuery(foundStructures, pluginBlockLocations);
        }
        Iterable $this$sortedBy$iv = pluginBlockLocations;
        boolean $i$f$sortedBy = false;
        pluginBlockLocations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Location it = (Location)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getY());
                it = (Location)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getY()));
            }
        });
        Iterable $this$minBy$iv = pluginBlockLocations;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t3 = minElem$iv;
        } else {
            Location it = (Location)minElem$iv;
            boolean bl = false;
            double minValue$iv = it.getX();
            do {
                Object e$iv = iterator$iv.next();
                Location it2 = (Location)e$iv;
                boolean bl2 = false;
                double v$iv = it2.getX();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t3 = minElem$iv;
        }
        Location minX = (Location)t3;
        Iterable $this$minBy$iv2 = pluginBlockLocations;
        boolean $i$f$minByOrThrow2 = false;
        Iterator iterator$iv2 = $this$minBy$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv2 = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t2 = minElem$iv2;
        } else {
            Location it = (Location)minElem$iv2;
            boolean bl = false;
            double minValue$iv = it.getY();
            do {
                Object e$iv = iterator$iv2.next();
                Location it3 = (Location)e$iv;
                boolean bl3 = false;
                double v$iv = it3.getY();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv2 = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t2 = minElem$iv2;
        }
        Location minY = (Location)t2;
        Iterable $this$minBy$iv3 = pluginBlockLocations;
        boolean $i$f$minByOrThrow3 = false;
        Iterator iterator$iv3 = $this$minBy$iv3.iterator();
        if (!iterator$iv3.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv3 = iterator$iv3.next();
        if (!iterator$iv3.hasNext()) {
            t = minElem$iv3;
        } else {
            Location it = (Location)minElem$iv3;
            boolean bl = false;
            double minValue$iv = it.getZ();
            do {
                Object e$iv = iterator$iv3.next();
                Location it4 = (Location)e$iv;
                boolean bl4 = false;
                double v$iv = it4.getZ();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv3 = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv3.hasNext());
            t = minElem$iv3;
        }
        Location minZ = (Location)t;
        List relativeStructureBlocks = new ArrayList();
        for (Location pluginBlockLocation : pluginBlockLocations) {
            PluginBlock pluginBlock;
            if (BlockRegister.Companion.getBlock(pluginBlockLocation) == null) continue;
            double relativeX = pluginBlockLocation.getX() - minX.getX();
            double relativeY = pluginBlockLocation.getY() - minY.getY();
            double relativeZ = pluginBlockLocation.getZ() - minZ.getZ();
            StructureBlock structureBlock = new StructureBlock(pluginBlock, (int)relativeX, (int)relativeY, (int)relativeZ, false, 16, null);
            relativeStructureBlocks.add(structureBlock);
        }
        if (relativeStructureBlocks.isEmpty()) {
            return new StructureQuery(foundStructures, pluginBlockLocations);
        }
        Function1[] function1Array = new Function1[]{StructureRegister::searchByBlock$lambda$10, StructureRegister::searchByBlock$lambda$11, StructureRegister::searchByBlock$lambda$12};
        relativeStructureBlocks = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)relativeStructureBlocks, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
        block4: for (Object e : registeredStructures.values()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            StructureDefinition registeredStructure = (StructureDefinition)e;
            if (registeredStructure.getStructureBlocks().size() != relativeStructureBlocks.size()) continue;
            List<StructureBlock> regBlocks = registeredStructure.getStructureBlocks();
            for (int rotations = 0; rotations < 3; ++rotations) {
                boolean isSame = true;
                int n = ((Collection)regBlocks).size();
                for (int i = 0; i < n; ++i) {
                    StructureBlock registeredStructureBlock = regBlocks.get(i);
                    StructureBlock relativeStructureBlock = (StructureBlock)relativeStructureBlocks.get(i);
                    if (!Intrinsics.areEqual((Object)registeredStructureBlock.getBlock().getId(), (Object)relativeStructureBlock.getBlock().getId())) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getX() != relativeStructureBlock.getX()) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getY() != relativeStructureBlock.getY()) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getZ() == relativeStructureBlock.getZ()) continue;
                    isSame = false;
                    break;
                }
                if (isSame) {
                    foundStructures.add(registeredStructure);
                    continue block4;
                }
                relativeStructureBlocks = Geometry.rotateStructureBlockPlaneXZ$default(Geometry.INSTANCE, relativeStructureBlocks, 0.0f, 2, null);
            }
        }
        return new StructureQuery(foundStructures, pluginBlockLocations);
    }

    private static final Comparable registerStructures$lambda$5$lambda$2(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getY());
    }

    private static final Comparable registerStructures$lambda$5$lambda$3(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getZ());
    }

    private static final Comparable registerStructures$lambda$5$lambda$4(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getX());
    }

    private static final Comparable searchByBlock$lambda$10(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getY());
    }

    private static final Comparable searchByBlock$lambda$11(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getZ());
    }

    private static final Comparable searchByBlock$lambda$12(StructureBlock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getX());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/mochibit/defcon/registers/StructureRegister$Companion;", "", "<init>", "()V", "registeredStructures", "Ljava/util/HashMap;", "", "Lme/mochibit/defcon/interfaces/StructureDefinition;", "Lkotlin/collections/HashMap;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

