/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.threading.jobs;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.mochibit.defcon.threading.jobs.Schedulable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/mochibit/defcon/threading/jobs/ScheduledCompositionJob;", "T", "Lme/mochibit/defcon/threading/jobs/Schedulable;", "valueSupplier", "Ljava/util/function/Supplier;", "breakupCondition", "Ljava/util/function/Predicate;", "valueConsumer", "Ljava/util/function/Consumer;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Predicate;Ljava/util/function/Consumer;)V", "getValueSupplier", "()Ljava/util/function/Supplier;", "getBreakupCondition", "()Ljava/util/function/Predicate;", "getValueConsumer", "()Ljava/util/function/Consumer;", "failed", "", "compute", "", "shouldBeRescheduled", "Defcon"})
public final class ScheduledCompositionJob<T>
implements Schedulable {
    @NotNull
    private final Supplier<T> valueSupplier;
    @NotNull
    private final Predicate<T> breakupCondition;
    @NotNull
    private final Consumer<T> valueConsumer;
    private boolean failed;

    public ScheduledCompositionJob(@NotNull Supplier<T> valueSupplier, @NotNull Predicate<T> breakupCondition, @NotNull Consumer<T> valueConsumer) {
        Intrinsics.checkNotNullParameter(valueSupplier, (String)"valueSupplier");
        Intrinsics.checkNotNullParameter(breakupCondition, (String)"breakupCondition");
        Intrinsics.checkNotNullParameter(valueConsumer, (String)"valueConsumer");
        this.valueSupplier = valueSupplier;
        this.breakupCondition = breakupCondition;
        this.valueConsumer = valueConsumer;
    }

    @NotNull
    public final Supplier<T> getValueSupplier() {
        return this.valueSupplier;
    }

    @NotNull
    public final Predicate<T> getBreakupCondition() {
        return this.breakupCondition;
    }

    @NotNull
    public final Consumer<T> getValueConsumer() {
        return this.valueConsumer;
    }

    @Override
    public void compute() {
        T element = this.valueSupplier.get();
        if (this.breakupCondition.test(element)) {
            this.failed = true;
            return;
        }
        this.valueConsumer.accept(element);
    }

    @Override
    public boolean shouldBeRescheduled() {
        return !this.failed;
    }
}

