/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.utils;

import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.utils.ChunkCache;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0014\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001c"}, d2={"Lme/mochibit/defcon/utils/ChunkCache;", "", "world", "Lorg/bukkit/World;", "maxAccessCount", "", "<init>", "(Lorg/bukkit/World;I)V", "cleanupCache", "", "localCache", "me/mochibit/defcon/utils/ChunkCache$localCache$1", "Lme/mochibit/defcon/utils/ChunkCache$localCache$1;", "getChunkSnapshot", "Lorg/bukkit/ChunkSnapshot;", "x", "z", "preloadChunks", "chunkKeys", "", "", "highestBlockYAt", "getBlockMaterial", "Lorg/bukkit/Material;", "y", "getBlockData", "Lorg/bukkit/block/data/BlockData;", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nChunkCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkCache.kt\nme/mochibit/defcon/utils/ChunkCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n384#2,7:129\n1869#3,2:136\n*S KotlinDebug\n*F\n+ 1 ChunkCache.kt\nme/mochibit/defcon/utils/ChunkCache\n*L\n91#1:129,7\n105#1:136,2\n*E\n"})
public final class ChunkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final int maxAccessCount;
    @NotNull
    private final localCache.1 localCache;
    @NotNull
    private static final Companion.sharedChunkCache.1 sharedChunkCache = new LinkedHashMap<Pair<? extends Integer, ? extends Integer>, SoftReference<ChunkSnapshot>>(){
        private final int MAX_SHARED_CACHE_SIZE;
        {
            this.MAX_SHARED_CACHE_SIZE = 100;
        }

        protected boolean removeEldestEntry(Map.Entry<Pair<Integer, Integer>, SoftReference<ChunkSnapshot>> eldest) {
            Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
            return this.size() > this.MAX_SHARED_CACHE_SIZE;
        }
    };
    @NotNull
    private static final ConcurrentHashMap<World, ChunkCache> instanceCache = new ConcurrentHashMap();

    private ChunkCache(World world, int maxAccessCount) {
        this.world = world;
        this.maxAccessCount = maxAccessCount;
        this.localCache = new LinkedHashMap<Pair<? extends Integer, ? extends Integer>, ChunkSnapshot>(this){
            final /* synthetic */ ChunkCache this$0;
            {
                this.this$0 = $receiver;
                super(16, 0.75f, true);
            }

            protected boolean removeEldestEntry(Map.Entry<Pair<Integer, Integer>, ChunkSnapshot> eldest) {
                Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
                if (this.size() > ChunkCache.access$getMaxAccessCount$p(this.this$0)) {
                    ((Map)ChunkCache.access$getSharedChunkCache$cp()).put(eldest.getKey(), new SoftReference<ChunkSnapshot>(eldest.getValue()));
                    return true;
                }
                return false;
            }
        };
    }

    /* synthetic */ ChunkCache(World world, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        this(world, n);
    }

    public final void cleanupCache() {
        sharedChunkCache.clear();
    }

    private final ChunkSnapshot getChunkSnapshot(int x, int z) {
        Object object;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        Pair key = TuplesKt.to((Object)chunkX, (Object)chunkZ);
        Map $this$getOrPut$iv = this.localCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            ChunkSnapshot chunkSnapshot;
            ChunkSnapshot sharedSnapshot;
            boolean bl = false;
            SoftReference softReference = (SoftReference)sharedChunkCache.get(key);
            Object object2 = sharedSnapshot = softReference != null ? (ChunkSnapshot)softReference.get() : null;
            if (sharedSnapshot != null) {
                chunkSnapshot = sharedSnapshot;
            } else {
                ChunkSnapshot chunkSnapshot2 = this.world.getChunkAt(chunkX, chunkZ).getChunkSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)chunkSnapshot2, (String)"getChunkSnapshot(...)");
                ChunkSnapshot snapshot = chunkSnapshot2;
                ((Map)sharedChunkCache).put(key, new SoftReference<ChunkSnapshot>(snapshot));
                chunkSnapshot = snapshot;
            }
            ChunkSnapshot answer$iv = chunkSnapshot;
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ChunkSnapshot)object;
    }

    public final void preloadChunks(@NotNull Set<Long> chunkKeys) {
        Intrinsics.checkNotNullParameter(chunkKeys, (String)"chunkKeys");
        Iterable $this$forEach$iv = chunkKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long key = ((Number)element$iv).longValue();
            boolean bl = false;
            int chunkX = (int)(key >> 32);
            int chunkZ = (int)key;
            Pair chunkKey = TuplesKt.to((Object)chunkX, (Object)chunkZ);
            if (this.localCache.containsKey(chunkKey)) continue;
            this.getChunkSnapshot(chunkX, chunkZ);
        }
    }

    public final int highestBlockYAt(int x, int z) {
        return this.getChunkSnapshot(x, z).getHighestBlockYAt(x & 0xF, z & 0xF);
    }

    @NotNull
    public final Material getBlockMaterial(int x, int y, int z) {
        if (y < 0 || y > 255) {
            return Material.AIR;
        }
        Material material = this.getChunkSnapshot(x, z).getBlockType(x & 0xF, y, z & 0xF);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getBlockType(...)");
        return material;
    }

    @NotNull
    public final BlockData getBlockData(int x, int y, int z) {
        if (y < 0 || y > 255) {
            BlockData blockData = Bukkit.createBlockData((Material)Material.AIR);
            Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"createBlockData(...)");
            return blockData;
        }
        BlockData blockData = this.getChunkSnapshot(x, z).getBlockData(x & 0xF, y, z & 0xF);
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
        return blockData;
    }

    public /* synthetic */ ChunkCache(World world, int maxAccessCount, DefaultConstructorMarker $constructor_marker) {
        this(world, maxAccessCount);
    }

    public static final /* synthetic */ int access$getMaxAccessCount$p(ChunkCache $this) {
        return $this.maxAccessCount;
    }

    public static final /* synthetic */ Companion.sharedChunkCache.1 access$getSharedChunkCache$cp() {
        return sharedChunkCache;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000*\u0001\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/mochibit/defcon/utils/ChunkCache$Companion;", "", "<init>", "()V", "sharedChunkCache", "me/mochibit/defcon/utils/ChunkCache$Companion$sharedChunkCache$1", "Lme/mochibit/defcon/utils/ChunkCache$Companion$sharedChunkCache$1;", "instanceCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/World;", "Lme/mochibit/defcon/utils/ChunkCache;", "getInstance", "world", "maxAccessCount", "", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChunkCache getInstance(@NotNull World world, int maxAccessCount) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            ChunkCache chunkCache = instanceCache.computeIfAbsent(world, arg_0 -> Companion.getInstance$lambda$1(arg_0 -> Companion.getInstance$lambda$0(world, maxAccessCount, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)chunkCache, (String)"computeIfAbsent(...)");
            return chunkCache;
        }

        public static /* synthetic */ ChunkCache getInstance$default(Companion companion, World world, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 20;
            }
            return companion.getInstance(world, n);
        }

        private static final ChunkCache getInstance$lambda$0(World $world, int $maxAccessCount, World it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ChunkCache($world, $maxAccessCount, null);
        }

        private static final ChunkCache getInstance$lambda$1(Function1 $tmp0, Object p0) {
            return (ChunkCache)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

