/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.utils;

import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import me.mochibit.defcon.utils.MathFunctions;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013J.\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/mochibit/defcon/utils/ColorUtils;", "", "<init>", "()V", "rgbPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parseColor", "", "inputString", "", "inputStrings", "", "stripColor", "lerpColor", "Lorg/bukkit/Color;", "a", "b", "t", "", "darkenColor", "color", "factor", "lightenColor", "randomizeColorBrightness", "darkenMax", "darkenMin", "lightenMax", "lightenMin", "Defcon"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    private static final Pattern rgbPattern = Pattern.compile("&#[a-fA-F0-9]{6}");

    private ColorUtils() {
    }

    @NotNull
    public final String parseColor(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Matcher match = rgbPattern.matcher(inputString);
        String parsedString = inputString;
        while (match.find()) {
            String color;
            Intrinsics.checkNotNullExpressionValue((Object)parsedString.substring(match.start(), match.end()), (String)"substring(...)");
            parsedString = StringsKt.replace$default((String)parsedString, (String)color, (String)("" + ChatColor.of((String)StringsKt.replace$default((String)color, (String)"&", (String)"", (boolean)false, (int)4, null))), (boolean)false, (int)4, null);
            match = rgbPattern.matcher(parsedString);
        }
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)parsedString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateAlternateColorCodes(...)");
        parsedString = string;
        return parsedString;
    }

    @NotNull
    public final List<String> parseColor(@NotNull List<String> inputStrings) {
        Intrinsics.checkNotNullParameter(inputStrings, (String)"inputStrings");
        ListIterator<String> i = inputStrings.listIterator();
        while (i.hasNext()) {
            String element = i.next();
            i.set(this.parseColor(element));
        }
        return inputStrings;
    }

    @NotNull
    public final String stripColor(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        String string = ChatColor.stripColor((String)inputString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripColor(...)");
        return string;
    }

    @NotNull
    public final Color lerpColor(@NotNull Color a, @NotNull Color b, double t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        double r = MathFunctions.INSTANCE.lerp((double)a.getRed(), (double)b.getRed(), t);
        double g = MathFunctions.INSTANCE.lerp((double)a.getGreen(), (double)b.getGreen(), t);
        double bl = MathFunctions.INSTANCE.lerp((double)a.getBlue(), (double)b.getBlue(), t);
        Color color = Color.fromRGB((int)((int)r), (int)((int)g), (int)((int)bl));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"fromRGB(...)");
        return color;
    }

    @NotNull
    public final Color darkenColor(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (factor <= 0.0) {
            return color;
        }
        int r = (int)RangesKt.coerceIn((double)((double)color.getRed() * factor), (double)0.0, (double)255.0);
        int g = (int)RangesKt.coerceIn((double)((double)color.getGreen() * factor), (double)0.0, (double)255.0);
        int b = (int)RangesKt.coerceIn((double)((double)color.getBlue() * factor), (double)0.0, (double)255.0);
        Color color2 = Color.fromRGB((int)r, (int)g, (int)b);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromRGB(...)");
        return color2;
    }

    @NotNull
    public final Color lightenColor(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (factor <= 0.0) {
            return color;
        }
        int r = (int)RangesKt.coerceIn((double)((double)color.getRed() + (double)(255 - color.getRed()) * factor), (double)0.0, (double)255.0);
        int g = (int)RangesKt.coerceIn((double)((double)color.getGreen() + (double)(255 - color.getGreen()) * factor), (double)0.0, (double)255.0);
        int b = (int)RangesKt.coerceIn((double)((double)color.getBlue() + (double)(255 - color.getBlue()) * factor), (double)0.0, (double)255.0);
        Color color2 = Color.fromRGB((int)r, (int)g, (int)b);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromRGB(...)");
        return color2;
    }

    @NotNull
    public final Color randomizeColorBrightness(@NotNull Color color, double darkenMax, double darkenMin, double lightenMax, double lightenMin) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        double factor = 0.0;
        if (Random.Default.nextBoolean()) {
            if (darkenMax == 0.0 && darkenMin == 0.0) {
                return color;
            }
            factor = darkenMin == darkenMax ? darkenMin : Random.Default.nextDouble(darkenMin, darkenMax);
            return this.darkenColor(color, factor);
        }
        if (lightenMax == 0.0 && lightenMin == 0.0) {
            return color;
        }
        factor = lightenMin == lightenMax ? lightenMin : Random.Default.nextDouble(lightenMin, lightenMax);
        return this.lightenColor(color, factor);
    }
}

