/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.classes.StructureBlock;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\b\u0002\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001f\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013JE\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u001c0\u0019\u00a2\u0006\u0002\u0010\u001dJ=\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u001c0\u0019\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0006J \u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bJ \u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0.2\u0006\u0010/\u001a\u00020,J\u001e\u00100\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b\u00a8\u00061"}, d2={"Lme/mochibit/defcon/utils/Geometry;", "", "<init>", "()V", "getConvexHullXZ", "", "Lorg/bukkit/Location;", "points", "", "rotateLocationPlaneXZ", "angle", "", "rotateStructureBlockPlaneXZ", "Lme/mochibit/defcon/classes/StructureBlock;", "structureBlocks", "getMinY", "position", "maxDepth", "", "(Lorg/bukkit/Location;Ljava/lang/Double;)Lorg/bukkit/Location;", "getMinYUsingSnapshotFromCache", "Lorg/joml/Vector3d;", "world", "Lorg/bukkit/World;", "chunkSnapshotCache", "", "Lkotlin/Pair;", "", "Lorg/bukkit/ChunkSnapshot;", "(Lorg/bukkit/World;Lorg/joml/Vector3d;Ljava/lang/Double;Ljava/util/Map;)Lorg/joml/Vector3d;", "(Lorg/bukkit/Location;Ljava/lang/Double;Ljava/util/Map;)Lorg/bukkit/Location;", "getMinYUsingSnapshot", "givenChunkSnapshot", "(Lorg/bukkit/Location;Ljava/lang/Double;Lorg/bukkit/ChunkSnapshot;)Lorg/bukkit/Location;", "lengthSq", "x", "y", "z", "loc", "ccw", "p1", "p2", "p3", "packIntegerCoordinates", "", "unpackIntegerCoordinates", "Lkotlin/Triple;", "packed", "wangNoise", "Defcon"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\nme/mochibit/defcon/utils/Geometry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1999#2,14:217\n1999#2,14:231\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\nme/mochibit/defcon/utils/Geometry\n*L\n95#1:217,14\n108#1:231,14\n*E\n"})
public final class Geometry {
    @NotNull
    public static final Geometry INSTANCE = new Geometry();

    private Geometry() {
    }

    @NotNull
    public final List<Location> getConvexHullXZ(@NotNull List<? extends Location> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Location lowestPoint = points.get(0);
        for (Location location : points) {
            if (location.getBlockZ() < lowestPoint.getBlockZ()) {
                lowestPoint = location;
                continue;
            }
            if (location.getBlockZ() != lowestPoint.getBlockZ() || location.getBlockX() >= lowestPoint.getBlockX()) continue;
            lowestPoint = location;
        }
        List sortedPoints = new ArrayList(points);
        sortedPoints.remove(lowestPoint);
        Location location = lowestPoint;
        CollectionsKt.sortWith((List)sortedPoints, (arg_0, arg_1) -> Geometry.getConvexHullXZ$lambda$1((arg_0, arg_1) -> Geometry.getConvexHullXZ$lambda$0(location, arg_0, arg_1), arg_0, arg_1));
        sortedPoints.add(0, lowestPoint);
        Stack hull = new Stack();
        if (sortedPoints.size() < 3) {
            return sortedPoints;
        }
        hull.push(sortedPoints.get(0));
        hull.push(sortedPoints.get(1));
        int n = sortedPoints.size();
        for (int i = 2; i < n; ++i) {
            Location top = (Location)hull.pop();
            while (hull.size() > 0) {
                Object e = hull.peek();
                Intrinsics.checkNotNullExpressionValue(e, (String)"peek(...)");
                Location location2 = (Location)e;
                Location location3 = top;
                Intrinsics.checkNotNull((Object)location3);
                if (this.ccw(location2, location3, (Location)sortedPoints.get(i)) > 0) break;
                top = (Location)hull.pop();
            }
            hull.push(top);
            hull.push(sortedPoints.get(i));
        }
        List convexHull = new ArrayList();
        while (!hull.empty()) {
            Object e = hull.pop();
            Intrinsics.checkNotNullExpressionValue(e, (String)"pop(...)");
            convexHull.add(e);
        }
        return convexHull;
    }

    @NotNull
    public final List<Location> rotateLocationPlaneXZ(@NotNull List<? extends Location> points, float angle) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        List rotatedPoints = new ArrayList();
        for (Location location : points) {
            Object v0;
            double rotatedX = location.getZ();
            Iterable $this$maxByOrNull$iv = points;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Location it = (Location)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = it.getX();
                    do {
                        Object e$iv = iterator$iv.next();
                        Location it2 = (Location)e$iv;
                        boolean bl2 = false;
                        double v$iv = it2.getX();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            double rotatedZ = ((Location)v0).getX() - location.getX();
            rotatedPoints.add(new Location(location.getWorld(), rotatedX, location.getY(), rotatedZ));
        }
        return rotatedPoints;
    }

    public static /* synthetic */ List rotateLocationPlaneXZ$default(Geometry geometry, List list, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 90.0f;
        }
        return geometry.rotateLocationPlaneXZ(list, f);
    }

    @NotNull
    public final List<StructureBlock> rotateStructureBlockPlaneXZ(@NotNull List<StructureBlock> structureBlocks, float angle) {
        Intrinsics.checkNotNullParameter(structureBlocks, (String)"structureBlocks");
        List rotatedStructure = new ArrayList();
        for (StructureBlock structureBlock : structureBlocks) {
            Object v0;
            int rotatedX = structureBlock.getZ();
            Iterable $this$maxByOrNull$iv = structureBlocks;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    StructureBlock it = (StructureBlock)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getX();
                    do {
                        Object e$iv = iterator$iv.next();
                        StructureBlock it2 = (StructureBlock)e$iv;
                        $i$a$-maxByOrNull-Geometry$rotateStructureBlockPlaneXZ$rotatedZ$1 = false;
                        int v$iv = it2.getX();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            int rotatedZ = ((StructureBlock)v0).getX() - structureBlock.getX();
            rotatedStructure.add(new StructureBlock(structureBlock.getBlock(), rotatedX, structureBlock.getY(), rotatedZ, structureBlock.isInterface()));
        }
        return rotatedStructure;
    }

    public static /* synthetic */ List rotateStructureBlockPlaneXZ$default(Geometry geometry, List list, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 90.0f;
        }
        return geometry.rotateStructureBlockPlaneXZ(list, f);
    }

    @NotNull
    public final Location getMinY(@NotNull Location position, @Nullable Double maxDepth) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Location location = position.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location clonedPosition = location;
        clonedPosition.setY(RangesKt.coerceAtMost((double)clonedPosition.getY(), (double)(clonedPosition.getWorld().getMaxHeight() - 1)));
        int depth = 0;
        while (clonedPosition.getWorld().getBlockAt(clonedPosition).getType() == Material.AIR && (maxDepth == null || (double)depth < maxDepth) && clonedPosition.getY() >= (double)position.getWorld().getMinHeight()) {
            clonedPosition.subtract(0.0, 1.0, 0.0);
            ++depth;
        }
        return clonedPosition;
    }

    public static /* synthetic */ Location getMinY$default(Geometry geometry, Location location, Double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = null;
        }
        return geometry.getMinY(location, d);
    }

    @NotNull
    public final Vector3d getMinYUsingSnapshotFromCache(@NotNull World world, @NotNull Vector3d position, @Nullable Double maxDepth, @NotNull Map<Pair<Integer, Integer>, ChunkSnapshot> chunkSnapshotCache) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(chunkSnapshotCache, (String)"chunkSnapshotCache");
        position.y = this.getMinYUsingSnapshotFromCache(new Location(world, position.x, position.y, position.z), maxDepth, chunkSnapshotCache).getY();
        return position;
    }

    @NotNull
    public final Location getMinYUsingSnapshotFromCache(@NotNull Location position, @Nullable Double maxDepth, @NotNull Map<Pair<Integer, Integer>, ChunkSnapshot> chunkSnapshotCache) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(chunkSnapshotCache, (String)"chunkSnapshotCache");
        int blockX = position.getBlockX();
        int blockZ = position.getBlockZ();
        return chunkSnapshotCache.containsKey(new Pair((Object)(blockX >> 4), (Object)(blockZ >> 4))) ? this.getMinYUsingSnapshot(position, maxDepth, chunkSnapshotCache.get(new Pair((Object)(blockX >> 4), (Object)(blockZ >> 4)))) : Geometry.getMinYUsingSnapshot$default(this, position, maxDepth, null, 4, null);
    }

    @NotNull
    public final Location getMinYUsingSnapshot(@NotNull Location position, @Nullable Double maxDepth, @Nullable ChunkSnapshot givenChunkSnapshot) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Location location = position.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location clonedPosition = location;
        ChunkSnapshot chunkSnapshot = givenChunkSnapshot;
        if (chunkSnapshot == null) {
            ChunkSnapshot chunkSnapshot2 = position.getChunk().getChunkSnapshot();
            chunkSnapshot = chunkSnapshot2;
            Intrinsics.checkNotNullExpressionValue((Object)chunkSnapshot2, (String)"getChunkSnapshot(...)");
        }
        ChunkSnapshot chunkSnapshot3 = chunkSnapshot;
        int localX = position.getBlockX() & 0xF;
        int localZ = position.getBlockZ() & 0xF;
        clonedPosition.setY((double)chunkSnapshot3.getHighestBlockYAt(localX, localZ));
        return clonedPosition;
    }

    public static /* synthetic */ Location getMinYUsingSnapshot$default(Geometry geometry, Location location, Double d, ChunkSnapshot chunkSnapshot, int n, Object object) {
        if ((n & 4) != 0) {
            chunkSnapshot = null;
        }
        return geometry.getMinYUsingSnapshot(location, d, chunkSnapshot);
    }

    public final double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public final double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    public final double lengthSq(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return this.lengthSq(loc.getX(), loc.getY(), loc.getZ());
    }

    private final int ccw(Location p1, Location p2, Location p3) {
        return (p2.getBlockX() - p1.getBlockX()) * (p3.getBlockZ() - p1.getBlockZ()) - (p2.getBlockZ() - p1.getBlockZ()) * (p3.getBlockX() - p1.getBlockX());
    }

    public final long packIntegerCoordinates(int x, int y, int z) {
        return (long)x & 0x1FFFFFL | ((long)y & 0x1FFFFFL) << 21 | ((long)z & 0x1FFFFFL) << 42;
    }

    @NotNull
    public final Triple<Integer, Integer, Integer> unpackIntegerCoordinates(long packed) {
        int x = (int)(packed & 0x1FFFFFL);
        int y = (int)(packed >> 21 & 0x1FFFFFL);
        int z = (int)(packed >> 42 & 0x1FFFFFL);
        return new Triple((Object)x, (Object)y, (Object)z);
    }

    public final double wangNoise(int x, int y, int z) {
        long hash = (long)x * (long)0x1F1F1F1F;
        hash ^= (long)y * (long)668265261;
        hash ^= (long)z * 2246822519L;
        hash ^= hash >>> 15;
        hash *= 3266489917L;
        hash ^= hash >>> 16;
        return (double)(hash & Integer.MAX_VALUE) / 2.147483647E9;
    }

    private static final int getConvexHullXZ$lambda$0(Location $finalLowestPoint, Location p1, Location p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        double angle1 = Math.atan2(p1.getBlockZ() - $finalLowestPoint.getBlockZ(), p1.getBlockX() - $finalLowestPoint.getBlockX());
        double angle2 = Math.atan2(p2.getBlockZ() - $finalLowestPoint.getBlockZ(), p2.getBlockX() - $finalLowestPoint.getBlockX());
        return Double.compare(angle1, angle2);
    }

    private static final int getConvexHullXZ$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

